/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WrongIdDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(WrongIdDetector.class, Scope.RESOURCE_FILE_SCOPE);
    private final Set<String> mGlobalIds = new HashSet<String>(100);
    private Set<String> mFileIds;
    private Set<String> mDeclaredIds;
    private List<Pair<String, Location.Handle>> mHandles;
    private List<Element> mRelativeLayouts;
    public static final Issue UNKNOWN_ID = Issue.create((String)"UnknownId", (String)"Reference to an unknown id", (String)"The `@+id/` syntax refers to an existing id, or creates a new one if it has not already been defined elsewhere. However, this means that if you have a typo in your reference, or if the referred view no longer exists, you do not get a warning since the id will be created on demand. This check catches errors where you have renamed an id without updating all of the references to it.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.FATAL, (Implementation)new Implementation(WrongIdDetector.class, Scope.ALL_RESOURCES_SCOPE, new EnumSet[]{Scope.RESOURCE_FILE_SCOPE}));
    public static final Issue NOT_SIBLING = Issue.create((String)"NotSibling", (String)"Invalid Constraints", (String)"Layout constraints in a given `ConstraintLayout` or `RelativeLayout` should reference other views within the same relative layout (but not itself!)", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue INVALID = Issue.create((String)"InvalidId", (String)"Invalid ID declaration", (String)"An id definition **must** be of the form `@+id/yourname`. The tools have not rejected strings of the form `@+foo/bar` in the past, but that was an error, and could lead to tricky errors because of the way the id integers are assigned.\n\nIf you really want to have different \"scopes\" for your id's, use prefixes instead, such as `login_button1` and `login_button2`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue UNKNOWN_ID_LAYOUT = Issue.create((String)"UnknownIdInLayout", (String)"Reference to an id that is not in the current layout", (String)"The `@+id/` syntax refers to an existing id, or creates a new one if it has not already been defined elsewhere. However, this means that if you have a typo in your reference, or if the referred view no longer exists, you do not get a warning since the id will be created on demand.\n\nThis is sometimes intentional, for example where you are referring to a view which is provided in a different layout via an include. However, it is usually an accident where you have a typo or you have renamed a view without updating all the references to it.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)new Implementation(WrongIdDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("id");
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("RelativeLayout", "item", "android.support.percent.PercentRelativeLayout", "android.support.constraint.ConstraintLayout");
    }

    public void beforeCheckFile(Context context) {
        this.mFileIds = new HashSet<String>();
        this.mRelativeLayouts = null;
    }

    public void afterCheckFile(Context context) {
        if (this.mRelativeLayouts != null) {
            if (!context.getProject().getReportIssues()) {
                return;
            }
            for (Element layout : this.mRelativeLayouts) {
                this.checkLayout(context, layout);
            }
        }
        this.mFileIds = null;
        if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            this.checkHandles(context);
        }
    }

    private void checkLayout(Context context, Element layout) {
        HashSet ids = Sets.newHashSetWithExpectedSize((int)20);
        for (Element child : XmlUtils.getSubTags((Node)layout)) {
            String id = child.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
            if (id == null || id.isEmpty()) continue;
            ids.add(id);
        }
        boolean isConstraintLayout = layout.getTagName().equals("android.support.constraint.ConstraintLayout");
        for (Element element : XmlUtils.getSubTags((Node)layout)) {
            String selfId = LintUtils.stripIdPrefix((String)element.getAttributeNS("http://schemas.android.com/apk/res/android", "id"));
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)attributes.item(i);
                String value = attr.getValue();
                if (value.startsWith("@+id/") || value.startsWith("@id/")) {
                    String localName = attr.getLocalName();
                    if (localName == null || !localName.startsWith("layout_") || !"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI()) && !"http://schemas.android.com/apk/res-auto".equals(attr.getNamespaceURI())) continue;
                    this.checkIdReference(context, layout, ids, isConstraintLayout, selfId, attr, value);
                    continue;
                }
                if (!isConstraintLayout || !"constraint_referenced_ids".equals(attr.getLocalName())) continue;
                Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
                for (String id : splitter.split((CharSequence)value)) {
                    this.checkIdReference(context, layout, ids, true, selfId, attr, id);
                }
            }
        }
    }

    private void checkIdReference(Context context, Element layout, Set<String> ids, boolean isConstraintLayout, String selfId, Attr attr, String id) {
        if (!WrongIdDetector.idDefined(this.mFileIds, id)) {
            XmlContext xmlContext = (XmlContext)context;
            Location.Handle handle = xmlContext.createLocationHandle((Node)attr);
            handle.setClientData((Object)attr);
            if (this.mHandles == null) {
                this.mHandles = new ArrayList<Pair<String, Location.Handle>>();
            }
            this.mHandles.add((Pair<String, Location.Handle>)Pair.of((Object)id, (Object)handle));
        } else {
            String parentId;
            if (ids.contains(id)) {
                if (!"id".equals(attr.getLocalName()) && !selfId.isEmpty() && id.endsWith(selfId) && LintUtils.stripIdPrefix((String)id).equals(selfId)) {
                    XmlContext xmlContext = (XmlContext)context;
                    String message = String.format("Cannot be relative to self: id=%1$s, %2$s=%3$s", selfId, attr.getLocalName(), selfId);
                    Location location = xmlContext.getLocation((Node)attr);
                    xmlContext.report(NOT_SIBLING, (Node)attr, location, message);
                }
                return;
            }
            if (id.startsWith("@+id/") ? ids.contains("@id/" + LintUtils.stripIdPrefix((String)id)) : (id.startsWith("@id/") ? ids.contains("@+id/" + LintUtils.stripIdPrefix((String)id)) : ids.contains("@+id/" + id))) {
                return;
            }
            if (isConstraintLayout && (parentId = LintUtils.stripIdPrefix((String)layout.getAttributeNS("http://schemas.android.com/apk/res/android", "id"))).equals(LintUtils.stripIdPrefix((String)id))) {
                return;
            }
            if (context.isEnabled(NOT_SIBLING)) {
                XmlContext xmlContext = (XmlContext)context;
                String message = String.format("`%1$s` is not a sibling in the same `%2$s`", id, isConstraintLayout ? "ConstraintLayout" : "RelativeLayout");
                Location location = xmlContext.getLocation((Node)attr);
                xmlContext.report(NOT_SIBLING, (Node)attr, location, message);
            }
        }
    }

    public void afterCheckProject(Context context) {
        if (context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            this.checkHandles(context);
        }
    }

    private void checkHandles(Context context) {
        if (this.mHandles != null) {
            boolean checkSameLayout = context.isEnabled(UNKNOWN_ID_LAYOUT);
            boolean checkExists = context.isEnabled(UNKNOWN_ID);
            boolean projectScope = context.getScope().contains(Scope.ALL_RESOURCE_FILES);
            for (Pair<String, Location.Handle> pair : this.mHandles) {
                Location.Handle handle;
                String id = (String)pair.getFirst();
                boolean isBound = projectScope ? WrongIdDetector.idDefined(this.mGlobalIds, id) : this.idDefined(context, id, context.file);
                LintClient client = context.getClient();
                if (!isBound && checkExists && (projectScope || client.supportsProjectResources())) {
                    List<String> suggestions;
                    AbstractResourceRepository resources;
                    handle = (Location.Handle)pair.getSecond();
                    boolean isDeclared = WrongIdDetector.idDefined(this.mDeclaredIds, id);
                    id = LintUtils.stripIdPrefix((String)id);
                    HashSet spellingDictionary = this.mGlobalIds;
                    if (!projectScope && client.supportsProjectResources() && (resources = client.getResourceRepository(context.getProject(), true, false)) != null) {
                        spellingDictionary = Sets.newHashSet((Iterable)resources.getItemsOfType(ResourceType.ID));
                        spellingDictionary.remove(id);
                    }
                    String suggestionMessage = (suggestions = WrongIdDetector.getSpellingSuggestions(id, spellingDictionary)).size() > 1 ? String.format(" Did you mean one of {%2$s} ?", id, Joiner.on((String)", ").join(suggestions)) : (!suggestions.isEmpty() ? String.format(" Did you mean %2$s ?", id, suggestions.get(0)) : "");
                    String message = isDeclared ? String.format("The id \"`%1$s`\" is defined but not assigned to any views.%2$s", id, suggestionMessage) : String.format("The id \"`%1$s`\" is not defined anywhere.%2$s", id, suggestionMessage);
                    WrongIdDetector.report(context, UNKNOWN_ID, handle, message);
                    continue;
                }
                if (!checkSameLayout || projectScope && !isBound || !id.startsWith("@+id/")) continue;
                handle = (Location.Handle)pair.getSecond();
                WrongIdDetector.report(context, UNKNOWN_ID_LAYOUT, handle, String.format("The id \"`%1$s`\" is not referring to any views in this layout", LintUtils.stripIdPrefix((String)id)));
            }
        }
    }

    private static void report(Context context, Issue issue, Location.Handle handle, String message) {
        Location location = handle.resolve();
        Object clientData = handle.getClientData();
        if (clientData instanceof Node && context.getDriver().isSuppressed(null, issue, (Node)clientData)) {
            return;
        }
        context.report(issue, location, message);
    }

    public void visitElement(XmlContext context, Element element) {
        String tagName = element.getTagName();
        if (tagName.equals("item")) {
            String name;
            String type = element.getAttribute("type");
            if ("id".equals(type) && !(name = element.getAttribute("name")).isEmpty()) {
                if (this.mDeclaredIds == null) {
                    this.mDeclaredIds = Sets.newHashSet();
                }
                this.mDeclaredIds.add("@id/" + name);
            }
        } else {
            assert (tagName.equals("RelativeLayout") || tagName.equals("android.support.percent.PercentRelativeLayout") || tagName.equals("android.support.constraint.ConstraintLayout"));
            if (this.mRelativeLayouts == null) {
                this.mRelativeLayouts = new ArrayList<Element>();
            }
            this.mRelativeLayouts.add(element);
        }
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        assert (attribute.getName().equals("id") || attribute.getLocalName().equals("id"));
        String id = attribute.getValue();
        this.mFileIds.add(id);
        this.mGlobalIds.add(id);
        if (id.equals("@+id/") || id.equals("@id/") || "@+id".equals("@id/")) {
            String message = "Invalid id: missing value";
            context.report(INVALID, (Node)attribute, context.getLocation((Node)attribute), message);
        } else if (id.startsWith("@+") && !id.startsWith("@+id/") && !id.startsWith("@+android:id/") || id.startsWith("@+id/") && id.indexOf(47, "@+id/".length()) != -1) {
            int nameStart = id.startsWith("@+id/") ? "@+id/".length() : 2;
            String suggested = "@+id/" + id.substring(nameStart).replace('/', '_');
            String message = String.format("ID definitions **must** be of the form `@+id/name`; try using `%1$s`", suggested);
            context.report(INVALID, (Node)attribute, context.getLocation((Node)attribute), message);
        }
    }

    private static boolean idDefined(Set<String> ids, String id) {
        if (ids == null) {
            return false;
        }
        boolean definedLocally = ids.contains(id);
        if (!definedLocally) {
            if (id.startsWith("@+id/")) {
                return ids.contains("@id/" + id.substring("@+id/".length()));
            }
            if (id.startsWith("@id/")) {
                return ids.contains("@+id/" + id.substring("@id/".length()));
            }
            return ids.contains("@+id/" + id) || ids.contains("@id/" + id);
        }
        return true;
    }

    private boolean idDefined(Context context, String id, File notIn) {
        AbstractResourceRepository resources = context.getClient().getResourceRepository(context.getProject(), true, true);
        if (resources != null) {
            List items = resources.getResourceItem(ResourceType.ID, LintUtils.stripIdPrefix((String)id));
            if (items == null || items.isEmpty()) {
                return false;
            }
            for (ResourceItem item : items) {
                ResourceFile source = (ResourceFile)item.getSource();
                if (source == null) continue;
                File file = source.getFile();
                if (file.getParentFile().getName().startsWith("values")) {
                    if (this.mDeclaredIds == null) {
                        this.mDeclaredIds = Sets.newHashSet();
                    }
                    this.mDeclaredIds.add(id);
                    continue;
                }
                if (LintUtils.isSameResourceFile((File)file, (File)notIn)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<String> getSpellingSuggestions(String id, Collection<String> ids) {
        int maxDistance = id.length() >= 4 ? 2 : 1;
        ArrayListMultimap matches = ArrayListMultimap.create((int)2, (int)10);
        int count = 0;
        if (!ids.isEmpty()) {
            for (String matchWith : ids) {
                int distance = LintUtils.editDistance((String)id, (String)(matchWith = LintUtils.stripIdPrefix((String)matchWith)), (int)maxDistance);
                if (distance <= maxDistance) {
                    matches.put((Object)distance, (Object)matchWith);
                }
                if (count++ <= 100) continue;
                break;
            }
        }
        for (int i = 0; i < maxDistance; ++i) {
            Collection strings = matches.get((Object)i);
            if (strings == null || strings.isEmpty()) continue;
            ArrayList<String> suggestions = new ArrayList<String>(strings);
            Collections.sort(suggestions);
            return suggestions;
        }
        return Collections.emptyList();
    }
}

