/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.grails.builder;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.compiler.GrailsCompilerRtMarker;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.groovy.GroovyBuilderExtension;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;

public class GrailsBuilderExtension
implements GroovyBuilderExtension {
    public static final Pattern CORE_JAR_PATTERN = Pattern.compile("grails-core-(\\d[^-]*(?:-SNAPSHOT)?)\\.jar");

    @NotNull
    public Collection<String> getCompilationClassPath(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        if (context == null) {
            GrailsBuilderExtension.$$$reportNull$$$0(0);
        }
        if (chunk == null) {
            GrailsBuilderExtension.$$$reportNull$$$0(1);
        }
        for (JpsModule module : chunk.getModules()) {
            if (!GrailsBuilderExtension.shouldInjectGrails(module)) continue;
            Set<String> set = Collections.singleton(PathManager.getJarPathForClass(GrailsCompilerRtMarker.class));
            if (set == null) {
                GrailsBuilderExtension.$$$reportNull$$$0(2);
            }
            return set;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            GrailsBuilderExtension.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static boolean shouldInjectGrails(@NotNull JpsModule module) {
        if (module == null) {
            GrailsBuilderExtension.$$$reportNull$$$0(4);
        }
        String version = GrailsBuilderExtension.getGrailsVersion(module);
        return GrailsBuilderExtension.shouldInjectGrails(version);
    }

    @Contract(value="null -> false")
    private static boolean shouldInjectGrails(@Nullable String version) {
        return version != null && VersionComparatorUtil.compare((String)version, (String)"3.0") < 0;
    }

    @Nullable
    private static String getGrailsVersion(@NotNull JpsModule module) {
        if (module == null) {
            GrailsBuilderExtension.$$$reportNull$$$0(5);
        }
        String foundVersion = null;
        for (JpsDependencyElement dependencyElement : module.getDependenciesList().getDependencies()) {
            JpsLibrary library;
            if (!(dependencyElement instanceof JpsLibraryDependency) || (library = ((JpsLibraryDependency)dependencyElement).getLibrary()) == null) continue;
            for (File file : library.getFiles(JpsOrderRootType.COMPILED)) {
                Matcher matcher = CORE_JAR_PATTERN.matcher(file.getName());
                if (!matcher.matches()) continue;
                if (foundVersion == null) {
                    foundVersion = matcher.group(1);
                    continue;
                }
                if (VersionComparatorUtil.compare((String)foundVersion, (String)matcher.group(1)) == 0) continue;
                return null;
            }
        }
        return foundVersion;
    }

    @NotNull
    public Collection<String> getCompilationUnitPatchers(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        if (context == null) {
            GrailsBuilderExtension.$$$reportNull$$$0(6);
        }
        if (chunk == null) {
            GrailsBuilderExtension.$$$reportNull$$$0(7);
        }
        HashSet<String> res = new HashSet<String>();
        for (JpsModule module : chunk.getModules()) {
            String grailsVersion = GrailsBuilderExtension.getGrailsVersion(module);
            if (!GrailsBuilderExtension.shouldInjectGrails(grailsVersion)) continue;
            res.add("org.jetbrains.groovy.grails.compiler.GrailsJUnitPatcher");
            if (grailsVersion.compareTo("1.2") < 0) {
                res.add("org.jetbrains.groovy.grails.compiler.GrailsDomainClassPatcher");
                continue;
            }
            if (grailsVersion.compareTo("2.0") < 0) continue;
            res.add("org.jetbrains.groovy.grails.compiler.EmptyGrailsAwarePatcher");
            res.add("org.jetbrains.groovy.grails.compiler.Grails2_0_JUnitPatcher");
        }
        HashSet<String> hashSet = res;
        if (hashSet == null) {
            GrailsBuilderExtension.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/grails/builder/GrailsBuilderExtension";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/grails/builder/GrailsBuilderExtension";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilationClassPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilationUnitPatchers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompilationClassPath";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldInjectGrails";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGrailsVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCompilationUnitPatchers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

