/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.checkin.PolicyFailure;
import org.jetbrains.tfsIntegration.ui.CheckinParametersForm;

public class OverridePolicyWarningsForm {
    private JLabel myIconLabel;
    private TableView<PolicyFailure> myWarningsTable;
    private JCheckBox myOverrideCheckBox;
    private JTextArea myReasonTextArea;
    private JPanel myContentPane;
    private final EventDispatcher<Listener> myEventDispatcher;

    public OverridePolicyWarningsForm(final Project project, List<PolicyFailure> failures) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myIconLabel.setIcon(Messages.getWarningIcon());
        this.myWarningsTable.setTableHeader(null);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                PolicyFailure failure = (PolicyFailure)OverridePolicyWarningsForm.this.myWarningsTable.getSelectedObject();
                if (failure != null) {
                    failure.activate(project);
                    return true;
                }
                return false;
            }
        }.installOn(this.myWarningsTable);
        this.myWarningsTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{CheckinParametersForm.WARNING_COLUMN_INFO}, failures, -1));
        this.myOverrideCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OverridePolicyWarningsForm.this.myReasonTextArea.setEnabled(OverridePolicyWarningsForm.this.myOverrideCheckBox.isSelected());
                if (OverridePolicyWarningsForm.this.myReasonTextArea.isEnabled()) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)OverridePolicyWarningsForm.this.myReasonTextArea, true));
                }
                ((Listener)OverridePolicyWarningsForm.this.myEventDispatcher.getMulticaster()).stateChanged();
            }
        });
        this.myReasonTextArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ((Listener)OverridePolicyWarningsForm.this.myEventDispatcher.getMulticaster()).stateChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/tfsIntegration/ui/OverridePolicyWarningsForm$3", "textChanged"));
            }
        });
    }

    @Nullable
    public String getReason() {
        return this.myOverrideCheckBox.isSelected() ? this.myReasonTextArea.getText() : null;
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JCheckBox jCheckBox;
        TableView tableView;
        JLabel jLabel;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Before checkin can continue following policy requirements must be met:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIconLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        this.myWarningsTable = tableView = new TableView();
        jBScrollPane.setViewportView((Component)tableView);
        this.myOverrideCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Ignore warnings and continue with checkin");
        jCheckBox.setMnemonic('I');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 0, null, null, null, 1));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myReasonTextArea = jTextArea = new JTextArea();
        ((Component)jTextArea).setEnabled(false);
        jTextArea.setRows(6);
        jBScrollPane2.setViewportView(jTextArea);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Reason:");
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel3.setLabelFor(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static interface Listener
    extends EventListener {
        public void stateChanged();
    }
}

