/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.ui.SelectRevisionForm;
import org.jetbrains.tfsIntegration.ui.servertree.ServerBrowserDialog;

public class CreateBranchForm {
    private JTextField mySourceField;
    private SelectRevisionForm myRevisionForm;
    private JCheckBox myCreateLocalWorkingCopiesCheckBox;
    private TextFieldWithBrowseButton.NoPathCompletion myTargetField;
    private JPanel myContentPane;
    private JLabel myTargetLabel;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public CreateBranchForm(final Project project, final WorkspaceInfo workspace, String serverPath, boolean isDirectory) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.mySourceField.setText(serverPath);
        this.myTargetLabel.setLabelFor(this.myTargetField.getChildComponent());
        this.myTargetField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String serverPath = CreateBranchForm.this.myTargetField.getText() != null && CreateBranchForm.this.myTargetField.getText().length() > 0 ? CreateBranchForm.this.myTargetField.getText() : CreateBranchForm.this.mySourceField.getText();
                ServerBrowserDialog d = new ServerBrowserDialog(TFSBundle.message("choose.branch.target.folder.dialog.title", new Object[0]), project, workspace.getServer(), serverPath, true, true);
                if (d.showAndGet()) {
                    CreateBranchForm.this.myTargetField.setText(d.getSelectedPath());
                }
            }
        });
        ((JTextField)this.myTargetField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ((ChangeListener)CreateBranchForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(e));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/tfsIntegration/ui/CreateBranchForm$2", "textChanged"));
            }
        });
        this.myRevisionForm.init(project, workspace, serverPath, isDirectory);
    }

    public void addListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    @Nullable
    public VersionSpecBase getVersionSpec() {
        return this.myRevisionForm.getVersionSpec();
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public String getTargetPath() {
        return this.myTargetField.getText();
    }

    public boolean isCreateWorkingCopies() {
        return this.myCreateLocalWorkingCopiesCheckBox.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTargetField.getChildComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        SelectRevisionForm selectRevisionForm;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Source:");
        jLabel2.setDisplayedMnemonic('S');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySourceField = jTextField = new JTextField();
        jTextField.setEditable(false);
        ((Component)jTextField).setEnabled(true);
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myTargetLabel = jLabel = new JLabel();
        jLabel.setText("Target:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetField = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel.add((Component)noPathCompletion, new GridConstraints(3, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Branch from version", (int)0, (int)0, null, null));
        this.myRevisionForm = selectRevisionForm = new SelectRevisionForm();
        JComponent jComponent = selectRevisionForm.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myCreateLocalWorkingCopiesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Create local working copies for new branch");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

