/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.util.text.DateFormatUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Changeset;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;

public class ChangesetsTableModel
extends AbstractTableModel {
    private List<Changeset> myChangesets;

    public void setChangesets(List<Changeset> changesets) {
        this.myChangesets = changesets;
        this.fireTableDataChanged();
    }

    public List<Changeset> getChangesets() {
        return this.myChangesets;
    }

    @Override
    public String getColumnName(int column) {
        return Column.values()[column].getCaption();
    }

    @Override
    public int getRowCount() {
        return this.myChangesets != null ? this.myChangesets.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return Column.values()[columnIndex].getValue(this.myChangesets.get(rowIndex));
    }

    static enum Column {
        Changeset("Changeset", 60){

            @Override
            public String getValue(Changeset changeset) {
                return String.valueOf(changeset.getCset());
            }
        }
        ,
        Date("Date", 95){

            @Override
            public String getValue(Changeset changeset) {
                return DateFormatUtil.formatPrettyDateTime((long)changeset.getDate().getTimeInMillis());
            }
        }
        ,
        User("User", 90){

            @Override
            public String getValue(Changeset changeset) {
                return TfsUtil.getNameWithoutDomain(changeset.getOwner());
            }
        }
        ,
        Comment("Comment", 180){

            @Override
            public String getValue(Changeset changeset) {
                return changeset.getComment();
            }
        };

        private final String myCaption;
        private final int myWidth;

        private Column(String caption, int width) {
            this.myCaption = caption;
            this.myWidth = width;
        }

        public String getCaption() {
            return this.myCaption;
        }

        public abstract String getValue(Changeset var1);

        public int getWidth() {
            return this.myWidth;
        }
    }
}

