/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.conflicts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ChangeType_type0;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Conflict;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ConflictType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LockLevel;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Resolution;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ResolveResponse;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.revision.TFSContentRevision;
import org.jetbrains.tfsIntegration.core.tfs.ChangeTypeMask;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsRevisionNumber;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.conflicts.ConflictsEnvironment;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyGetOperations;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyProgress;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.ContentTriplet;

public class ResolveConflictHelper {
    @NotNull
    private final Project myProject;
    @Nullable
    private final UpdatedFiles myUpdatedFiles;
    private final Map<Conflict, WorkspaceInfo> myConflict2Workspace = new HashMap<Conflict, WorkspaceInfo>();

    public ResolveConflictHelper(Project project, Map<WorkspaceInfo, Collection<Conflict>> workspace2Conflicts, UpdatedFiles updatedFiles) {
        this.myProject = project;
        for (Map.Entry<WorkspaceInfo, Collection<Conflict>> e : workspace2Conflicts.entrySet()) {
            for (Conflict conflict : e.getValue()) {
                this.myConflict2Workspace.put(conflict, e.getKey());
            }
        }
        this.myUpdatedFiles = updatedFiles;
    }

    public void acceptMerge(final @NotNull Conflict conflict) throws TfsException, VcsException {
        String localName;
        if (conflict == null) {
            ResolveConflictHelper.$$$reportNull$$$0(0);
        }
        TFSVcs.assertTrue(ResolveConflictHelper.canMerge(conflict));
        final WorkspaceInfo workspace = this.myConflict2Workspace.get(conflict);
        final FilePath localPath = VersionControlPath.getFilePath(conflict.getSrclitem() != null ? conflict.getSrclitem() : conflict.getTgtlitem(), conflict.getYtype() == ItemType.Folder);
        final ContentTriplet contentTriplet = new ContentTriplet();
        VcsRunnable runnable = new VcsRunnable(){

            public void run() throws VcsException {
                TfsFileUtil.refreshAndFindFile(localPath);
                try {
                    if (conflict.getYtype() == ItemType.File) {
                        byte[] last;
                        byte[] current;
                        if (conflict.getCtype() == ConflictType.Merge) {
                            current = TFSContentRevision.create(ResolveConflictHelper.this.myProject, workspace, conflict.getTver(), conflict.getTitemid()).getContentAsBytes();
                            last = TFSContentRevision.create(ResolveConflictHelper.this.myProject, workspace, conflict.getYver(), conflict.getYitemid()).getContentAsBytes();
                        } else {
                            current = ((CurrentContentRevision)CurrentContentRevision.create((FilePath)localPath)).getContentAsBytes();
                            last = TFSContentRevision.create(ResolveConflictHelper.this.myProject, workspace, conflict.getTver(), conflict.getTitemid()).getContentAsBytes();
                        }
                        byte[] original = TFSContentRevision.create(ResolveConflictHelper.this.myProject, workspace, conflict.getBver(), conflict.getBitemid()).getContentAsBytes();
                        contentTriplet.baseContent = original != null ? original : ArrayUtil.EMPTY_BYTE_ARRAY;
                        contentTriplet.localContent = current != null ? current : ArrayUtil.EMPTY_BYTE_ARRAY;
                        contentTriplet.serverContent = last != null ? last : ArrayUtil.EMPTY_BYTE_ARRAY;
                    }
                }
                catch (TfsException e) {
                    throw new VcsException(TFSBundle.message("cannot.load.revisions", localPath.getPresentableUrl(), e.getMessage()));
                }
            }
        };
        if (ResolveConflictHelper.isContentConflict(conflict)) {
            VcsUtil.runVcsProcessWithProgress((VcsRunnable)runnable, (String)"Preparing merge data...", (boolean)false, (Project)this.myProject);
        }
        if (ResolveConflictHelper.isNameConflict(conflict)) {
            String mergedServerPath = ConflictsEnvironment.getNameMerger().mergeName(workspace, conflict, this.myProject);
            if (mergedServerPath == null) {
                return;
            }
            FilePath mergedLocalPath = workspace.findLocalPathByServerPath(mergedServerPath, conflict.getYtype() == ItemType.Folder, this.myProject);
            localName = mergedLocalPath.getPath();
        } else {
            localName = VersionControlPath.localPathFromTfsRepresentation(conflict.getTgtlitem());
        }
        boolean resolved = true;
        if (ResolveConflictHelper.isContentConflict(conflict)) {
            TFSVcs.assertTrue(conflict.getYtype() == ItemType.File);
            VirtualFile vFile = localPath.getVirtualFile();
            if (vFile != null) {
                try {
                    TfsFileUtil.setReadOnly(vFile, false);
                    resolved = ConflictsEnvironment.getContentMerger().mergeContent(conflict, contentTriplet, this.myProject, vFile, localName, (VcsRevisionNumber)new TfsRevisionNumber(conflict.getTver(), conflict.getTitemid()));
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
            } else {
                String errorMessage = MessageFormat.format("File ''{0}'' is missing", localPath.getPresentableUrl());
                throw new VcsException(errorMessage);
            }
        }
        if (resolved) {
            this.conflictResolved(conflict, Resolution.AcceptMerge, localName, ResolveConflictHelper.isNameConflict(conflict));
        }
    }

    public void acceptYours(@NotNull Conflict conflict) throws TfsException, VcsException {
        if (conflict == null) {
            ResolveConflictHelper.$$$reportNull$$$0(1);
        }
        String localPath = VersionControlPath.localPathFromTfsRepresentation(conflict.getSrclitem() != null ? conflict.getSrclitem() : conflict.getTgtlitem());
        this.conflictResolved(conflict, Resolution.AcceptYours, conflict.getTgtlitem(), false);
        if (this.myUpdatedFiles != null) {
            this.myUpdatedFiles.getGroupById("SKIPPED").add(localPath, TFSVcs.getKey(), null);
        }
    }

    public void acceptTheirs(@NotNull Conflict conflict) throws TfsException, IOException, VcsException {
        if (conflict == null) {
            ResolveConflictHelper.$$$reportNull$$$0(2);
        }
        String localPath = VersionControlPath.localPathFromTfsRepresentation(conflict.getTgtlitem() != null ? conflict.getTgtlitem() : conflict.getSrclitem());
        this.conflictResolved(conflict, Resolution.AcceptTheirs, localPath, false);
    }

    public void skip(@NotNull Conflict conflict) {
        if (conflict == null) {
            ResolveConflictHelper.$$$reportNull$$$0(3);
        }
        if (this.myUpdatedFiles != null) {
            String localPath = VersionControlPath.localPathFromTfsRepresentation(conflict.getSrclitem() != null ? conflict.getSrclitem() : conflict.getTgtlitem());
            this.myUpdatedFiles.getGroupById("SKIPPED").add(localPath, TFSVcs.getKey(), null);
        }
    }

    public Collection<Conflict> getConflicts() {
        return Collections.unmodifiableCollection(this.myConflict2Workspace.keySet());
    }

    public static boolean canMerge(@NotNull Conflict conflict) {
        boolean isNamespaceConflict;
        if (conflict == null) {
            ResolveConflictHelper.$$$reportNull$$$0(4);
        }
        if (conflict.getSrclitem() == null) {
            return false;
        }
        ChangeTypeMask yourChange = new ChangeTypeMask(conflict.getYchg());
        ChangeTypeMask yourLocalChange = new ChangeTypeMask(conflict.getYlchg());
        ChangeTypeMask baseChange = new ChangeTypeMask(conflict.getBchg());
        boolean bl = isNamespaceConflict = (conflict.getCtype().equals((Object)ConflictType.Get) || conflict.getCtype().equals((Object)ConflictType.Checkin)) && conflict.getIsnamecflict();
        if (!isNamespaceConflict) {
            boolean yourRenamedOrModified = yourChange.containsAny(ChangeType_type0.Rename, ChangeType_type0.Edit);
            boolean baseRenamedOrModified = baseChange.containsAny(ChangeType_type0.Rename, ChangeType_type0.Edit);
            if (yourRenamedOrModified && baseRenamedOrModified) {
                return true;
            }
        }
        if (conflict.getYtype() != ItemType.Folder && !isNamespaceConflict && conflict.getCtype().equals((Object)ConflictType.Merge) && baseChange.contains(ChangeType_type0.Edit)) {
            if (yourLocalChange.contains(ChangeType_type0.Edit)) {
                return true;
            }
            if (conflict.getIsforced()) {
                return true;
            }
            if (conflict.getTlmver() != conflict.getBver() || conflict.getYlmver() != conflict.getYver()) {
                return true;
            }
        }
        return false;
    }

    private void conflictResolved(Conflict conflict, Resolution resolution, @NotNull String newLocalPath, boolean sendPath) throws TfsException, VcsException {
        Collection<VcsException> applyErrors;
        UpdatedFiles updatedFiles;
        if (newLocalPath == null) {
            ResolveConflictHelper.$$$reportNull$$$0(5);
        }
        WorkspaceInfo workspace = this.myConflict2Workspace.get(conflict);
        VersionControlServer.ResolveConflictParams resolveConflictParams = new VersionControlServer.ResolveConflictParams(conflict.getCid(), resolution, LockLevel.Unchanged, -2, sendPath ? VersionControlPath.toTfsRepresentation(newLocalPath) : null);
        ResolveResponse response = workspace.getServer().getVCS().resolveConflict(workspace.getName(), workspace.getOwnerName(), resolveConflictParams, this.myProject, TFSBundle.message("reporting.conflict.resolved", new Object[0]));
        UpdatedFiles updatedFiles2 = updatedFiles = resolution != Resolution.AcceptMerge ? this.myUpdatedFiles : null;
        if (response.getResolveResult().getGetOperation() != null) {
            ApplyGetOperations.DownloadMode downloadMode = resolution == Resolution.AcceptTheirs ? ApplyGetOperations.DownloadMode.FORCE : ApplyGetOperations.DownloadMode.MERGE;
            Collection<VcsException> applyErrors2 = ApplyGetOperations.execute(this.myProject, workspace, Arrays.asList(response.getResolveResult().getGetOperation()), ApplyProgress.EMPTY, updatedFiles, downloadMode);
            if (!applyErrors2.isEmpty()) {
                throw TfsUtil.collectExceptions(applyErrors2);
            }
        }
        if (response.getUndoOperations().getGetOperation() != null && !(applyErrors = ApplyGetOperations.execute(this.myProject, workspace, Arrays.asList(response.getUndoOperations().getGetOperation()), ApplyProgress.EMPTY, updatedFiles, ApplyGetOperations.DownloadMode.FORCE)).isEmpty()) {
            throw TfsUtil.collectExceptions(applyErrors);
        }
        if (resolution == Resolution.AcceptMerge && this.myUpdatedFiles != null) {
            this.myUpdatedFiles.getGroupById("MERGED").add(newLocalPath, TFSVcs.getKey(), null);
        }
        this.myConflict2Workspace.remove(conflict);
    }

    private static boolean isNameConflict(@NotNull Conflict conflict) {
        if (conflict == null) {
            ResolveConflictHelper.$$$reportNull$$$0(6);
        }
        ChangeTypeMask yourChange = new ChangeTypeMask(conflict.getYchg());
        ChangeTypeMask baseChange = new ChangeTypeMask(conflict.getBchg());
        return yourChange.contains(ChangeType_type0.Rename) || baseChange.contains(ChangeType_type0.Rename);
    }

    private static boolean isContentConflict(@NotNull Conflict conflict) {
        if (conflict == null) {
            ResolveConflictHelper.$$$reportNull$$$0(7);
        }
        ChangeTypeMask yourChange = new ChangeTypeMask(conflict.getYchg());
        ChangeTypeMask baseChange = new ChangeTypeMask(conflict.getBchg());
        return yourChange.contains(ChangeType_type0.Edit) || baseChange.contains(ChangeType_type0.Edit);
    }

    public static Collection<Conflict> getUnresolvedConflicts(Collection<? extends Conflict> conflicts) {
        ArrayList<Conflict> result = new ArrayList<Conflict>();
        for (Conflict conflict : conflicts) {
            if (conflict.getIsresolved()) continue;
            TFSVcs.assertTrue(conflict.getCid() != 0);
            result.add(conflict);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflict";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLocalPath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/conflicts/ResolveConflictHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptMerge";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptYours";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptTheirs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "skip";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canMerge";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "conflictResolved";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isNameConflict";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isContentConflict";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

