/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.conflicts;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Conflict;
import java.util.List;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.conflicts.ContentMerger;
import org.jetbrains.tfsIntegration.ui.ContentTriplet;

public class DialogContentMerger
implements ContentMerger {
    @Override
    public boolean mergeContent(Conflict conflict, ContentTriplet contentTriplet, Project project, VirtualFile localFile, String localPath, VcsRevisionNumber serverVersion) throws VcsException {
        TFSVcs.assertTrue(localFile.isWritable(), localFile.getPresentableUrl() + " must be writable");
        List contents = ContainerUtil.list((Object[])new byte[][]{contentTriplet.localContent, contentTriplet.baseContent, contentTriplet.serverContent});
        MergeDialogCustomizer c = new MergeDialogCustomizer();
        String title = c.getMergeWindowTitle(localFile);
        List contentTitles = ContainerUtil.list((Object[])new String[]{c.getLeftPanelTitle(localFile), c.getCenterPanelTitle(localFile), c.getRightPanelTitle(localFile, serverVersion)});
        try {
            Ref resultRef = new Ref((Object)MergeResult.CANCEL);
            MergeRequest request = DiffRequestFactory.getInstance().createMergeRequest(project, localFile, contents, title, contentTitles, mergeResult -> resultRef.set(mergeResult));
            DiffManager.getInstance().showMerge(project, request);
            return resultRef.get() != MergeResult.CANCEL;
        }
        catch (InvalidDiffRequestException e) {
            throw new VcsException((Throwable)e);
        }
    }
}

