/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.vcs.history.VcsRevisionNumber;

public class TfsRevisionNumber
extends VcsRevisionNumber.Int {
    private static final String SEPARATOR = ":";
    public static final int UNDEFINED_ID = Integer.MIN_VALUE;
    private final int myItemId;

    public TfsRevisionNumber(int value, int itemId) {
        super(value);
        this.myItemId = itemId;
    }

    public String asString() {
        if (this.myItemId != Integer.MIN_VALUE) {
            return this.getValue() + SEPARATOR + this.myItemId;
        }
        return String.valueOf(this.getValue());
    }

    public TfsRevisionNumber(int value) {
        this(value, Integer.MIN_VALUE);
    }

    public int getItemId() {
        return this.myItemId;
    }

    public static VcsRevisionNumber tryParse(String s) {
        try {
            int i = s.indexOf(SEPARATOR);
            if (i != -1) {
                String revisionNumberString = s.substring(0, i);
                String itemIdString = s.substring(i + 1);
                int revisionNumber = Integer.parseInt(revisionNumberString);
                int changeset = Integer.parseInt(itemIdString);
                return new TfsRevisionNumber(revisionNumber, changeset);
            }
            int revisionNumber = Integer.parseInt(s);
            return new TfsRevisionNumber(revisionNumber);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getChangesetString() {
        return String.valueOf(this.getValue());
    }
}

