/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.util.containers.ContainerUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Failure;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class ResultWithFailures<T> {
    private final Collection<T> result = new ArrayList<T>();
    private final Collection<Failure> failures = new ArrayList<Failure>();

    public ResultWithFailures(@Nullable T[] result, @Nullable Failure[] failures) {
        if (result != null) {
            ContainerUtil.addAll(this.result, (Object[])result);
        }
        if (failures != null) {
            ContainerUtil.addAll(this.failures, (Object[])failures);
        }
    }

    public ResultWithFailures() {
    }

    public Collection<T> getResult() {
        return this.result;
    }

    public Collection<Failure> getFailures() {
        return this.failures;
    }

    public static <T> ResultWithFailures<T> merge(Collection<? extends ResultWithFailures<T>> results) {
        ResultWithFailures<T> merged = new ResultWithFailures<T>();
        for (ResultWithFailures<T> r : results) {
            merged.getResult().addAll(r.getResult());
            merged.getFailures().addAll(r.getFailures());
        }
        return merged;
    }
}

