/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.configuration;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.XMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.config.TfsServerConnectionHelper;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.configuration.ServerConfiguration;
import org.jetbrains.tfsIntegration.core.configuration.TfsCheckinPoliciesCompatibility;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

@com.intellij.openapi.components.State(name="org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager", storages={@Storage(value="tfs.xml")})
public class TFSConfigurationManager
implements PersistentStateComponent<State> {
    private static final String TFS_NOTIFICATION_GROUP = "TFS";
    private Map<String, ServerConfiguration> myServersConfig = new HashMap<String, ServerConfiguration>();
    private boolean myUseIdeaHttpProxy = true;
    private boolean mySupportTfsCheckinPolicies = true;
    private boolean mySupportStatefulCheckinPolicies = true;
    private boolean myReportNotInstalledCheckinPolicies = true;

    @NotNull
    public static synchronized TFSConfigurationManager getInstance() {
        TFSConfigurationManager tFSConfigurationManager = (TFSConfigurationManager)ServiceManager.getService(TFSConfigurationManager.class);
        if (tFSConfigurationManager == null) {
            TFSConfigurationManager.$$$reportNull$$$0(0);
        }
        return tFSConfigurationManager;
    }

    @Nullable
    public synchronized Credentials getCredentials(@NotNull URI serverUri) {
        ServerConfiguration serverConfiguration;
        if (serverUri == null) {
            TFSConfigurationManager.$$$reportNull$$$0(1);
        }
        return (serverConfiguration = this.getConfiguration(serverUri)) != null ? serverConfiguration.getCredentials() : null;
    }

    public synchronized boolean isAuthCanceled(URI serverUri) {
        ServerConfiguration serverConfiguration = this.getConfiguration(serverUri);
        return serverConfiguration != null && serverConfiguration.getAuthCanceledNotification() != null;
    }

    public synchronized void setAuthCanceled(final URI serverUri, @Nullable Object projectOrComponent) {
        ServerConfiguration serverConfiguration = this.getOrCreateServerConfiguration(serverUri);
        if (serverConfiguration.getAuthCanceledNotification() != null) {
            return;
        }
        final Project project = projectOrComponent instanceof Project ? (Project)projectOrComponent : null;
        Notification notification = new Notification(TFS_NOTIFICATION_GROUP, TFSBundle.message("notification.auth.canceled.title", TfsUtil.getPresentableUri(serverUri)), TFSBundle.message("notification.auth.canceled.text", new Object[0]), NotificationType.ERROR, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                try {
                    TfsServerConnectionHelper.ensureAuthenticated(project, serverUri, true);
                    notification.expire();
                }
                catch (TfsException tfsException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager$1";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        serverConfiguration.setAuthCanceledNotification(notification);
        Notifications.Bus.notify((Notification)notification, null);
    }

    @Nullable
    public URI getProxyUri(@NotNull URI serverUri) {
        if (serverUri == null) {
            TFSConfigurationManager.$$$reportNull$$$0(2);
        }
        ServerConfiguration serverConfiguration = this.getConfiguration(serverUri);
        try {
            return serverConfiguration != null && serverConfiguration.getProxyUri() != null ? new URI(serverConfiguration.getProxyUri()) : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldTryProxy(@NotNull URI serverUri) {
        ServerConfiguration serverConfiguration;
        if (serverUri == null) {
            TFSConfigurationManager.$$$reportNull$$$0(3);
        }
        return (serverConfiguration = this.getConfiguration(serverUri)) != null && serverConfiguration.getProxyUri() != null && !serverConfiguration.isProxyInaccessible();
    }

    public void setProxyInaccessible(@NotNull URI serverUri) {
        if (serverUri == null) {
            TFSConfigurationManager.$$$reportNull$$$0(4);
        }
        this.getConfiguration(serverUri).setProxyInaccessible();
    }

    public void setProxyUri(@NotNull URI serverUri, @Nullable URI proxyUri) {
        if (serverUri == null) {
            TFSConfigurationManager.$$$reportNull$$$0(5);
        }
        String proxyUriString = proxyUri != null ? proxyUri.toString() : null;
        this.getOrCreateServerConfiguration(serverUri).setProxyUri(proxyUriString);
    }

    public synchronized void storeCredentials(@NotNull URI serverUri, @NotNull Credentials credentials) {
        if (serverUri == null) {
            TFSConfigurationManager.$$$reportNull$$$0(6);
        }
        if (credentials == null) {
            TFSConfigurationManager.$$$reportNull$$$0(7);
        }
        ServerConfiguration serverConfiguration = this.getOrCreateServerConfiguration(serverUri);
        serverConfiguration.setCredentials(credentials);
        Notification notification = serverConfiguration.getAuthCanceledNotification();
        if (notification != null) {
            ApplicationManager.getApplication().invokeLater(() -> notification.expire());
        }
        serverConfiguration.setAuthCanceledNotification(null);
    }

    public synchronized void resetStoredPasswords() {
        for (ServerConfiguration serverConfiguration : this.myServersConfig.values()) {
            Credentials credentials = serverConfiguration.getCredentials();
            if (credentials == null) continue;
            credentials.resetPassword();
        }
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            TFSConfigurationManager.$$$reportNull$$$0(8);
        }
        this.myServersConfig = state.config;
        this.myUseIdeaHttpProxy = state.useIdeaHttpProxy;
        this.mySupportTfsCheckinPolicies = state.supportTfsCheckinPolicies;
        this.mySupportStatefulCheckinPolicies = state.supportStatefulCheckinPolicies;
        this.myReportNotInstalledCheckinPolicies = state.reportNotInstalledCheckinPolicies;
    }

    public State getState() {
        State state = new State();
        state.config = this.myServersConfig;
        state.supportStatefulCheckinPolicies = this.mySupportStatefulCheckinPolicies;
        state.supportTfsCheckinPolicies = this.mySupportTfsCheckinPolicies;
        state.useIdeaHttpProxy = this.myUseIdeaHttpProxy;
        state.reportNotInstalledCheckinPolicies = this.myReportNotInstalledCheckinPolicies;
        return state;
    }

    private static String getConfigKey(URI serverUri) {
        String uriString = serverUri.toString();
        if (!uriString.endsWith("/")) {
            uriString = uriString + "/";
        }
        return uriString;
    }

    @Nullable
    private ServerConfiguration getConfiguration(URI serverUri) {
        return this.myServersConfig.get(TFSConfigurationManager.getConfigKey(serverUri));
    }

    @NotNull
    private ServerConfiguration getOrCreateServerConfiguration(@NotNull URI serverUri) {
        ServerConfiguration config;
        if (serverUri == null) {
            TFSConfigurationManager.$$$reportNull$$$0(9);
        }
        if ((config = this.myServersConfig.get(TFSConfigurationManager.getConfigKey(serverUri))) == null) {
            config = new ServerConfiguration();
            this.myServersConfig.put(TFSConfigurationManager.getConfigKey(serverUri), config);
        }
        ServerConfiguration serverConfiguration = config;
        if (serverConfiguration == null) {
            TFSConfigurationManager.$$$reportNull$$$0(10);
        }
        return serverConfiguration;
    }

    public boolean serverKnown(@NotNull String instanceId) {
        if (instanceId == null) {
            TFSConfigurationManager.$$$reportNull$$$0(11);
        }
        for (ServerInfo server : Workstation.getInstance().getServers()) {
            if (!server.getGuid().equalsIgnoreCase(instanceId)) continue;
            return true;
        }
        return false;
    }

    public void remove(@NotNull URI serverUri) {
        ServerConfiguration config;
        if (serverUri == null) {
            TFSConfigurationManager.$$$reportNull$$$0(12);
        }
        if ((config = this.myServersConfig.get(TFSConfigurationManager.getConfigKey(serverUri))) != null && config.getAuthCanceledNotification() != null) {
            ApplicationManager.getApplication().invokeLater(() -> config.getAuthCanceledNotification().expire());
        }
        this.myServersConfig.remove(TFSConfigurationManager.getConfigKey(serverUri));
    }

    public void setUseIdeaHttpProxy(boolean useIdeaHttpProxy) {
        this.myUseIdeaHttpProxy = useIdeaHttpProxy;
    }

    public boolean useIdeaHttpProxy() {
        return this.myUseIdeaHttpProxy;
    }

    public TfsCheckinPoliciesCompatibility getCheckinPoliciesCompatibility() {
        return new TfsCheckinPoliciesCompatibility(this.mySupportStatefulCheckinPolicies, this.mySupportTfsCheckinPolicies, this.myReportNotInstalledCheckinPolicies);
    }

    public void setSupportTfsCheckinPolicies(boolean supportTfsCheckinPolicies) {
        this.mySupportTfsCheckinPolicies = supportTfsCheckinPolicies;
    }

    public void setSupportStatefulCheckinPolicies(boolean supportStatefulCheckinPolicies) {
        this.mySupportStatefulCheckinPolicies = supportStatefulCheckinPolicies;
    }

    public void setReportNotInstalledCheckinPolicies(boolean reportNotInstalledCheckinPolicies) {
        this.myReportNotInstalledCheckinPolicies = reportNotInstalledCheckinPolicies;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverUri";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateServerConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProxyUri";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldTryProxy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setProxyInaccessible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProxyUri";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "storeCredentials";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateServerConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serverKnown";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        @OptionTag
        @XMap(entryTagName="server", keyAttributeName="uri")
        public Map<String, ServerConfiguration> config = new HashMap<String, ServerConfiguration>();
        public boolean useIdeaHttpProxy = true;
        public boolean supportTfsCheckinPolicies = true;
        public boolean supportStatefulCheckinPolicies = true;
        public boolean reportNotInstalledCheckinPolicies = true;
    }
}

