/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ServerStatus;
import org.jetbrains.tfsIntegration.core.tfs.StatusProvider;
import org.jetbrains.tfsIntegration.core.tfs.StatusVisitor;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationHelper;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyGetOperations;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyProgress;
import org.jetbrains.tfsIntegration.core.tfs.operations.UndoPendingChanges;
import org.jetbrains.tfsIntegration.core.tfs.version.ChangesetVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.WorkspaceVersionSpec;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TFSRollbackEnvironment
extends DefaultRollbackEnvironment {
    @NotNull
    private final Project myProject;

    public TFSRollbackEnvironment(Project project) {
        this.myProject = project;
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> vcsExceptions, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            TFSRollbackEnvironment.$$$reportNull$$$0(0);
        }
        ArrayList<FilePath> localPaths = new ArrayList<FilePath>();
        listener.determinate();
        for (Change change : changes) {
            ContentRevision revision = change.getType() == Change.Type.DELETED ? change.getBeforeRevision() : change.getAfterRevision();
            localPaths.add(revision.getFile());
        }
        this.undoPendingChanges(localPaths, vcsExceptions, listener, false);
    }

    public void rollbackMissingFileDeletion(List<FilePath> files, final List<VcsException> errors, final RollbackProgressListener listener) {
        try {
            WorkstationHelper.processByWorkspaces(files, false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    final ArrayList<VersionControlServer.GetRequestParams> download = new ArrayList<VersionControlServer.GetRequestParams>();
                    final ArrayList<String> undo = new ArrayList<String>();
                    StatusProvider.visitByStatus(workspace, paths, false, null, new StatusVisitor(){

                        @Override
                        public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            TFSVcs.error("Server returned status Unversioned when rolling back missing file deletion: " + localPath.getPresentableUrl());
                        }

                        @Override
                        public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            undo.add(serverStatus.targetItem);
                        }

                        @Override
                        public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(5);
                            }
                            undo.add(serverStatus.targetItem);
                        }

                        @Override
                        public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(6);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(7);
                            }
                            TFSVcs.error("Server returned status ScheduledForDeletion when rolling back missing file deletion: " + localPath.getPresentableUrl());
                        }

                        @Override
                        public void outOfDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(8);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(9);
                            }
                            this.addForDownload(serverStatus);
                        }

                        @Override
                        public void deleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(10);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(11);
                            }
                            TFSVcs.error("Server returned status Deleted when rolling back missing file deletion: " + localPath.getPath());
                        }

                        @Override
                        public void upToDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(12);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(13);
                            }
                            this.addForDownload(serverStatus);
                        }

                        @Override
                        public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(14);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(15);
                            }
                            undo.add(serverStatus.targetItem);
                        }

                        @Override
                        public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(16);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(17);
                            }
                            undo.add(serverStatus.targetItem);
                        }

                        @Override
                        public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(18);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(19);
                            }
                            this.addForDownload(serverStatus);
                        }

                        private void addForDownload(@NotNull ServerStatus serverStatus) {
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(20);
                            }
                            download.add(new VersionControlServer.GetRequestParams(serverStatus.targetItem, RecursionType.None, new ChangesetVersionSpec(serverStatus.localVer)));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "localPath";
                                    break;
                                }
                                case 1: 
                                case 3: 
                                case 5: 
                                case 7: 
                                case 9: 
                                case 11: 
                                case 13: 
                                case 15: 
                                case 17: 
                                case 19: 
                                case 20: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "serverStatus";
                                    break;
                                }
                            }
                            objectArray2[1] = "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "unversioned";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "checkedOutForEdit";
                                    break;
                                }
                                case 4: 
                                case 5: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "scheduledForAddition";
                                    break;
                                }
                                case 6: 
                                case 7: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "scheduledForDeletion";
                                    break;
                                }
                                case 8: 
                                case 9: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "outOfDate";
                                    break;
                                }
                                case 10: 
                                case 11: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "deleted";
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "upToDate";
                                    break;
                                }
                                case 14: 
                                case 15: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "renamed";
                                    break;
                                }
                                case 16: 
                                case 17: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "renamedCheckedOut";
                                    break;
                                }
                                case 18: 
                                case 19: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "undeleted";
                                    break;
                                }
                                case 20: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "addForDownload";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }, TFSRollbackEnvironment.this.myProject);
                    List<GetOperation> operations = workspace.getServer().getVCS().get(workspace.getName(), workspace.getOwnerName(), download, TFSRollbackEnvironment.this.myProject, TFSBundle.message("preparing.for.download", new Object[0]));
                    Collection<VcsException> downloadErrors = ApplyGetOperations.execute(TFSRollbackEnvironment.this.myProject, workspace, operations, ApplyProgress.EMPTY, null, ApplyGetOperations.DownloadMode.FORCE);
                    errors.addAll(downloadErrors);
                    UndoPendingChanges.UndoPendingChangesResult undoResult = UndoPendingChanges.execute(TFSRollbackEnvironment.this.myProject, workspace, undo, false, new ApplyProgress.RollbackProgressWrapper(listener), false);
                    errors.addAll(undoResult.errors);
                }
            });
        }
        catch (TfsException e) {
            errors.add(new VcsException(e.getMessage(), (Throwable)e));
        }
    }

    public void rollbackModifiedWithoutCheckout(List<VirtualFile> files, final List<VcsException> errors, final RollbackProgressListener listener) {
        try {
            WorkstationHelper.processByWorkspaces(TfsFileUtil.getFilePaths(files), false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    ArrayList<VersionControlServer.GetRequestParams> requests = new ArrayList<VersionControlServer.GetRequestParams>(paths.size());
                    WorkspaceVersionSpec versionSpec = new WorkspaceVersionSpec(workspace.getName(), workspace.getOwnerName());
                    for (ItemPath e : paths) {
                        requests.add(new VersionControlServer.GetRequestParams(e.getServerPath(), RecursionType.None, versionSpec));
                    }
                    List<GetOperation> operations = workspace.getServer().getVCS().get(workspace.getName(), workspace.getOwnerName(), requests, TFSRollbackEnvironment.this.myProject, TFSBundle.message("preparing.for.download", new Object[0]));
                    Collection<VcsException> applyingErrors = ApplyGetOperations.execute(TFSRollbackEnvironment.this.myProject, workspace, operations, new ApplyProgress.RollbackProgressWrapper(listener), null, ApplyGetOperations.DownloadMode.FORCE);
                    errors.addAll(applyingErrors);
                }
            });
        }
        catch (TfsException e) {
            errors.add(new VcsException("Cannot undo pending changes", (Throwable)e));
        }
    }

    private void undoPendingChanges(List<FilePath> localPaths, final List<VcsException> errors, final @NotNull RollbackProgressListener listener, final boolean tolerateNoChangesFailure) {
        if (listener == null) {
            TFSRollbackEnvironment.$$$reportNull$$$0(1);
        }
        try {
            WorkstationHelper.processByWorkspaces(localPaths, false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    ArrayList<String> serverPaths = new ArrayList<String>(paths.size());
                    for (ItemPath itemPath : paths) {
                        serverPaths.add(itemPath.getServerPath());
                    }
                    UndoPendingChanges.UndoPendingChangesResult undoResult = UndoPendingChanges.execute(TFSRollbackEnvironment.this.myProject, workspace, serverPaths, false, new ApplyProgress.RollbackProgressWrapper(listener), tolerateNoChangesFailure);
                    errors.addAll(undoResult.errors);
                    ArrayList<VirtualFile> refresh = new ArrayList<VirtualFile>(paths.size());
                    for (ItemPath path : paths) {
                        listener.accept(path.getLocalPath());
                        ItemPath undone = undoResult.undonePaths.get(path);
                        FilePath subject = (undone != null ? undone : path).getLocalPath();
                        VirtualFile file = subject.getVirtualFileParent();
                        if (file == null || !file.exists()) continue;
                        refresh.add(file);
                    }
                    TfsFileUtil.refreshAndMarkDirty(TFSRollbackEnvironment.this.myProject, refresh, true);
                }
            });
        }
        catch (TfsException e) {
            errors.add(new VcsException("Cannot undo pending changes", (Throwable)e));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "listener";
        objectArray2[1] = "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "rollbackChanges";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "undoPendingChanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

