/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.checkin;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.JdomKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.tfsIntegration.checkin.PolicyParseException;
import org.jetbrains.tfsIntegration.checkin.PolicyType;
import org.jetbrains.tfsIntegration.checkin.StatefulPolicyDescriptor;

public class StatefulPolicyParser {
    private static final String VERSION = "version";
    private static final String POLICY_ANNOTATION = "policy-annotation";
    private static final String CURRENT_VERSION = "1";
    private static final String POLICY_DEFINITION = "policy-definition";
    private static final String ENABLED = "enabled";
    private static final String PRIORITY = "priority";
    private static final String POLICY_TYPE = "policy-type";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String SHORT_DESCRIPTION = "short-description";
    private static final String LONG_DESCRIPTION = "long-description";
    private static final String INSTALLATION_INSTRUCTIONS = "installation-instructions";
    private static final String CONFIGURATION_DATA = "configuration-data";
    private static final String SCOPE = "scope";

    public static List<StatefulPolicyDescriptor> parseDescriptors(String input) throws PolicyParseException {
        Element document;
        try {
            document = JdomKt.loadElement((CharSequence)input);
        }
        catch (IOException e) {
            throw new PolicyParseException(e);
        }
        catch (JDOMException e) {
            throw new PolicyParseException(e);
        }
        if (!POLICY_ANNOTATION.equals(document.getName())) {
            throw new PolicyParseException("Element expected: policy-annotation");
        }
        ArrayList<StatefulPolicyDescriptor> result = new ArrayList<StatefulPolicyDescriptor>();
        for (Object o : document.getChildren(POLICY_DEFINITION)) {
            Element definitionElement = (Element)o;
            String enabled = definitionElement.getAttributeValue(ENABLED);
            StatefulPolicyParser.checkNotNull(enabled, ENABLED);
            String priority = definitionElement.getAttributeValue(PRIORITY);
            StatefulPolicyParser.checkNotNull(priority, PRIORITY);
            Element typeElement = definitionElement.getChild(POLICY_TYPE);
            StatefulPolicyParser.checkNotNull(typeElement, POLICY_TYPE);
            String id = typeElement.getAttributeValue(ID);
            StatefulPolicyParser.checkNotNull(id, ID);
            String name = typeElement.getAttributeValue(NAME);
            StatefulPolicyParser.checkNotNull(name, NAME);
            String shortDescription = typeElement.getAttributeValue(SHORT_DESCRIPTION);
            String longDescription = typeElement.getAttributeValue(LONG_DESCRIPTION);
            String installationInstructions = typeElement.getAttributeValue(INSTALLATION_INSTRUCTIONS);
            PolicyType type = new PolicyType(id, name, shortDescription, installationInstructions);
            Element configurationElement = definitionElement.getChild(CONFIGURATION_DATA);
            StatefulPolicyParser.checkNotNull(configurationElement, CONFIGURATION_DATA);
            ArrayList<String> scope = new ArrayList<String>();
            for (Object o2 : definitionElement.getChildren(SCOPE)) {
                Element scopeElement = (Element)o2;
                scope.add(scopeElement.getText());
            }
            result.add(new StatefulPolicyDescriptor(type, Boolean.parseBoolean(enabled), configurationElement, scope, priority, longDescription));
        }
        return result;
    }

    public static Element createEmptyConfiguration() {
        return new Element(CONFIGURATION_DATA);
    }

    public static String saveDescriptors(List<? extends StatefulPolicyDescriptor> value) {
        Element root = new Element(POLICY_ANNOTATION);
        root.setAttribute(VERSION, CURRENT_VERSION);
        for (StatefulPolicyDescriptor statefulPolicyDescriptor : value) {
            Element descriptorElement = new Element(POLICY_DEFINITION);
            root.addContent(descriptorElement);
            descriptorElement.setAttribute(ENABLED, String.valueOf(statefulPolicyDescriptor.isEnabled()));
            descriptorElement.setAttribute(PRIORITY, statefulPolicyDescriptor.getPriority());
            descriptorElement.setAttribute(VERSION, CURRENT_VERSION);
            for (String scope : statefulPolicyDescriptor.getScope()) {
                Element scopeElement = new Element(SCOPE);
                scopeElement.setText(scope);
                descriptorElement.addContent(scopeElement);
            }
            Element typeElement = new Element(POLICY_TYPE);
            typeElement.setAttribute(ID, statefulPolicyDescriptor.getType().getId());
            typeElement.setAttribute(INSTALLATION_INSTRUCTIONS, statefulPolicyDescriptor.getType().getInstallationInstructions());
            typeElement.setAttribute(LONG_DESCRIPTION, statefulPolicyDescriptor.getLongDescription());
            typeElement.setAttribute(NAME, statefulPolicyDescriptor.getType().getName());
            typeElement.setAttribute(SHORT_DESCRIPTION, statefulPolicyDescriptor.getType().getDescription());
            descriptorElement.addContent(typeElement);
            descriptorElement.addContent(statefulPolicyDescriptor.getConfiguration().clone());
        }
        Document document = new Document(root);
        return JDOMUtil.writeDocument((Document)document, (String)"");
    }

    private static void checkNotNull(Element element, String expectedElementName) throws PolicyParseException {
        if (element == null) {
            throw new PolicyParseException("Element expected: " + expectedElementName);
        }
    }

    private static void checkNotNull(String value, String expectedElementName) throws PolicyParseException {
        if (value == null) {
            throw new PolicyParseException("Attribute expected: " + expectedElementName);
        }
    }
}

