/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.checkin;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.checkin.DuplicatePolicyIdException;
import org.jetbrains.tfsIntegration.checkin.PolicyBase;
import org.jetbrains.tfsIntegration.checkin.PolicyContext;
import org.jetbrains.tfsIntegration.checkin.PolicyFailure;
import org.jetbrains.tfsIntegration.checkin.PolicyType;
import org.jetbrains.tfsIntegration.core.TFSVcs;

public class CheckinPoliciesManager {
    private static List<PolicyBase> ourInstalledPolicies;
    public static final PolicyBase DUMMY_POLICY;

    public static List<PolicyBase> getInstalledPolicies() throws DuplicatePolicyIdException {
        if (ourInstalledPolicies == null) {
            List installedPolicies = PolicyBase.EP_NAME.getExtensionList();
            HashSet<PolicyType> types = new HashSet<PolicyType>(installedPolicies.size());
            for (PolicyBase policy : installedPolicies) {
                if (types.add(policy.getPolicyType())) continue;
                TFSVcs.LOG.warn("Duplicate checkin policy type: " + policy.getPolicyType().getId());
                throw new DuplicatePolicyIdException(policy.getPolicyType().getId());
            }
            ourInstalledPolicies = installedPolicies;
        }
        return ourInstalledPolicies;
    }

    @Nullable
    public static PolicyBase find(PolicyType type) throws DuplicatePolicyIdException {
        PolicyBase result = null;
        for (PolicyBase p : CheckinPoliciesManager.getInstalledPolicies()) {
            if (!p.getPolicyType().equals(type)) continue;
            result = p;
            break;
        }
        return result;
    }

    static {
        DUMMY_POLICY = new PolicyBase(){
            final PolicyType DUMMY = new PolicyType("DUMMY_POLICY", "", "", "");

            @Override
            @NotNull
            public PolicyType getPolicyType() {
                PolicyType policyType = this.DUMMY;
                if (policyType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return policyType;
            }

            @Override
            public PolicyFailure[] evaluate(@NotNull PolicyContext policycontext, @NotNull ProgressIndicator progressIndicator) {
                if (policycontext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new PolicyFailure[0];
            }

            @Override
            public boolean canEdit() {
                return false;
            }

            @Override
            public boolean edit(Project project) {
                return false;
            }

            @Override
            public void loadState(@NotNull Element element) {
                if (element == null) {
                    1.$$$reportNull$$$0(3);
                }
            }

            @Override
            public void saveState(@NotNull Element element) {
                if (element == null) {
                    1.$$$reportNull$$$0(4);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/tfsIntegration/checkin/CheckinPoliciesManager$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "policycontext";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "progressIndicator";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPolicyType";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/tfsIntegration/checkin/CheckinPoliciesManager$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "evaluate";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "loadState";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "saveState";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }
}

