/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EPathCommonUtil;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;

public class EPathUtil {
    static final Logger LOG = Logger.getInstance(EPathUtil.class);

    private EPathUtil() {
    }

    public static boolean areUrlsPointTheSame(String ideaUrl, String eclipseUrl) {
        int relativeIdx;
        String path = VfsUtilCore.urlToPath((String)eclipseUrl);
        if (ideaUrl.contains(path)) {
            return true;
        }
        String relativeToModulePath = EPathCommonUtil.getRelativeToModulePath((String)path);
        int n = relativeIdx = relativeToModulePath != null ? ideaUrl.indexOf(relativeToModulePath) : -1;
        if (relativeIdx != -1) {
            String pathToProjectFile = VfsUtilCore.urlToPath((String)ideaUrl.substring(0, relativeIdx));
            if (Comparing.strEqual((String)EPathCommonUtil.getRelativeModuleName((String)path), (String)EclipseProjectFinder.findProjectName((String)pathToProjectFile))) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    static String expandEclipseRelative2OtherModule(@NotNull Module otherModule, @Nullable String relativeToOtherModule) {
        VirtualFile[] contentRoots;
        if (otherModule == null) {
            EPathUtil.$$$reportNull$$$0(0);
        }
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)otherModule).getContentRoots()) {
            if (relativeToOtherModule == null) {
                return contentRoot.getUrl();
            }
            VirtualFile fileUnderModuleContentRoot = contentRoot.findFileByRelativePath(relativeToOtherModule);
            if (fileUnderModuleContentRoot == null) continue;
            return fileUnderModuleContentRoot.getUrl();
        }
        return null;
    }

    static String expandEclipsePath2Url(String path, ModifiableRootModel model, List<String> currentRoots) {
        VirtualFile contentRoot = EPathUtil.getContentRoot((ModuleRootModel)model);
        LOG.assertTrue(contentRoot != null);
        return EPathUtil.expandEclipsePath2Url(path, model, currentRoots, contentRoot);
    }

    static String expandEclipsePath2Url(String path, ModifiableRootModel model, List<String> currentRoots, @NotNull VirtualFile contentRoot) {
        VirtualFile jarFile;
        VirtualFile localFile;
        if (contentRoot == null) {
            EPathUtil.$$$reportNull$$$0(1);
        }
        String rootPath = contentRoot.getPath();
        String url = null;
        if (new File(path).exists()) {
            url = EPathCommonUtil.pathToUrl((String)path);
        } else if (path.startsWith("/")) {
            String moduleName = EPathCommonUtil.getRelativeModuleName((String)path);
            String relativeToRootPath = EPathCommonUtil.getRelativeToModulePath((String)path);
            Module otherModule = ModuleManager.getInstance((Project)model.getModule().getProject()).findModuleByName(moduleName);
            if (otherModule != null && otherModule != model.getModule()) {
                url = EPathUtil.expandEclipseRelative2OtherModule(otherModule, relativeToRootPath);
            } else if (currentRoots != null) {
                url = EPathCommonUtil.expandEclipseRelative2ContentRoots(currentRoots, (String)moduleName, (String)relativeToRootPath);
            }
        } else {
            String relativePath = new File(rootPath, path).getPath();
            File file = new File(relativePath);
            if (file.exists()) {
                url = EPathCommonUtil.pathToUrl((String)relativePath);
            }
        }
        if (url == null) {
            url = EPathCommonUtil.pathToUrl((String)path);
        }
        if ((localFile = VirtualFileManager.getInstance().findFileByUrl(url)) != null && (jarFile = JarFileSystem.getInstance().getJarRootForLocalFile(localFile)) != null) {
            url = jarFile.getUrl();
        }
        return url;
    }

    @Nullable
    public static String collapse2eclipseRelative2OtherModule(@NotNull Project project, @NotNull VirtualFile file) {
        Module module;
        if (project == null) {
            EPathUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            EPathUtil.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null) {
            return EPathUtil.collapse2eclipsePathRelative2Module(file, module);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (fileIndex.isExcluded(file) || fileIndex.isInLibraryClasses(file)) {
            for (Module aModule : ModuleManager.getInstance((Project)project).getModules()) {
                String path = EPathUtil.collapse2eclipsePathRelative2Module(file, aModule);
                if (path == null) continue;
                return path;
            }
        }
        return null;
    }

    @Nullable
    private static String collapse2eclipsePathRelative2Module(VirtualFile file, Module module) {
        VirtualFile[] contentRoots;
        for (VirtualFile otherRoot : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)otherRoot, (VirtualFile)file, (boolean)false)) continue;
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)otherRoot, (char)'/');
            return "/" + module.getName() + (StringUtil.isEmptyOrSpaces((String)relativePath) ? "" : "/" + relativePath);
        }
        return null;
    }

    @Nullable
    public static VirtualFile getContentRoot(@NotNull ModuleRootModel model) {
        if (model == null) {
            EPathUtil.$$$reportNull$$$0(4);
        }
        for (VirtualFile virtualFile : model.getContentRoots()) {
            if (virtualFile.findChild(".project") == null) continue;
            return virtualFile;
        }
        return null;
    }

    static String collapse2EclipsePath(String url, ModuleRootModel model) {
        Project project = model.getModule().getProject();
        VirtualFile contentRoot = EPathUtil.getContentRoot(model);
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file != null) {
            LOG.assertTrue(file.isValid());
            if (file.getFileSystem() instanceof JarFileSystem) {
                VirtualFile jarFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
                if (jarFile == null) {
                    LOG.error("Url: '" + url + "'; file: " + file);
                    return ProjectRootManagerImpl.extractLocalPath((String)url);
                }
                file = jarFile;
            }
            if (contentRoot != null && VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) {
                return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)'/');
            }
            String path = EPathUtil.collapse2eclipseRelative2OtherModule(project, file);
            if (path != null) {
                return path;
            }
        } else {
            String projectPath;
            VirtualFile projectBaseDir;
            String rootUrl;
            if (contentRoot != null && url.startsWith(rootUrl = contentRoot.getUrl()) && url.length() > rootUrl.length()) {
                return url.substring(rootUrl.length() + 1);
            }
            VirtualFile virtualFile = projectBaseDir = contentRoot != null ? contentRoot.getParent() : project.getBaseDir();
            assert (projectBaseDir != null);
            String projectUrl = projectBaseDir.getUrl();
            if (url.startsWith(projectUrl)) {
                return url.substring(projectUrl.length());
            }
            String path = VfsUtilCore.urlToPath((String)url);
            if (path.startsWith(projectPath = projectBaseDir.getPath())) {
                return ProjectRootManagerImpl.extractLocalPath((String)path.substring(projectPath.length()));
            }
        }
        return ProjectRootManagerImpl.extractLocalPath((String)url);
    }

    @Nullable
    static String collapse2EclipseVariabledPath(LibraryOrderEntry libraryOrderEntry, OrderRootType type) {
        VirtualFile[] virtualFiles = libraryOrderEntry.getRootFiles(type);
        if (virtualFiles.length > 0) {
            VirtualFile jarFile = virtualFiles[0];
            if (jarFile.getFileSystem() instanceof JarFileSystem) {
                jarFile = JarFileSystem.getInstance().getVirtualFileForJar(jarFile);
            }
            if (jarFile == null) {
                return null;
            }
            Project project = libraryOrderEntry.getOwnerModule().getProject();
            VirtualFile baseDir = project.getBaseDir();
            String filePath = jarFile.getPath();
            if (baseDir != null && !VfsUtilCore.isAncestor((VirtualFile)baseDir, (VirtualFile)jarFile, (boolean)false)) {
                String ideaCollapsed = PathMacroManager.getInstance((ComponentManager)project).collapsePath(filePath);
                if (ideaCollapsed.contains("..")) {
                    return null;
                }
                int index = ideaCollapsed.indexOf(36);
                if (index < 0) {
                    return null;
                }
                return ideaCollapsed.substring(index).replace("$", "");
            }
        }
        for (String url : libraryOrderEntry.getRootUrls(type)) {
            String filePath = VirtualFileManager.extractPath((String)url);
            int jarSeparatorIdx = filePath.indexOf("!/");
            if (jarSeparatorIdx > -1) {
                filePath = filePath.substring(0, jarSeparatorIdx);
            }
            Map pathMacros = PathMacros.getInstance().getUserMacros();
            for (String name : pathMacros.keySet()) {
                String path = FileUtil.toSystemIndependentName((String)((String)pathMacros.get(name)));
                if (!filePath.startsWith(path + "/")) continue;
                String substr = filePath.substring(path.length());
                return name + (substr.startsWith("/") || substr.length() == 0 ? substr : "/" + substr);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/eclipse/conversion/EPathUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "expandEclipseRelative2OtherModule";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "expandEclipsePath2Url";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collapse2eclipseRelative2OtherModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getContentRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

