/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.LineBreaker;
import android.text.LineWidth;
import android.text.Primitive;
import android.text.StaticLayout;
import android.text.TabStops;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GreedyLineBreaker
extends LineBreaker {
    public GreedyLineBreaker(List<Primitive> primitives, LineWidth lineWidth, TabStops tabStops) {
        super(primitives, lineWidth, tabStops);
    }

    @Override
    public void computeBreaks(StaticLayout.LineBreaks lineBreaks) {
        BreakInfo breakInfo = new BreakInfo();
        int lineNum = 0;
        float width = 0.0f;
        float printedWidth = 0.0f;
        boolean breakFound = false;
        boolean goodBreakFound = false;
        int breakIndex = 0;
        int goodBreakIndex = 0;
        float breakWidth = 0.0f;
        float goodBreakWidth = 0.0f;
        int firstTabIndex = Integer.MAX_VALUE;
        float maxWidth = this.mLineWidth.getLineWidth(lineNum);
        int numPrimitives = this.mPrimitives.size();
        for (int i = 0; i < numPrimitives; ++i) {
            Primitive p = (Primitive)this.mPrimitives.get(i);
            if (p.type == Primitive.PrimitiveType.BOX || p.type == Primitive.PrimitiveType.GLUE) {
                width += p.width;
                if (p.type == Primitive.PrimitiveType.BOX) {
                    printedWidth = width;
                }
            } else if (p.type == Primitive.PrimitiveType.VARIABLE) {
                width = this.mTabStops.width(width);
                firstTabIndex = Math.min(firstTabIndex, i);
            }
            if (printedWidth > maxWidth && (breakFound || goodBreakFound)) {
                if (goodBreakFound) {
                    i = goodBreakIndex;
                    maxWidth = this.mLineWidth.getLineWidth(++lineNum);
                    breakInfo.mBreaksList.add(((Primitive)this.mPrimitives.get((int)goodBreakIndex)).location);
                    breakInfo.mWidthsList.add(Float.valueOf(goodBreakWidth));
                    breakInfo.mFlagsList.add(firstTabIndex < goodBreakIndex);
                    firstTabIndex = Integer.MAX_VALUE;
                } else {
                    i = breakIndex;
                    maxWidth = this.mLineWidth.getLineWidth(++lineNum);
                    breakInfo.mBreaksList.add(((Primitive)this.mPrimitives.get((int)breakIndex)).location);
                    breakInfo.mWidthsList.add(Float.valueOf(breakWidth));
                    breakInfo.mFlagsList.add(firstTabIndex < breakIndex);
                    firstTabIndex = Integer.MAX_VALUE;
                }
                width = 0.0f;
                printedWidth = 0.0f;
                breakFound = false;
                goodBreakFound = false;
                breakWidth = 0.0f;
                goodBreakWidth = 0.0f;
                continue;
            }
            if (p.type == Primitive.PrimitiveType.PENALTY && p.penalty < 1.0E7f) {
                if (p.penalty == -1.0E7f) {
                    maxWidth = this.mLineWidth.getLineWidth(++lineNum);
                    breakInfo.mBreaksList.add(p.location);
                    breakInfo.mWidthsList.add(Float.valueOf(printedWidth));
                    breakInfo.mFlagsList.add(firstTabIndex < i);
                    firstTabIndex = Integer.MAX_VALUE;
                    width = 0.0f;
                    printedWidth = 0.0f;
                    breakFound = false;
                    goodBreakFound = false;
                    breakWidth = 0.0f;
                    goodBreakWidth = 0.0f;
                    continue;
                }
                if (i > breakIndex && (printedWidth <= maxWidth || !breakFound)) {
                    breakFound = true;
                    breakIndex = i;
                    breakWidth = printedWidth;
                }
                if (i <= goodBreakIndex || !(printedWidth <= maxWidth)) continue;
                goodBreakFound = true;
                goodBreakIndex = i;
                goodBreakWidth = printedWidth;
                continue;
            }
            if (p.type != Primitive.PrimitiveType.WORD_BREAK || i <= breakIndex || !(printedWidth <= maxWidth) && breakFound) continue;
            breakFound = true;
            breakIndex = i;
            breakWidth = printedWidth;
        }
        if (breakFound || goodBreakFound) {
            if (goodBreakFound) {
                breakInfo.mBreaksList.add(((Primitive)this.mPrimitives.get((int)goodBreakIndex)).location);
                breakInfo.mWidthsList.add(Float.valueOf(goodBreakWidth));
                breakInfo.mFlagsList.add(firstTabIndex < goodBreakIndex);
            } else {
                breakInfo.mBreaksList.add(((Primitive)this.mPrimitives.get((int)breakIndex)).location);
                breakInfo.mWidthsList.add(Float.valueOf(breakWidth));
                breakInfo.mFlagsList.add(firstTabIndex < breakIndex);
            }
        }
        breakInfo.copyTo(lineBreaks);
    }

    private static class BreakInfo {
        List<Integer> mBreaksList = new ArrayList<Integer>();
        List<Float> mWidthsList = new ArrayList<Float>();
        List<Boolean> mFlagsList = new ArrayList<Boolean>();

        private BreakInfo() {
        }

        public void copyTo(StaticLayout.LineBreaks lineBreaks) {
            if (lineBreaks.breaks.length != this.mBreaksList.size()) {
                lineBreaks.breaks = new int[this.mBreaksList.size()];
                lineBreaks.widths = new float[this.mWidthsList.size()];
                lineBreaks.flags = new int[this.mFlagsList.size()];
            }
            int i = 0;
            Iterator<Constable> iterator = this.mBreaksList.iterator();
            while (iterator.hasNext()) {
                int b;
                lineBreaks.breaks[i] = b = iterator.next().intValue();
                ++i;
            }
            i = 0;
            iterator = this.mWidthsList.iterator();
            while (iterator.hasNext()) {
                float b;
                lineBreaks.widths[i] = b = ((Float)iterator.next()).floatValue();
                ++i;
            }
            i = 0;
            iterator = this.mFlagsList.iterator();
            while (iterator.hasNext()) {
                boolean b = (Boolean)iterator.next();
                lineBreaks.flags[i] = b ? 0x20000000 : 0;
                ++i;
            }
            this.mBreaksList = null;
            this.mWidthsList = null;
            this.mFlagsList = null;
        }
    }
}

