/*
 * Decompiled with CFR 0.152.
 */
package android.security.keymaster;

import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.security.keymaster.KeymasterBlobArgument;
import android.security.keymaster.KeymasterBooleanArgument;
import android.security.keymaster.KeymasterDateArgument;
import android.security.keymaster.KeymasterDefs;
import android.security.keymaster.KeymasterIntArgument;
import android.security.keymaster.KeymasterLongArgument;

abstract class KeymasterArgument
implements Parcelable {
    public final int tag;
    public static final Parcelable.Creator<KeymasterArgument> CREATOR = new Parcelable.Creator<KeymasterArgument>(){

        @Override
        public KeymasterArgument createFromParcel(Parcel in) {
            int pos = in.dataPosition();
            int tag = in.readInt();
            switch (KeymasterDefs.getTagType(tag)) {
                case 0x10000000: 
                case 0x20000000: 
                case 0x30000000: 
                case 0x40000000: {
                    return new KeymasterIntArgument(tag, in);
                }
                case -1610612736: 
                case 0x50000000: {
                    return new KeymasterLongArgument(tag, in);
                }
                case 0x60000000: {
                    return new KeymasterDateArgument(tag, in);
                }
                case -2147483648: 
                case -1879048192: {
                    return new KeymasterBlobArgument(tag, in);
                }
                case 0x70000000: {
                    return new KeymasterBooleanArgument(tag, in);
                }
            }
            throw new ParcelFormatException("Bad tag: " + tag + " at " + pos);
        }

        public KeymasterArgument[] newArray(int size) {
            return new KeymasterArgument[size];
        }
    };

    protected KeymasterArgument(int tag) {
        this.tag = tag;
    }

    public abstract void writeValue(Parcel var1);

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.tag);
        this.writeValue(out);
    }
}

