/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.ConditionVariable;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IRecoverySystem;
import android.os.IRecoverySystemProgressListener;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.VintfObject;
import android.provider.Settings;
import android.telephony.euicc.EuiccManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.WindowManager;
import com.android.internal.logging.MetricsLogger;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.android.tools.layoutlib.java.System_Delegate;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import libcore.io.Streams;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;

public class RecoverySystem {
    private static final String TAG = "RecoverySystem";
    private static final File DEFAULT_KEYSTORE = new File("/system/etc/security/otacerts.zip");
    private static final long PUBLISH_PROGRESS_INTERVAL_MS = 500L;
    private static final long DEFAULT_EUICC_FACTORY_RESET_TIMEOUT_MILLIS = 30000L;
    private static final long MIN_EUICC_FACTORY_RESET_TIMEOUT_MILLIS = 5000L;
    private static final long MAX_EUICC_FACTORY_RESET_TIMEOUT_MILLIS = 60000L;
    private static final File RECOVERY_DIR = new File("/cache/recovery");
    private static final File LOG_FILE = new File(RECOVERY_DIR, "log");
    private static final File LAST_INSTALL_FILE = new File(RECOVERY_DIR, "last_install");
    private static final String LAST_PREFIX = "last_";
    private static final String ACTION_EUICC_FACTORY_RESET = "com.android.internal.action.EUICC_FACTORY_RESET";
    public static final File BLOCK_MAP_FILE = new File(RECOVERY_DIR, "block.map");
    public static final File UNCRYPT_PACKAGE_FILE = new File(RECOVERY_DIR, "uncrypt_file");
    public static final File UNCRYPT_STATUS_FILE = new File(RECOVERY_DIR, "uncrypt_status");
    private static final int LOG_FILE_MAX_LENGTH = 65536;
    private static final Object sRequestLock = new Object();
    private final IRecoverySystem mService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<X509Certificate> getTrustedCerts(File keystore) throws IOException, GeneralSecurityException {
        HashSet<X509Certificate> trusted = new HashSet<X509Certificate>();
        if (keystore == null) {
            keystore = DEFAULT_KEYSTORE;
        }
        try (ZipFile zip = new ZipFile(keystore);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                try (InputStream is = zip.getInputStream(entry);){
                    trusted.add((X509Certificate)cf.generateCertificate(is));
                }
            }
        }
        return trusted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyPackage(File packageFile, ProgressListener listener, File deviceCertsZipFile) throws IOException, GeneralSecurityException {
        final long fileLen = packageFile.length();
        try (final RandomAccessFile raf = new RandomAccessFile(packageFile, "r");){
            final long startTimeMillis = System_Delegate.currentTimeMillis();
            if (listener != null) {
                listener.onProgress(0);
            }
            raf.seek(fileLen - 6L);
            byte[] footer = new byte[6];
            raf.readFully(footer);
            if (footer[2] != -1 || footer[3] != -1) {
                throw new SignatureException("no signature in file (no footer)");
            }
            final int commentSize = footer[4] & 0xFF | (footer[5] & 0xFF) << 8;
            int signatureStart = footer[0] & 0xFF | (footer[1] & 0xFF) << 8;
            byte[] eocd = new byte[commentSize + 22];
            raf.seek(fileLen - (long)(commentSize + 22));
            raf.readFully(eocd);
            if (eocd[0] != 80 || eocd[1] != 75 || eocd[2] != 5 || eocd[3] != 6) {
                throw new SignatureException("no signature in file (bad footer)");
            }
            for (int i = 4; i < eocd.length - 3; ++i) {
                if (eocd[i] != 80 || eocd[i + 1] != 75 || eocd[i + 2] != 5 || eocd[i + 3] != 6) continue;
                throw new SignatureException("EOCD marker found after start of EOCD");
            }
            PKCS7 block = new PKCS7(new ByteArrayInputStream(eocd, commentSize + 22 - signatureStart, signatureStart));
            X509Certificate[] certificates = block.getCertificates();
            if (certificates == null || certificates.length == 0) {
                throw new SignatureException("signature contains no certificates");
            }
            X509Certificate cert = certificates[0];
            PublicKey signatureKey = cert.getPublicKey();
            SignerInfo[] signerInfos = block.getSignerInfos();
            if (signerInfos == null || signerInfos.length == 0) {
                throw new SignatureException("signature contains no signedData");
            }
            SignerInfo signerInfo = signerInfos[0];
            boolean verified = false;
            HashSet<X509Certificate> trusted = RecoverySystem.getTrustedCerts(deviceCertsZipFile == null ? DEFAULT_KEYSTORE : deviceCertsZipFile);
            for (X509Certificate c : trusted) {
                if (!c.getPublicKey().equals(signatureKey)) continue;
                verified = true;
                break;
            }
            if (!verified) {
                throw new SignatureException("signature doesn't match any trusted key");
            }
            raf.seek(0L);
            final ProgressListener listenerForInner = listener;
            SignerInfo verifyResult = block.verify(signerInfo, new InputStream(){
                long toRead;
                long soFar;
                int lastPercent;
                long lastPublishTime;
                {
                    this.toRead = fileLen - (long)commentSize - 2L;
                    this.soFar = 0L;
                    this.lastPercent = 0;
                    this.lastPublishTime = startTimeMillis;
                }

                @Override
                public int read() throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    if (this.soFar >= this.toRead) {
                        return -1;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        return -1;
                    }
                    int size = len;
                    if (this.soFar + (long)size > this.toRead) {
                        size = (int)(this.toRead - this.soFar);
                    }
                    int read = raf.read(b, off, size);
                    this.soFar += (long)read;
                    if (listenerForInner != null) {
                        long now = System_Delegate.currentTimeMillis();
                        int p = (int)(this.soFar * 100L / this.toRead);
                        if (p > this.lastPercent && now - this.lastPublishTime > 500L) {
                            this.lastPercent = p;
                            this.lastPublishTime = now;
                            listenerForInner.onProgress(this.lastPercent);
                        }
                    }
                    return read;
                }
            });
            boolean interrupted = Thread.interrupted();
            if (listener != null) {
                listener.onProgress(100);
            }
            if (interrupted) {
                throw new SignatureException("verification was interrupted");
            }
            if (verifyResult == null) {
                throw new SignatureException("signature digest verification failed");
            }
        }
        if (!RecoverySystem.readAndVerifyPackageCompatibilityEntry(packageFile)) {
            throw new SignatureException("package compatibility verification failed");
        }
    }

    private static boolean verifyPackageCompatibility(InputStream inputStream) throws IOException {
        ZipEntry entry;
        ArrayList<String> list = new ArrayList<String>();
        ZipInputStream zis = new ZipInputStream(inputStream);
        while ((entry = zis.getNextEntry()) != null) {
            long entrySize = entry.getSize();
            if (entrySize > Integer.MAX_VALUE || entrySize < 0L) {
                throw new IOException("invalid entry size (" + entrySize + ") in the compatibility file");
            }
            byte[] bytes = new byte[(int)entrySize];
            Streams.readFully(zis, bytes);
            list.add(new String(bytes, StandardCharsets.UTF_8));
        }
        if (list.isEmpty()) {
            throw new IOException("no entries found in the compatibility file");
        }
        return VintfObject.verify(list.toArray(new String[list.size()])) == 0;
    }

    private static boolean readAndVerifyPackageCompatibilityEntry(File packageFile) throws IOException {
        try (ZipFile zip = new ZipFile(packageFile);){
            ZipEntry entry = zip.getEntry("compatibility.zip");
            if (entry == null) {
                boolean bl = true;
                return bl;
            }
            InputStream inputStream = zip.getInputStream(entry);
            boolean bl = RecoverySystem.verifyPackageCompatibility(inputStream);
            return bl;
        }
    }

    @SuppressLint(value={"Doclava125"})
    public static boolean verifyPackageCompatibility(File compatibilityFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(compatibilityFile);){
            boolean bl = RecoverySystem.verifyPackageCompatibility(inputStream);
            return bl;
        }
    }

    public static void processPackage(Context context, File packageFile, final ProgressListener listener, Handler handler) throws IOException {
        String filename = packageFile.getCanonicalPath();
        if (!filename.startsWith("/data/")) {
            return;
        }
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        IRecoverySystemProgressListener.Stub progressListener = null;
        if (listener != null) {
            final Handler progressHandler = handler != null ? handler : new Handler(context.getMainLooper());
            progressListener = new IRecoverySystemProgressListener.Stub(){
                int lastProgress = 0;
                long lastPublishTime = System_Delegate.currentTimeMillis();

                @Override
                public void onProgress(final int progress) {
                    final long now = System_Delegate.currentTimeMillis();
                    progressHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (progress > lastProgress && now - lastPublishTime > 500L) {
                                lastProgress = progress;
                                lastPublishTime = now;
                                listener.onProgress(progress);
                            }
                        }
                    });
                }
            };
        }
        if (!rs.uncrypt(filename, progressListener)) {
            throw new IOException("process package failed");
        }
    }

    public static void processPackage(Context context, File packageFile, ProgressListener listener) throws IOException {
        RecoverySystem.processPackage(context, packageFile, listener, null);
    }

    public static void installPackage(Context context, File packageFile) throws IOException {
        RecoverySystem.installPackage(context, packageFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installPackage(Context context, File packageFile, boolean processed) throws IOException {
        Object object = sRequestLock;
        synchronized (object) {
            WindowManager wm;
            RecoverySystem rs;
            LOG_FILE.delete();
            UNCRYPT_PACKAGE_FILE.delete();
            String filename = packageFile.getCanonicalPath();
            Log.w(TAG, "!!! REBOOTING TO INSTALL " + filename + " !!!");
            boolean securityUpdate = filename.endsWith("_s.zip");
            if (filename.startsWith("/data/")) {
                if (processed) {
                    if (!BLOCK_MAP_FILE.exists()) {
                        Log.e(TAG, "Package claimed to have been processed but failed to find the block map file.");
                        throw new IOException("Failed to find block map file");
                    }
                } else {
                    try (FileWriter uncryptFile = new FileWriter(UNCRYPT_PACKAGE_FILE);){
                        uncryptFile.write(filename + "\n");
                    }
                    if (!UNCRYPT_PACKAGE_FILE.setReadable(true, false) || !UNCRYPT_PACKAGE_FILE.setWritable(true, false)) {
                        Log.e(TAG, "Error setting permission for " + UNCRYPT_PACKAGE_FILE);
                    }
                    BLOCK_MAP_FILE.delete();
                }
                filename = "@/cache/recovery/block.map";
            }
            String filenameArg = "--update_package=" + filename + "\n";
            String localeArg = "--locale=" + AndroidLocale.toLanguageTag(AndroidLocale.getDefault()) + "\n";
            String securityArg = "--security\n";
            String command = filenameArg + localeArg;
            if (securityUpdate) {
                command = command + "--security\n";
            }
            if (!(rs = (RecoverySystem)context.getSystemService("recovery")).setupBcb(command)) {
                throw new IOException("Setup BCB failed");
            }
            PowerManager pm = (PowerManager)context.getSystemService("power");
            String reason = "recovery-update";
            if (context.getPackageManager().hasSystemFeature("android.software.leanback") && (wm = (WindowManager)context.getSystemService("window")).getDefaultDisplay().getState() != 2) {
                reason = reason + ",quiescent";
            }
            pm.reboot(reason);
            throw new IOException("Reboot failed (no permissions?)");
        }
    }

    public static void scheduleUpdateOnBoot(Context context, File packageFile) throws IOException {
        RecoverySystem rs;
        String filename = packageFile.getCanonicalPath();
        boolean securityUpdate = filename.endsWith("_s.zip");
        if (filename.startsWith("/data/")) {
            filename = "@/cache/recovery/block.map";
        }
        String filenameArg = "--update_package=" + filename + "\n";
        String localeArg = "--locale=" + AndroidLocale.toLanguageTag(AndroidLocale.getDefault()) + "\n";
        String securityArg = "--security\n";
        String command = filenameArg + localeArg;
        if (securityUpdate) {
            command = command + "--security\n";
        }
        if (!(rs = (RecoverySystem)context.getSystemService("recovery")).setupBcb(command)) {
            throw new IOException("schedule update on boot failed");
        }
    }

    public static void cancelScheduledUpdate(Context context) throws IOException {
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        if (!rs.clearBcb()) {
            throw new IOException("cancel scheduled update failed");
        }
    }

    public static void rebootWipeUserData(Context context) throws IOException {
        RecoverySystem.rebootWipeUserData(context, false, context.getPackageName(), false, false);
    }

    public static void rebootWipeUserData(Context context, String reason) throws IOException {
        RecoverySystem.rebootWipeUserData(context, false, reason, false, false);
    }

    public static void rebootWipeUserData(Context context, boolean shutdown) throws IOException {
        RecoverySystem.rebootWipeUserData(context, shutdown, context.getPackageName(), false, false);
    }

    public static void rebootWipeUserData(Context context, boolean shutdown, String reason, boolean force) throws IOException {
        RecoverySystem.rebootWipeUserData(context, shutdown, reason, force, false);
    }

    public static void rebootWipeUserData(Context context, boolean shutdown, String reason, boolean force, boolean wipeEuicc) throws IOException {
        UserManager um = (UserManager)context.getSystemService("user");
        if (!force && um.hasUserRestriction("no_factory_reset")) {
            throw new SecurityException("Wiping data is not allowed for this user.");
        }
        final ConditionVariable condition = new ConditionVariable();
        Intent intent = new Intent("android.intent.action.MASTER_CLEAR_NOTIFICATION");
        intent.addFlags(0x11000000);
        context.sendOrderedBroadcastAsUser(intent, UserHandle.SYSTEM, "android.permission.MASTER_CLEAR", new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                condition.open();
            }
        }, null, 0, null, null);
        condition.block();
        RecoverySystem.wipeEuiccData(context, wipeEuicc);
        String shutdownArg = null;
        if (shutdown) {
            shutdownArg = "--shutdown_after";
        }
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String localeArg = "--locale=" + AndroidLocale.toLanguageTag(AndroidLocale.getDefault());
        RecoverySystem.bootCommand(context, shutdownArg, "--wipe_data", reasonArg, localeArg);
    }

    private static void wipeEuiccData(Context context, final boolean isWipeEuicc) {
        ContentResolver cr = context.getContentResolver();
        if (Settings.Global.getInt(cr, "euicc_provisioned", 0) == 0) {
            Log.d(TAG, "Skipping eUICC wipe/retain as it is not provisioned");
            return;
        }
        EuiccManager euiccManager = (EuiccManager)context.getSystemService("euicc_service");
        if (euiccManager != null && euiccManager.isEnabled()) {
            final CountDownLatch euiccFactoryResetLatch = new CountDownLatch(1);
            BroadcastReceiver euiccWipeFinishReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    if (RecoverySystem.ACTION_EUICC_FACTORY_RESET.equals(intent.getAction())) {
                        if (this.getResultCode() != 0) {
                            int detailedCode = intent.getIntExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", 0);
                            if (isWipeEuicc) {
                                Log.e(RecoverySystem.TAG, "Error wiping euicc data, Detailed code = " + detailedCode);
                            } else {
                                Log.e(RecoverySystem.TAG, "Error retaining euicc data, Detailed code = " + detailedCode);
                            }
                        } else if (isWipeEuicc) {
                            Log.d(RecoverySystem.TAG, "Successfully wiped euicc data.");
                        } else {
                            Log.d(RecoverySystem.TAG, "Successfully retained euicc data.");
                        }
                        euiccFactoryResetLatch.countDown();
                    }
                }
            };
            Intent intent = new Intent(ACTION_EUICC_FACTORY_RESET);
            intent.setPackage("android");
            PendingIntent callbackIntent = PendingIntent.getBroadcastAsUser(context, 0, intent, 0x8000000, UserHandle.SYSTEM);
            IntentFilter filterConsent = new IntentFilter();
            filterConsent.addAction(ACTION_EUICC_FACTORY_RESET);
            HandlerThread euiccHandlerThread = new HandlerThread("euiccWipeFinishReceiverThread");
            euiccHandlerThread.start();
            Handler euiccHandler = new Handler(euiccHandlerThread.getLooper());
            context.getApplicationContext().registerReceiver(euiccWipeFinishReceiver, filterConsent, null, euiccHandler);
            if (isWipeEuicc) {
                euiccManager.eraseSubscriptions(callbackIntent);
            } else {
                euiccManager.retainSubscriptionsForFactoryReset(callbackIntent);
            }
            try {
                long waitingTimeMillis = Settings.Global.getLong(context.getContentResolver(), "euicc_factory_reset_timeout_millis", 30000L);
                if (waitingTimeMillis < 5000L) {
                    waitingTimeMillis = 5000L;
                } else if (waitingTimeMillis > 60000L) {
                    waitingTimeMillis = 60000L;
                }
                if (!euiccFactoryResetLatch.await(waitingTimeMillis, TimeUnit.MILLISECONDS)) {
                    if (isWipeEuicc) {
                        Log.e(TAG, "Timeout wiping eUICC data.");
                    } else {
                        Log.e(TAG, "Timeout retaining eUICC data.");
                    }
                }
                context.getApplicationContext().unregisterReceiver(euiccWipeFinishReceiver);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (isWipeEuicc) {
                    Log.e(TAG, "Wiping eUICC data interrupted", e);
                }
                Log.e(TAG, "Retaining eUICC data interrupted", e);
            }
        }
    }

    public static void rebootPromptAndWipeUserData(Context context, String reason) throws IOException {
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String localeArg = "--locale=" + AndroidLocale.getDefault().toString();
        RecoverySystem.bootCommand(context, null, "--prompt_and_wipe_data", reasonArg, localeArg);
    }

    public static void rebootWipeCache(Context context) throws IOException {
        RecoverySystem.rebootWipeCache(context, context.getPackageName());
    }

    public static void rebootWipeCache(Context context, String reason) throws IOException {
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String localeArg = "--locale=" + AndroidLocale.toLanguageTag(AndroidLocale.getDefault());
        RecoverySystem.bootCommand(context, "--wipe_cache", reasonArg, localeArg);
    }

    public static void rebootWipeAb(Context context, File packageFile, String reason) throws IOException {
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String filename = packageFile.getCanonicalPath();
        String filenameArg = "--wipe_package=" + filename;
        String localeArg = "--locale=" + AndroidLocale.toLanguageTag(AndroidLocale.getDefault());
        RecoverySystem.bootCommand(context, "--wipe_ab", filenameArg, reasonArg, localeArg);
    }

    private static void bootCommand(Context context, String ... args) throws IOException {
        LOG_FILE.delete();
        StringBuilder command = new StringBuilder();
        for (String arg : args) {
            if (TextUtils.isEmpty(arg)) continue;
            command.append(arg);
            command.append("\n");
        }
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        rs.rebootRecoveryWithCommand(command.toString());
        throw new IOException("Reboot failed (no permissions?)");
    }

    private static void parseLastInstallLog(Context context) {
        try (BufferedReader in = new BufferedReader(new FileReader(LAST_INSTALL_FILE));){
            String line = null;
            int bytesWrittenInMiB = -1;
            int bytesStashedInMiB = -1;
            int timeTotal = -1;
            int uncryptTime = -1;
            int sourceVersion = -1;
            int temperatureStart = -1;
            int temperatureEnd = -1;
            int temperatureMax = -1;
            int errorCode = -1;
            int causeCode = -1;
            while ((line = in.readLine()) != null) {
                int scaled;
                long parsedNum;
                int numIndex = line.indexOf(58);
                if (numIndex == -1 || numIndex + 1 >= line.length()) continue;
                String numString = line.substring(numIndex + 1).trim();
                try {
                    parsedNum = Long.parseLong(numString);
                }
                catch (NumberFormatException ignored) {
                    Log.e(TAG, "Failed to parse numbers in " + line);
                    continue;
                }
                int MiB = 0x100000;
                try {
                    scaled = line.startsWith("bytes") ? Math.toIntExact(parsedNum / 0x100000L) : Math.toIntExact(parsedNum);
                }
                catch (ArithmeticException ignored) {
                    Log.e(TAG, "Number overflows in " + line);
                    continue;
                }
                if (line.startsWith("time")) {
                    timeTotal = scaled;
                    continue;
                }
                if (line.startsWith("uncrypt_time")) {
                    uncryptTime = scaled;
                    continue;
                }
                if (line.startsWith("source_build")) {
                    sourceVersion = scaled;
                    continue;
                }
                if (line.startsWith("bytes_written")) {
                    bytesWrittenInMiB = bytesWrittenInMiB == -1 ? scaled : bytesWrittenInMiB + scaled;
                    continue;
                }
                if (line.startsWith("bytes_stashed")) {
                    bytesStashedInMiB = bytesStashedInMiB == -1 ? scaled : bytesStashedInMiB + scaled;
                    continue;
                }
                if (line.startsWith("temperature_start")) {
                    temperatureStart = scaled;
                    continue;
                }
                if (line.startsWith("temperature_end")) {
                    temperatureEnd = scaled;
                    continue;
                }
                if (line.startsWith("temperature_max")) {
                    temperatureMax = scaled;
                    continue;
                }
                if (line.startsWith("error")) {
                    errorCode = scaled;
                    continue;
                }
                if (!line.startsWith("cause")) continue;
                causeCode = scaled;
            }
            if (timeTotal != -1) {
                MetricsLogger.histogram(context, "ota_time_total", timeTotal);
            }
            if (uncryptTime != -1) {
                MetricsLogger.histogram(context, "ota_uncrypt_time", uncryptTime);
            }
            if (sourceVersion != -1) {
                MetricsLogger.histogram(context, "ota_source_version", sourceVersion);
            }
            if (bytesWrittenInMiB != -1) {
                MetricsLogger.histogram(context, "ota_written_in_MiBs", bytesWrittenInMiB);
            }
            if (bytesStashedInMiB != -1) {
                MetricsLogger.histogram(context, "ota_stashed_in_MiBs", bytesStashedInMiB);
            }
            if (temperatureStart != -1) {
                MetricsLogger.histogram(context, "ota_temperature_start", temperatureStart);
            }
            if (temperatureEnd != -1) {
                MetricsLogger.histogram(context, "ota_temperature_end", temperatureEnd);
            }
            if (temperatureMax != -1) {
                MetricsLogger.histogram(context, "ota_temperature_max", temperatureMax);
            }
            if (errorCode != -1) {
                MetricsLogger.histogram(context, "ota_non_ab_error_code", errorCode);
            }
            if (causeCode != -1) {
                MetricsLogger.histogram(context, "ota_non_ab_cause_code", causeCode);
            }
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to read lines in last_install", e);
        }
    }

    public static String handleAftermath(Context context) {
        boolean reservePackage;
        String log = null;
        try {
            log = FileUtils.readTextFile(LOG_FILE, -65536, "...\n");
        }
        catch (FileNotFoundException e) {
            Log.i(TAG, "No recovery log file");
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading recovery log", e);
        }
        if (log != null) {
            RecoverySystem.parseLastInstallLog(context);
        }
        if (!(reservePackage = BLOCK_MAP_FILE.exists()) && UNCRYPT_PACKAGE_FILE.exists()) {
            String filename = null;
            try {
                filename = FileUtils.readTextFile(UNCRYPT_PACKAGE_FILE, 0, null);
            }
            catch (IOException e) {
                Log.e(TAG, "Error reading uncrypt file", e);
            }
            if (filename != null && filename.startsWith("/data")) {
                if (UNCRYPT_PACKAGE_FILE.delete()) {
                    Log.i(TAG, "Deleted: " + filename);
                } else {
                    Log.e(TAG, "Can't delete: " + filename);
                }
            }
        }
        String[] names = RECOVERY_DIR.list();
        for (int i = 0; names != null && i < names.length; ++i) {
            if (names[i].startsWith(LAST_PREFIX) || reservePackage && names[i].equals(BLOCK_MAP_FILE.getName()) || reservePackage && names[i].equals(UNCRYPT_PACKAGE_FILE.getName())) continue;
            RecoverySystem.recursiveDelete(new File(RECOVERY_DIR, names[i]));
        }
        return log;
    }

    private static void recursiveDelete(File name) {
        if (name.isDirectory()) {
            String[] files = name.list();
            for (int i = 0; files != null && i < files.length; ++i) {
                File f = new File(name, files[i]);
                RecoverySystem.recursiveDelete(f);
            }
        }
        if (!name.delete()) {
            Log.e(TAG, "Can't delete: " + name);
        } else {
            Log.i(TAG, "Deleted: " + name);
        }
    }

    private boolean uncrypt(String packageFile, IRecoverySystemProgressListener listener) {
        try {
            return this.mService.uncrypt(packageFile, listener);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private boolean setupBcb(String command) {
        try {
            return this.mService.setupBcb(command);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private boolean clearBcb() {
        try {
            return this.mService.clearBcb();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private void rebootRecoveryWithCommand(String command) {
        try {
            this.mService.rebootRecoveryWithCommand(command);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static String sanitizeArg(String arg) {
        arg = arg.replace('\u0000', '?');
        arg = arg.replace('\n', '?');
        return arg;
    }

    public RecoverySystem() {
        this.mService = null;
    }

    public RecoverySystem(IRecoverySystem service) {
        this.mService = service;
    }

    public static interface ProgressListener {
        public void onProgress(int var1);
    }
}

