/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.opengl.EGL14;
import android.os.SystemProperties;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.File;

public class GraphicsEnvironment {
    private static final boolean DEBUG = false;
    private static final String TAG = "GraphicsEnvironment";
    private static final String PROPERTY_GFX_DRIVER = "ro.gfx.driver.0";

    public static void chooseDriver(Context context) {
        ApplicationInfo driverInfo;
        String driverPackageName = SystemProperties.get(PROPERTY_GFX_DRIVER);
        if (driverPackageName == null || driverPackageName.isEmpty()) {
            return;
        }
        ApplicationInfo ai = context.getApplicationInfo();
        if (ai.isPrivilegedApp() || ai.isSystemApp() && !ai.isUpdatedSystemApp()) {
            return;
        }
        try {
            driverInfo = context.getPackageManager().getApplicationInfo(driverPackageName, 0x100000);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "driver package '" + driverPackageName + "' not installed");
            return;
        }
        String abi = GraphicsEnvironment.chooseAbi(driverInfo);
        if (abi == null) {
            return;
        }
        if (driverInfo.targetSdkVersion < 26) {
            Log.w(TAG, "updated driver package is not known to be compatible with O");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(driverInfo.nativeLibraryDir).append(File.pathSeparator);
        sb.append(driverInfo.sourceDir).append("!/lib/").append(abi);
        String paths = sb.toString();
        GraphicsEnvironment.setDriverPath(paths);
    }

    public static void earlyInitEGL() {
        Thread eglInitThread = new Thread(() -> EGL14.eglGetDisplay(0), "EGL Init");
        eglInitThread.start();
    }

    private static String chooseAbi(ApplicationInfo ai) {
        String isa = VMRuntime.getCurrentInstructionSet();
        if (ai.primaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.primaryCpuAbi))) {
            return ai.primaryCpuAbi;
        }
        if (ai.secondaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.secondaryCpuAbi))) {
            return ai.secondaryCpuAbi;
        }
        return null;
    }

    private static void setDriverPath(String string2) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setDriverPath(Ljava/lang/String;)V", true, null);
    }
}

