/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.net.lowpan.ILowpanEnergyScanCallback;
import android.net.lowpan.ILowpanInterface;
import android.net.lowpan.ILowpanNetScanCallback;
import android.net.lowpan.LowpanBeaconInfo;
import android.net.lowpan.LowpanEnergyScanResult;
import android.net.lowpan.LowpanException;
import android.net.lowpan.LowpanProperties;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LowpanScanner {
    private static final String TAG = LowpanScanner.class.getSimpleName();
    private ILowpanInterface mBinder;
    private Callback mCallback = null;
    private Handler mHandler = null;
    private ArrayList<Integer> mChannelMask = null;
    private int mTxPower = Integer.MAX_VALUE;

    LowpanScanner(ILowpanInterface binder) {
        this.mBinder = binder;
    }

    public synchronized void setCallback(Callback cb, Handler handler) {
        this.mCallback = cb;
        this.mHandler = handler;
    }

    public void setCallback(Callback cb) {
        this.setCallback(cb, null);
    }

    public void setChannelMask(Collection<Integer> mask) {
        if (mask == null) {
            this.mChannelMask = null;
        } else {
            if (this.mChannelMask == null) {
                this.mChannelMask = new ArrayList();
            } else {
                this.mChannelMask.clear();
            }
            this.mChannelMask.addAll(mask);
        }
    }

    public Collection<Integer> getChannelMask() {
        return (Collection)this.mChannelMask.clone();
    }

    public void addChannel(int channel) {
        if (this.mChannelMask == null) {
            this.mChannelMask = new ArrayList();
        }
        this.mChannelMask.add(channel);
    }

    public void setTxPower(int txPower) {
        this.mTxPower = txPower;
    }

    public int getTxPower() {
        return this.mTxPower;
    }

    private Map<String, Object> createScanOptionMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.mChannelMask != null) {
            LowpanProperties.KEY_CHANNEL_MASK.putInMap(map, this.mChannelMask.stream().mapToInt(i -> i).toArray());
        }
        if (this.mTxPower != Integer.MAX_VALUE) {
            LowpanProperties.KEY_MAX_TX_POWER.putInMap(map, this.mTxPower);
        }
        return map;
    }

    public void startNetScan() throws LowpanException {
        Map<String, Object> map = this.createScanOptionMap();
        ILowpanNetScanCallback.Stub binderListener = new ILowpanNetScanCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNetScanBeacon(LowpanBeaconInfo beaconInfo) {
                Handler handler;
                Callback callback;
                LowpanScanner lowpanScanner = LowpanScanner.this;
                synchronized (lowpanScanner) {
                    callback = LowpanScanner.this.mCallback;
                    handler = LowpanScanner.this.mHandler;
                }
                if (callback == null) {
                    return;
                }
                Runnable runnable = () -> callback.onNetScanBeacon(beaconInfo);
                if (handler != null) {
                    handler.post(runnable);
                } else {
                    runnable.run();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNetScanFinished() {
                Handler handler;
                Callback callback;
                LowpanScanner lowpanScanner = LowpanScanner.this;
                synchronized (lowpanScanner) {
                    callback = LowpanScanner.this.mCallback;
                    handler = LowpanScanner.this.mHandler;
                }
                if (callback == null) {
                    return;
                }
                Runnable runnable = () -> callback.onScanFinished();
                if (handler != null) {
                    handler.post(runnable);
                } else {
                    runnable.run();
                }
            }
        };
        try {
            this.mBinder.startNetScan(map, binderListener);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public void stopNetScan() {
        try {
            this.mBinder.stopNetScan();
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public void startEnergyScan() throws LowpanException {
        Map<String, Object> map = this.createScanOptionMap();
        ILowpanEnergyScanCallback.Stub binderListener = new ILowpanEnergyScanCallback.Stub(){

            @Override
            public void onEnergyScanResult(int channel, int rssi) {
                Callback callback = LowpanScanner.this.mCallback;
                Handler handler = LowpanScanner.this.mHandler;
                if (callback == null) {
                    return;
                }
                Runnable runnable = () -> {
                    if (callback != null) {
                        LowpanEnergyScanResult result = new LowpanEnergyScanResult();
                        result.setChannel(channel);
                        result.setMaxRssi(rssi);
                        callback.onEnergyScanResult(result);
                    }
                };
                if (handler != null) {
                    handler.post(runnable);
                } else {
                    runnable.run();
                }
            }

            @Override
            public void onEnergyScanFinished() {
                Callback callback = LowpanScanner.this.mCallback;
                Handler handler = LowpanScanner.this.mHandler;
                if (callback == null) {
                    return;
                }
                Runnable runnable = () -> callback.onScanFinished();
                if (handler != null) {
                    handler.post(runnable);
                } else {
                    runnable.run();
                }
            }
        };
        try {
            this.mBinder.startEnergyScan(map, binderListener);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public void stopEnergyScan() {
        try {
            this.mBinder.stopEnergyScan();
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public static abstract class Callback {
        public void onNetScanBeacon(LowpanBeaconInfo beacon) {
        }

        public void onEnergyScanResult(LowpanEnergyScanResult result) {
        }

        public void onScanFinished() {
        }
    }
}

