/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PathMeasure_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class PathMeasure {
    private Path mPath;
    public static final int POSITION_MATRIX_FLAG = 1;
    public static final int TANGENT_MATRIX_FLAG = 2;
    private long native_instance;

    public PathMeasure() {
        this.mPath = null;
        this.native_instance = PathMeasure.native_create(0L, false);
    }

    public PathMeasure(Path path, boolean forceClosed) {
        this.mPath = path;
        this.native_instance = PathMeasure.native_create(path != null ? path.readOnlyNI() : 0L, forceClosed);
    }

    public void setPath(Path path, boolean forceClosed) {
        this.mPath = path;
        PathMeasure.native_setPath(this.native_instance, path != null ? path.readOnlyNI() : 0L, forceClosed);
    }

    public float getLength() {
        return PathMeasure.native_getLength(this.native_instance);
    }

    public boolean getPosTan(float distance, float[] pos, float[] tan) {
        if (pos != null && pos.length < 2 || tan != null && tan.length < 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return PathMeasure.native_getPosTan(this.native_instance, distance, pos, tan);
    }

    public boolean getMatrix(float distance, Matrix matrix, int flags) {
        return PathMeasure.native_getMatrix(this.native_instance, distance, matrix.native_instance, flags);
    }

    public boolean getSegment(float startD, float stopD, Path dst, boolean startWithMoveTo) {
        float length = this.getLength();
        if (startD < 0.0f) {
            startD = 0.0f;
        }
        if (stopD > length) {
            stopD = length;
        }
        if (startD >= stopD) {
            return false;
        }
        return PathMeasure.native_getSegment(this.native_instance, startD, stopD, dst.mutateNI(), startWithMoveTo);
    }

    public boolean isClosed() {
        return PathMeasure.native_isClosed(this.native_instance);
    }

    public boolean nextContour() {
        return PathMeasure.native_nextContour(this.native_instance);
    }

    protected void finalize() throws Throwable {
        PathMeasure.native_destroy(this.native_instance);
        this.native_instance = 0L;
    }

    @LayoutlibDelegate
    private static long native_create(long l, boolean bl) {
        return PathMeasure_Delegate.native_create(l, bl);
    }

    @LayoutlibDelegate
    private static void native_setPath(long l, long l2, boolean bl) {
        PathMeasure_Delegate.native_setPath(l, l2, bl);
    }

    @LayoutlibDelegate
    private static float native_getLength(long l) {
        return PathMeasure_Delegate.native_getLength(l);
    }

    @LayoutlibDelegate
    private static boolean native_getPosTan(long l, float f, float[] fArray, float[] fArray2) {
        return PathMeasure_Delegate.native_getPosTan(l, f, fArray, fArray2);
    }

    @LayoutlibDelegate
    private static boolean native_getMatrix(long l, float f, long l2, int n) {
        return PathMeasure_Delegate.native_getMatrix(l, f, l2, n);
    }

    @LayoutlibDelegate
    private static boolean native_getSegment(long l, float f, float f2, long l2, boolean bl) {
        return PathMeasure_Delegate.native_getSegment(l, f, f2, l2, bl);
    }

    @LayoutlibDelegate
    private static boolean native_isClosed(long l) {
        return PathMeasure_Delegate.native_isClosed(l);
    }

    @LayoutlibDelegate
    private static boolean native_nextContour(long l) {
        return PathMeasure_Delegate.native_nextContour(l);
    }

    @LayoutlibDelegate
    private static void native_destroy(long l) {
        PathMeasure_Delegate.native_destroy(l);
    }
}

