/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.converters;

import com.intellij.hibernate.HibernateMessages;
import com.intellij.hibernate.model.enums.CascadeType;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CascadeTypeListConverter
extends DelimitedListConverter<CascadeType> {
    public CascadeTypeListConverter() {
        super(", ");
    }

    protected CascadeType convertString(@Nullable String string, ConvertContext context) {
        if (string == null) {
            return null;
        }
        return (CascadeType)NamedEnumUtil.getEnumElementByValue(CascadeType.class, (String)string);
    }

    protected String toString(@Nullable CascadeType cascadeType) {
        return cascadeType == null ? null : cascadeType.getValue();
    }

    protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<? extends List<CascadeType>> genericDomValue) {
        ArrayList<CascadeType> variants = new ArrayList<CascadeType>(Arrays.asList(CascadeType.values()));
        CascadeTypeListConverter.filterVariants(variants, genericDomValue);
        return ElementPresentationManager.getInstance().createVariants(variants, cascadeType -> cascadeType.getValue());
    }

    protected PsiElement resolveReference(@Nullable CascadeType cascadeType, ConvertContext context) {
        return cascadeType == null ? null : context.getReferenceXmlElement();
    }

    protected String getUnresolvedMessage(String value) {
        return MessageFormat.format(HibernateMessages.message("cannot.resolve.cascade.type.0", new Object[0]), value);
    }
}

