/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.hibernate.HibernateMessages;
import com.intellij.hibernate.model.xml.HibernateMappingVisitor;
import com.intellij.hibernate.model.xml.mapping.HbmClassBase;
import com.intellij.hibernate.model.xml.mapping.HbmJoinedSubclass;
import com.intellij.hibernate.model.xml.mapping.HbmSubclass;
import com.intellij.hibernate.model.xml.mapping.HbmUnionSubclass;
import com.intellij.ide.TypePresentationService;
import com.intellij.psi.PsiClass;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;

public class HibernateMappingHighlightingVisitor
extends HibernateMappingVisitor {
    private final DomElementAnnotationHolder myAnnotator;

    public HibernateMappingHighlightingVisitor(DomElementAnnotationHolder annotator) {
        this.myAnnotator = annotator;
    }

    private void checkHierarchy(HbmClassBase o, GenericDomValue<PsiClass> extendsValue) {
        if (o.getParent() instanceof HbmClassBase) {
            this.checkClassExtends(o, (GenericDomValue<PsiClass>)((HbmClassBase)o.getParent()).getClazz());
            if (DomUtil.hasXml(extendsValue)) {
                this.myAnnotator.createProblem(extendsValue, HibernateMessages.message("message.0.should.not.be.specified.for.nested.1", extendsValue.getXmlElementName(), TypePresentationService.getService().getTypePresentableName(o.getClass())), new LocalQuickFix[0]);
            }
        } else {
            this.checkClassExtends(o, extendsValue);
        }
    }

    private void checkClassExtends(HbmClassBase subclass, GenericDomValue<PsiClass> superclass) {
        PsiClass psiSubclass = (PsiClass)subclass.getClazz().getValue();
        PsiClass psiSuperclass = (PsiClass)superclass.getValue();
        if (psiSubclass != null && psiSuperclass != null && !psiSubclass.isInheritor(psiSuperclass, true)) {
            this.myAnnotator.createProblem((DomElement)subclass.getClazz(), HibernateMessages.message("message.0.should.be.sublclass.of.1", psiSubclass.getQualifiedName(), psiSuperclass.getQualifiedName()), new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitHbmSubclass(HbmSubclass o) {
        super.visitHbmSubclass(o);
        this.checkHierarchy(o, (GenericDomValue<PsiClass>)o.getExtends());
    }

    @Override
    public void visitHbmUnionSubclass(HbmUnionSubclass o) {
        super.visitHbmUnionSubclass(o);
        this.checkHierarchy(o, (GenericDomValue<PsiClass>)o.getExtends());
    }

    @Override
    public void visitHbmJoinedSubclass(HbmJoinedSubclass o) {
        super.visitHbmJoinedSubclass(o);
        this.checkHierarchy(o, (GenericDomValue<PsiClass>)o.getExtends());
    }
}

