/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.impl.ui.FacetEditorsFactoryImpl;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.libraries.FrameworkLibraryValidator;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.hibernate.facet.HibernateLibraryType;
import com.intellij.hibernate.facet.ui.HibernateGeneralEditorTab;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;

public class HibernateFacetConfiguration
implements FacetConfiguration {
    private final ConfigFileInfoSet myDescriptorsConfiguration;
    private final Map<String, String> myUnitToDataSourceMap = new HashMap<String, String>();
    private final Map<String, String> myUnitToNamingStrategyMap = new HashMap<String, String>();

    public HibernateFacetConfiguration(ConfigFileInfoSet descriptorsConfiguration) {
        this.myDescriptorsConfiguration = descriptorsConfiguration;
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        FrameworkLibraryValidator validator = FacetEditorsFactoryImpl.getInstanceImpl().createLibraryValidator(DownloadableLibraryService.getInstance().createDescriptionForType(HibernateLibraryType.class), editorContext, validatorsManager, "hibernate");
        validatorsManager.registerValidator((FacetEditorValidator)validator, new JComponent[0]);
        HibernateGeneralEditorTab generalEditor = new HibernateGeneralEditorTab(this, editorContext);
        return new FacetEditorTab[]{generalEditor};
    }

    public void readExternal(Element element) throws InvalidDataException {
        JDOMExternalizer.readMap((Element)element, this.myUnitToDataSourceMap, (String)"datasource-map", (String)"unit-entry");
        JDOMExternalizer.readMap((Element)element, this.myUnitToNamingStrategyMap, (String)"naming-strategy-map", (String)"unit-entry");
        this.myDescriptorsConfiguration.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        JDOMExternalizer.writeMap((Element)element, this.myUnitToDataSourceMap, (String)"datasource-map", (String)"unit-entry");
        JDOMExternalizer.writeMap((Element)element, this.myUnitToNamingStrategyMap, (String)"naming-strategy-map", (String)"unit-entry");
        this.myDescriptorsConfiguration.writeExternal(element);
    }

    public ConfigFileInfoSet getDescriptorsConfiguration() {
        return this.myDescriptorsConfiguration;
    }

    public Map<String, String> getUnitToDataSourceMap() {
        return this.myUnitToDataSourceMap;
    }

    public Map<String, String> getUnitToNamingStrategyMap() {
        return this.myUnitToNamingStrategyMap;
    }
}

