/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.xml.fake;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext;
import com.intellij.spring.contexts.model.visitors.SpringModelVisitors;
import com.intellij.spring.integration.model.jam.SpringMessagingHeader;
import com.intellij.spring.integration.model.xml.core.Chain;
import com.intellij.spring.integration.model.xml.core.Gateway;
import com.intellij.spring.integration.model.xml.core.GatewayMethod;
import com.intellij.spring.integration.model.xml.core.Header;
import com.intellij.spring.integration.model.xml.core.HeaderEnricherType;
import com.intellij.spring.integration.model.xml.core.HeaderSubElement;
import com.intellij.spring.integration.model.xml.core.HeaderValueRouterType;
import com.intellij.spring.integration.model.xml.core.InboundChannelAdapter;
import com.intellij.spring.integration.model.xml.core.UserDefinedHeader;
import com.intellij.spring.integration.model.xml.fake.SpringIntegrationHeadersFactory;
import com.intellij.spring.integration.util.SpringIntegrationJamUtil;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringIntegrationHeaderPsiReference
extends PsiReferenceBase<PsiElement> {
    private final String myHeaderName;
    private final Module myModule;
    private final NullableFunction<SpringMessagingHeader, String> HEADER_NAME_FUNCTION;
    private static final CommonSpringModelVisitorContext.Exec<String> DOM_HEADER_NAMES = (m, p) -> {
        if (!(m instanceof LocalXmlModel)) {
            return true;
        }
        DomFileElement beansFileElement = ((LocalXmlModel)m).getRoot();
        if (beansFileElement == null) {
            return true;
        }
        Beans beans = (Beans)beansFileElement.getRootElement();
        for (Gateway gateway : DomUtil.getChildrenOfType((DomElement)beans, Gateway.class)) {
            for (GatewayMethod gatewayMethod : gateway.getMethods()) {
                for (Header header : gatewayMethod.getHeaders()) {
                    if (SpringIntegrationHeaderPsiReference.processIfNotNull((Processor<String>)p, header.getName().getStringValue())) continue;
                    return false;
                }
            }
        }
        for (InboundChannelAdapter adapter : DomUtil.getChildrenOfType((DomElement)beans, InboundChannelAdapter.class)) {
            for (HeaderSubElement headerSubElement : adapter.getHeaders()) {
                if (SpringIntegrationHeaderPsiReference.processIfNotNull((Processor<String>)p, headerSubElement.getName().getStringValue())) continue;
                return false;
            }
        }
        for (Chain chain : DomUtil.getChildrenOfType((DomElement)beans, Chain.class)) {
            for (HeaderValueRouterType headerValueRouterType : chain.getHeaderValueRouters()) {
                if (SpringIntegrationHeaderPsiReference.processIfNotNull((Processor<String>)p, headerValueRouterType.getHeaderName().getStringValue())) continue;
                return false;
            }
            for (HeaderEnricherType headerEnricherType : chain.getHeaderEnrichers()) {
                for (UserDefinedHeader userDefinedHeader : headerEnricherType.getHeaders()) {
                    if (SpringIntegrationHeaderPsiReference.processIfNotNull((Processor<String>)p, userDefinedHeader.getName().getStringValue())) continue;
                    return false;
                }
            }
        }
        for (HeaderEnricherType headerEnricherType : DomUtil.getChildrenOfType((DomElement)beans, HeaderEnricherType.class)) {
            for (UserDefinedHeader userDefinedHeader : headerEnricherType.getHeaders()) {
                if (SpringIntegrationHeaderPsiReference.processIfNotNull((Processor<String>)p, userDefinedHeader.getName().getStringValue())) continue;
                return false;
            }
        }
        return true;
    };

    public SpringIntegrationHeaderPsiReference(@NotNull PsiElement element, @NotNull String roleName, @NotNull Module module) {
        if (element == null) {
            SpringIntegrationHeaderPsiReference.$$$reportNull$$$0(0);
        }
        if (roleName == null) {
            SpringIntegrationHeaderPsiReference.$$$reportNull$$$0(1);
        }
        if (module == null) {
            SpringIntegrationHeaderPsiReference.$$$reportNull$$$0(2);
        }
        super(element, TextRange.from((int)element.getText().indexOf(roleName), (int)roleName.length()));
        this.HEADER_NAME_FUNCTION = springIntegrationHeader -> {
            String name = springIntegrationHeader.getName();
            return StringUtil.isEmptyOrSpaces((String)name) ? null : name;
        };
        this.myHeaderName = roleName;
        this.myModule = module;
    }

    public PsiElement resolve() {
        if (StringUtil.isEmptyOrSpaces((String)this.myHeaderName)) {
            return null;
        }
        return SpringIntegrationHeadersFactory.getInstance(this.myModule).getOrCreateHeader(this.myHeaderName, this.getElement().getContainingFile());
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public Object[] getVariants() {
        HashSet<String> headers = new HashSet<String>();
        this.addDomConfiguredHeaders(headers);
        this.addJamHeaders(headers);
        Object[] objectArray = ArrayUtil.toObjectArray(headers);
        if (objectArray == null) {
            SpringIntegrationHeaderPsiReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    private void addJamHeaders(Set<String> headers) {
        List<SpringMessagingHeader> jamHeaders = SpringIntegrationJamUtil.getJamHeaders(this.myModule, this.getElement().getResolveScope());
        headers.addAll(ContainerUtil.mapNotNull(jamHeaders, this.HEADER_NAME_FUNCTION));
    }

    private void addDomConfiguredHeaders(@NotNull Set<String> headers) {
        if (headers == null) {
            SpringIntegrationHeaderPsiReference.$$$reportNull$$$0(4);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(headers);
        SpringModelVisitors.visitRelatedModels((CommonSpringModel)SpringManager.getInstance((Project)this.myModule.getProject()).getCombinedModel(this.myModule), (CommonSpringModelVisitorContext)CommonSpringModelVisitorContext.context((Processor)processor, DOM_HEADER_NAMES));
    }

    private static boolean processIfNotNull(Processor<String> processor, @Nullable String headerName) {
        return headerName == null || processor.process((Object)headerName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeaderPsiReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeaderPsiReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDomConfiguredHeaders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

