/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.integration.SpringIntegrationBundle;
import com.intellij.spring.integration.model.xml.amqp.ContainerAndTemplateSharedAttributes;
import com.intellij.spring.integration.model.xml.amqp.InboundType;
import com.intellij.spring.integration.model.xml.core.BasePoller;
import com.intellij.spring.integration.model.xml.core.ChannelAdapterDomSpringBean;
import com.intellij.spring.integration.model.xml.core.CommonClaimCheck;
import com.intellij.spring.integration.model.xml.core.ExpressionOrInnerEndpointDefinitionAware;
import com.intellij.spring.integration.model.xml.core.HandlerEndpoint;
import com.intellij.spring.integration.model.xml.core.InnerExpression;
import com.intellij.spring.integration.model.xml.core.InputOutputChannelOwner;
import com.intellij.spring.integration.model.xml.core.Poller;
import com.intellij.spring.integration.model.xml.core.Splitter;
import com.intellij.spring.integration.model.xml.file.OutboundFileBase;
import com.intellij.spring.integration.model.xml.jdbc.Jdbc;
import com.intellij.spring.integration.model.xml.jdbc.JdbcChannelAdapter;
import com.intellij.spring.integration.model.xml.jms.Channel;
import com.intellij.spring.integration.model.xml.jms.JmsChannelAdapter;
import com.intellij.spring.integration.model.xml.jms.MessageDrivenChannelAdapter;
import com.intellij.spring.integration.model.xml.jmx.MbeanServerIdentifier;
import com.intellij.spring.integration.model.xml.mongodb.MongodbAdapterType;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringDomInspectionUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ModelGenericVisitor
implements DomElementVisitor {
    private final DomElementAnnotationHolder holder;
    private final SpringDomInspectionUtils mySpringDomInspectionUtils;
    private boolean foundGlobalDefaultPoller = false;

    ModelGenericVisitor(DomElementAnnotationHolder holder) {
        this.holder = holder;
        this.mySpringDomInspectionUtils = new SpringDomInspectionUtils(holder);
    }

    public void visitDomElement(DomElement element) {
        this.checkGenericAttributes(element);
    }

    private void checkGenericAttributes(DomElement element) {
        InputOutputChannelOwner owner;
        SpringBeanPointer inputChannel;
        this.checkAmqp(element);
        this.checkCore(element);
        this.checkFile(element);
        this.checkJdbc(element);
        this.checkJms(element);
        this.checkJmx(element);
        this.checkMongodb(element);
        if (element instanceof ChannelAdapterDomSpringBean) {
            ChannelAdapterDomSpringBean channelBean = (ChannelAdapterDomSpringBean)element;
            this.mySpringDomInspectionUtils.oneOfOrAllRequired((DomElement)channelBean, new GenericAttributeValue[]{channelBean.getId(), channelBean.getChannel()});
        }
        if (element instanceof InputOutputChannelOwner && (inputChannel = (SpringBeanPointer)(owner = (InputOutputChannelOwner)element).getInputChannel().getValue()) != null) {
            boolean isPollableChannelInheritor;
            PsiClass channelClass = inputChannel.getBeanClass();
            boolean bl = isPollableChannelInheritor = InheritanceUtil.isInheritor((PsiClass)channelClass, (boolean)false, (String)"org.springframework.integration.core.PollableChannel") || InheritanceUtil.isInheritor((PsiClass)channelClass, (boolean)false, (String)"org.springframework.messaging.PollableChannel");
            if (isPollableChannelInheritor) {
                if (!this.foundGlobalDefaultPoller && DomUtil.getDefinedChildrenOfType((DomElement)owner, BasePoller.class, (boolean)true, (boolean)false).isEmpty()) {
                    this.holder.createProblem((DomElement)owner, SpringIntegrationBundle.message("SpringIntegrationModelInspection.input.channel.nested.or.global.poller.required", new Object[0]), new LocalQuickFix[0]);
                }
            } else {
                boolean isSubscribableChannelInheritor;
                boolean bl2 = isSubscribableChannelInheritor = InheritanceUtil.isInheritor((PsiClass)channelClass, (boolean)false, (String)"org.springframework.integration.core.SubscribableChannel") || InheritanceUtil.isInheritor((PsiClass)channelClass, (boolean)false, (String)"org.springframework.messaging.SubscribableChannel");
                if (isSubscribableChannelInheritor && !DomUtil.getDefinedChildrenOfType((DomElement)owner, BasePoller.class, (boolean)true, (boolean)false).isEmpty()) {
                    this.holder.createProblem((DomElement)owner, SpringIntegrationBundle.message("SpringIntegrationModelInspection.input.channel.no.nested.poller.allowed", new Object[0]), new LocalQuickFix[0]);
                }
            }
        }
    }

    private void checkAmqp(DomElement element) {
        if (element instanceof ContainerAndTemplateSharedAttributes) {
            ContainerAndTemplateSharedAttributes attributes = (ContainerAndTemplateSharedAttributes)element;
            this.mySpringDomInspectionUtils.explicitBeanRequired((DomElement)attributes, attributes.getConnectionFactory(), "rabbitConnectionFactory");
        }
        if (element instanceof InboundType) {
            InboundType inboundType = (InboundType)element;
            if (SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{inboundType.getListenerContainer()})) {
                return;
            }
            if (!SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{inboundType.getQueueNames()})) {
                this.holder.createProblem(element, SpringIntegrationBundle.message("SpringIntegrationModelInspection.amqp.inbound.queue.names.required.if.no.listener.container", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private void checkMongodb(DomElement element) {
        if (element instanceof MongodbAdapterType) {
            MongodbAdapterType adapterType = (MongodbAdapterType)element;
            this.mySpringDomInspectionUtils.onlyOneOf((DomElement)adapterType, new GenericAttributeValue[]{adapterType.getCollectionName(), adapterType.getCollectionNameExpression()});
        }
    }

    private void checkCore(DomElement element) {
        Poller poller;
        HandlerEndpoint handlerEndpoint;
        if (element instanceof CommonClaimCheck) {
            CommonClaimCheck transformer = (CommonClaimCheck)element;
            this.mySpringDomInspectionUtils.explicitBeanRequired((DomElement)transformer, transformer.getMessageStore(), "messageStore");
        }
        if (element instanceof ExpressionOrInnerEndpointDefinitionAware) {
            ExpressionOrInnerEndpointDefinitionAware springBean = (ExpressionOrInnerEndpointDefinitionAware)element;
            if (springBean.getGenericInfo().getCollectionChildrenDescriptions().size() > 4) {
                return;
            }
            boolean isSplitter = springBean instanceof Splitter;
            if (!isSplitter && !SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{ModelGenericVisitor.getExpression(springBean), springBean.getRef(), ModelGenericVisitor.getBeanOrScript(springBean)}) || SpringDomInspectionUtils.hasMoreThanOne((DomElement[])new DomElement[]{ModelGenericVisitor.getExpression(springBean), springBean.getRef(), ModelGenericVisitor.getBeanOrScript(springBean)})) {
                this.holder.createProblem((DomElement)springBean, SpringIntegrationBundle.message("SpringIntegrationModelInspection.ref.expression.or.inner.bean", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (element instanceof HandlerEndpoint && SpringDomInspectionUtils.hasMoreThanOne((DomElement[])new DomElement[]{(handlerEndpoint = (HandlerEndpoint)element).getRef(), ModelGenericVisitor.getBeanOrScript(handlerEndpoint)})) {
            this.holder.createProblem((DomElement)handlerEndpoint, SpringIntegrationBundle.message("SpringIntegrationModelInspection.ref.or.inner.bean", new Object[0]), new LocalQuickFix[0]);
        }
        if (element instanceof Poller && (poller = (Poller)element).getDefault().getValue() == Boolean.TRUE) {
            this.foundGlobalDefaultPoller = true;
        }
    }

    @NotNull
    private static DomElement getExpression(@NotNull ExpressionOrInnerEndpointDefinitionAware endpointDefinitionAware) {
        List<InnerExpression> expressions;
        if (endpointDefinitionAware == null) {
            ModelGenericVisitor.$$$reportNull$$$0(0);
        }
        DomElement domElement = (expressions = endpointDefinitionAware.getExpressions()).size() > 0 ? (DomElement)expressions.get(0) : endpointDefinitionAware.getExpressionAttr();
        if (domElement == null) {
            ModelGenericVisitor.$$$reportNull$$$0(1);
        }
        return domElement;
    }

    @NotNull
    private static DomElement getBeanOrScript(HandlerEndpoint springBean) {
        SpringBean bean = springBean.getBean();
        Object object = DomUtil.hasXml((DomElement)bean) ? bean : springBean.getScript();
        if (object == null) {
            ModelGenericVisitor.$$$reportNull$$$0(2);
        }
        return object;
    }

    private void checkFile(DomElement element) {
        if (element instanceof OutboundFileBase) {
            OutboundFileBase outboundFileBase = (OutboundFileBase)element;
            this.mySpringDomInspectionUtils.onlyOneOf(element, new GenericAttributeValue[]{outboundFileBase.getDirectory(), outboundFileBase.getDirectoryExpression()});
        }
    }

    private void checkJdbc(DomElement element) {
        if (element instanceof Jdbc) {
            Jdbc jdbc = (Jdbc)element;
            this.mySpringDomInspectionUtils.oneOfRequired((DomElement)jdbc, new DomElement[]{jdbc.getDataSource(), jdbc.getJdbcOperations()});
        }
        if (element instanceof JdbcChannelAdapter) {
            JdbcChannelAdapter channelAdapter = (JdbcChannelAdapter)element;
            this.mySpringDomInspectionUtils.oneOfRequired((DomElement)channelAdapter, new DomElement[]{channelAdapter.getQueryAttr(), channelAdapter.getQuery()});
        }
    }

    private void checkJms(DomElement element) {
        Channel channel;
        if (element instanceof JmsChannelAdapter) {
            boolean hasJmsTemplateOrContainer;
            JmsChannelAdapter channelAdapter = (JmsChannelAdapter)element;
            this.mySpringDomInspectionUtils.onlyOneOf((DomElement)channelAdapter, new GenericAttributeValue[]{channelAdapter.getDestination(), channelAdapter.getDestinationName()});
            boolean messageDrivenChannelAdapter = channelAdapter instanceof MessageDrivenChannelAdapter;
            boolean bl = hasJmsTemplateOrContainer = messageDrivenChannelAdapter ? SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{((MessageDrivenChannelAdapter)channelAdapter).getContainer()}) : SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{channelAdapter.getJmsTemplate()});
            if (hasJmsTemplateOrContainer) {
                return;
            }
            if (SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{channelAdapter.getDestination(), channelAdapter.getDestinationName()})) {
                return;
            }
            this.holder.createProblem((DomElement)channelAdapter, SpringIntegrationBundle.message("SpringIntegrationModelInspection.jms.channel.adapter.either.x.or.others", new Object[0]), new LocalQuickFix[0]);
        }
        if (element instanceof Channel && (channel = (Channel)element).getExplicitQosEnabled().getValue() != Boolean.TRUE && SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{channel.getDeliveryPersistent(), channel.getTimeToLive(), channel.getPriority()})) {
            this.holder.createProblem((DomElement)channel, SpringIntegrationBundle.message("SpringIntegrationModelInspection.jms.qos.not.effective", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private void checkJmx(DomElement element) {
        if (element instanceof MbeanServerIdentifier) {
            MbeanServerIdentifier mbeanServerIdentifier = (MbeanServerIdentifier)element;
            if (DomUtil.hasXml(mbeanServerIdentifier.getServer())) {
                return;
            }
            if (SpringDomInspectionUtils.existsBean((DomElement)mbeanServerIdentifier, (String)"javax.management.MBeanServer", (String)"mbeanServer")) {
                return;
            }
            this.holder.createProblem((DomElement)mbeanServerIdentifier, SpringIntegrationBundle.message("SpringIntegrationModelInspection.mbean.server.not.found", new Object[0]), new LocalQuickFix[]{new CreateMBeanServerQuickFix(mbeanServerIdentifier)});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpointDefinitionAware";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/inspections/ModelGenericVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/inspections/ModelGenericVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanOrScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExpression";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateMBeanServerQuickFix
    implements LocalQuickFix {
        private final MbeanServerIdentifier myMbeanServerIdentifier;

        private CreateMBeanServerQuickFix(MbeanServerIdentifier mbeanServerIdentifier) {
            this.myMbeanServerIdentifier = mbeanServerIdentifier;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringIntegrationBundle.message("SpringIntegrationModelInspection.quickfix.create.context.mbean", new Object[0]);
            if (string == null) {
                CreateMBeanServerQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            DomCollectionChildDescription mbeanServer;
            Beans beans;
            if (project == null) {
                CreateMBeanServerQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                CreateMBeanServerQuickFix.$$$reportNull$$$0(2);
            }
            if ((beans = (Beans)this.myMbeanServerIdentifier.getParentOfType(Beans.class, false)) != null && (mbeanServer = beans.getGenericInfo().getCollectionChildDescription("mbean-server", "Spring Context namespace key")) != null) {
                mbeanServer.addValue((DomElement)beans);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/integration/inspections/ModelGenericVisitor$CreateMBeanServerQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/integration/inspections/ModelGenericVisitor$CreateMBeanServerQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

