/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.webSphere;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.JpsBuilderArtifactService;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.ExplodedDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.webSphere.LooseAppBuildTarget;
import org.jetbrains.jps.webSphere.LooseAppBuildTargetType;

public class LooseAppBuilder
extends TargetBuilder<ArtifactRootDescriptor, LooseAppBuildTarget> {
    private static final Logger LOG = Logger.getInstance(LooseAppBuilder.class);
    private static final String ARCHIVE_ELEMENT_NAME = "archive";
    private static final String DIR_ELEMENT_NAME = "dir";
    private static final String FILE_ELEMENT_NAME = "file";
    private static final String SRC_ATTRIBUTE_NAME = "sourceOnDisk";
    private static final String TARGET_ATTRIBUTE_NAME = "targetInArchive";
    public static final String BUILDER_NAME = "Loose app builder";

    protected LooseAppBuilder() {
        super(Collections.singletonList(LooseAppBuildTargetType.INSTANCE));
    }

    public void build(@NotNull LooseAppBuildTarget target, @NotNull DirtyFilesHolder<ArtifactRootDescriptor, LooseAppBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            LooseAppBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            LooseAppBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            LooseAppBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            LooseAppBuilder.$$$reportNull$$$0(3);
        }
        JpsArtifact artifact = target.getArtifact();
        String outputFilePath = artifact.getOutputFilePath();
        String artifactName = artifact.getName();
        if (StringUtil.isEmpty((String)outputFilePath)) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, "Cannot build '" + artifactName + "' loose application: output path is not specified"));
            return;
        }
        Element root = new Element(ARCHIVE_ELEMENT_NAME);
        Document document = new Document(root);
        LOG.info("Building loose application '" + artifactName + "'...");
        BuildHandler buildHandler = new BuildHandler(context.getProjectDescriptor());
        buildHandler.buildLooseApplication(artifact, root);
        File looseApplication = new File(outputFilePath + ".xml");
        FileUtil.createIfDoesntExist((File)looseApplication);
        JDOMUtil.writeDocument((Document)document, (File)looseApplication, (String)SystemProperties.getLineSeparator());
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            LooseAppBuilder.$$$reportNull$$$0(4);
        }
        return BUILDER_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/webSphere/LooseAppBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/webSphere/LooseAppBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BuildHandler {
        private final ProjectDescriptor myProjectDescriptor;
        private final Collection<JpsArtifact> myArtifacts;

        BuildHandler(ProjectDescriptor projectDescriptor) {
            this.myProjectDescriptor = projectDescriptor;
            this.myArtifacts = JpsBuilderArtifactService.getInstance().getArtifacts(projectDescriptor.getModel(), true);
        }

        private void buildLooseApplication(JpsArtifact artifact, Element root) throws IOException {
            String output = artifact.getOutputFilePath();
            HashSet<JarInfo> jars = new HashSet<JarInfo>();
            for (ArtifactRootDescriptor descriptor : this.myProjectDescriptor.getBuildRootIndex().getTargetRoots((BuildTarget)new ArtifactBuildTarget(artifact), null)) {
                DestinationInfo destination = descriptor.getDestinationInfo();
                if (destination instanceof ExplodedDestinationInfo) {
                    this.processArtifactDescriptor(descriptor, output, root);
                    continue;
                }
                jars.add(((JarDestinationInfo)destination).getJarInfo());
            }
            this.buildArchives(jars, root, output);
        }

        private void buildArchives(Set<JarInfo> jars, Element root, String output) throws IOException {
            Set<Object> jarsToBuild = new HashSet();
            if (jars.size() > 1) {
                for (JarInfo jarInfo : jars) {
                    DestinationInfo destination = jarInfo.getDestination();
                    if (!FileUtil.pathsEqual((String)destination.getOutputPath(), (String)destination.getOutputFilePath())) continue;
                    jarsToBuild.add(jarInfo);
                }
            } else {
                jarsToBuild = jars;
            }
            for (JarInfo jarInfo : jarsToBuild) {
                String target = BuildHandler.createTargetPath(jarInfo.getDestination(), output);
                Element nestedRoot = BuildHandler.addArchiveElement(root, target);
                for (Pair pair : jarInfo.getContent()) {
                    if (pair.getSecond() instanceof ArtifactRootDescriptor) {
                        ArtifactRootDescriptor descriptor = (ArtifactRootDescriptor)pair.getSecond();
                        this.processArtifactDescriptor(descriptor, output, nestedRoot);
                        continue;
                    }
                    JarInfo nestedJar = (JarInfo)pair.getSecond();
                    this.buildArchives(Collections.singleton(nestedJar), nestedRoot, nestedJar.getDestination().getOutputFilePath());
                }
            }
        }

        private void processArtifactDescriptor(ArtifactRootDescriptor descriptor, String output, Element root) throws IOException {
            File rootFile = descriptor.getRootFile();
            String rootFilePath = rootFile.getAbsolutePath();
            String target = BuildHandler.createTargetPath(descriptor.getDestinationInfo(), output);
            JpsArtifact nestedArtifact = this.getArtifact(rootFilePath);
            if (nestedArtifact != null) {
                Element nestedRoot = BuildHandler.addArchiveElement(root, target);
                this.buildLooseApplication(nestedArtifact, nestedRoot);
            } else if (rootFile.exists()) {
                BuildHandler.addContentElement(root, descriptor, target);
            }
        }

        private static String createTargetPath(DestinationInfo destination, String output) {
            String outputFilePath = FileUtil.getRelativePath((String)output, (String)destination.getOutputFilePath(), (char)'/');
            return destination instanceof JarDestinationInfo ? ((JarDestinationInfo)destination).getPathInJar() : (StringUtil.isEmpty((String)outputFilePath) || outputFilePath.equals(".") ? "/" : "/" + outputFilePath);
        }

        private static Element addArchiveElement(Element root, String target) {
            Element nestedRoot = root;
            if (target.length() > 1) {
                nestedRoot = new Element(LooseAppBuilder.ARCHIVE_ELEMENT_NAME);
                nestedRoot.setAttribute(LooseAppBuilder.TARGET_ATTRIBUTE_NAME, target);
                root.addContent(nestedRoot);
            }
            return nestedRoot;
        }

        private static void addContentElement(Element root, ArtifactRootDescriptor descriptor, String target) {
            File rootFile = descriptor.getRootFile();
            Element content = new Element(rootFile.isDirectory() ? LooseAppBuilder.DIR_ELEMENT_NAME : LooseAppBuilder.FILE_ELEMENT_NAME);
            content.setAttribute(LooseAppBuilder.SRC_ATTRIBUTE_NAME, rootFile.getAbsolutePath());
            content.setAttribute(LooseAppBuilder.TARGET_ATTRIBUTE_NAME, target.isEmpty() ? "/" : target);
            root.addContent(content);
        }

        private JpsArtifact getArtifact(String outputPath) throws IOException {
            for (JpsArtifact artifact : this.myArtifacts) {
                if (!FileUtil.pathsEqual((String)outputPath, (String)artifact.getOutputFilePath())) continue;
                return artifact;
            }
            return null;
        }
    }
}

