/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.intellij.j2ee.web.resin.ResinBundle;
import org.intellij.j2ee.web.resin.ResinPersistentData;
import org.intellij.j2ee.web.resin.resin.ResinInstallation;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SelectResinLocationEditor
extends ApplicationServerPersistentDataEditor<ResinPersistentData> {
    @NonNls
    private static final String RESIN_CONF_FILE = "conf/resin.xml";
    @NonNls
    private static final String OLD_RESIN_CONF_FILE = "conf/resin.conf";
    private JPanel mainPanel;
    private TextFieldWithBrowseButton resinHomeSelector;
    private JLabel resinVersionLabel;
    private JCheckBox includeAllResinjarsCheckbox;
    private TextFieldWithBrowseButton defaultResinConf;
    private JLabel myErrorLabel;
    private boolean suggestConfPath = false;
    private boolean myHasHomeError;

    public SelectResinLocationEditor() {
        this.$$$setupUI$$$();
        SelectResinLocationEditor.initChooser(this.resinHomeSelector, ResinBundle.message("message.text.locator.resin.home.title", new Object[0]), ResinBundle.message("message.text.locator.resin.home.summary", new Object[0]), false, true);
        SelectResinLocationEditor.initChooser(this.defaultResinConf, ResinBundle.message("message.text.locator.resin.conf.title", new Object[0]), ResinBundle.message("message.text.locator.resin.conf.summary", new Object[0]), true, false);
        this.resinHomeSelector.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SelectResinLocationEditor.this.suggestConfPath = true;
                SelectResinLocationEditor.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/j2ee/web/resin/ui/SelectResinLocationEditor$1", "textChanged"));
            }
        });
        this.defaultResinConf.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                SelectResinLocationEditor.this.suggestConfPath = false;
                SelectResinLocationEditor.this.updateConfPath();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/j2ee/web/resin/ui/SelectResinLocationEditor$2", "textChanged"));
            }
        });
        this.includeAllResinjarsCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SelectResinLocationEditor.this.update();
            }
        });
        this.myErrorLabel.setIcon(AllIcons.General.BalloonError);
        this.update();
    }

    private void update() {
        ResinInstallation installation;
        String homePath = this.resinHomeSelector.getText();
        this.myErrorLabel.setText("");
        try {
            installation = ResinInstallation.create(homePath);
        }
        catch (ExecutionException e) {
            this.myErrorLabel.setText(e.getMessage());
            this.myErrorLabel.setVisible(true);
            this.myHasHomeError = true;
            return;
        }
        this.hideError();
        this.myHasHomeError = false;
        if (!installation.isVersionDetected()) {
            this.resinVersionLabel.setText(ResinBundle.message("location.dlg.detected.version.unknown", new Object[0]));
        } else {
            this.resinVersionLabel.setText(installation.getVersion().toString());
            if (this.suggestConfPath) {
                File resinConfDef = new File(homePath, FileUtil.toSystemDependentName((String)RESIN_CONF_FILE));
                if (resinConfDef.exists()) {
                    this.defaultResinConf.setText(resinConfDef.getAbsoluteFile().getAbsolutePath());
                } else {
                    resinConfDef = new File(homePath, FileUtil.toSystemDependentName((String)OLD_RESIN_CONF_FILE));
                    if (resinConfDef.exists()) {
                        this.defaultResinConf.setText(resinConfDef.getAbsoluteFile().getAbsolutePath());
                    }
                }
            }
        }
        this.updateConfPath();
    }

    private void updateConfPath() {
        File confFile;
        if (this.myHasHomeError) {
            return;
        }
        String confFilePath = this.defaultResinConf.getText();
        File file = confFile = StringUtil.isEmpty((String)confFilePath) ? null : new File(confFilePath);
        if (confFile == null) {
            this.showError(ResinBundle.message("message.error.resin.conf.doesnt.chosen", new Object[0]));
            return;
        }
        if (!confFile.exists()) {
            this.showError(ResinBundle.message("message.error.resin.conf.doesnt.exist", ""));
            return;
        }
        if (confFile.isDirectory()) {
            this.showError(ResinBundle.message("message.error.resin.conf.directory", confFile.getAbsolutePath()));
            return;
        }
        this.hideError();
    }

    private void showError(String errorMsg) {
        this.myErrorLabel.setText(errorMsg);
        this.myErrorLabel.setVisible(true);
    }

    private void hideError() {
        this.myErrorLabel.setVisible(false);
    }

    protected void resetEditorFrom(@NotNull ResinPersistentData resinPersistentData) {
        if (resinPersistentData == null) {
            SelectResinLocationEditor.$$$reportNull$$$0(0);
        }
        this.suggestConfPath = resinPersistentData.RESIN_HOME == null;
        this.resinHomeSelector.setText(resinPersistentData.RESIN_HOME);
        this.includeAllResinjarsCheckbox.setSelected(resinPersistentData.INCLUDE_ALL_JARS);
        this.defaultResinConf.setText(resinPersistentData.RESIN_CONF);
        this.update();
    }

    protected void applyEditorTo(@NotNull ResinPersistentData data) {
        if (data == null) {
            SelectResinLocationEditor.$$$reportNull$$$0(1);
        }
        data.RESIN_HOME = this.resinHomeSelector.getText();
        data.RESIN_CONF = this.defaultResinConf.getText();
        data.INCLUDE_ALL_JARS = this.includeAllResinjarsCheckbox.isSelected();
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            SelectResinLocationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private static void initChooser(TextFieldWithBrowseButton field, String title, String description, boolean chooseFiles, boolean chooseDirs) {
        field.setText("");
        field.getTextField().setEditable(true);
        field.addBrowseFolderListener(title, description, null, new FileChooserDescriptor(chooseFiles, chooseDirs, false, false, false, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resinPersistentData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/j2ee/web/resin/ui/SelectResinLocationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/j2ee/web/resin/ui/SelectResinLocationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("location.dlg.resin.home.text"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.resinHomeSelector = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 1, 1, 3, 0, null, new Dimension(200, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("location.dlg.detected.version"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.resinVersionLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("location.dlg.detected.version.default"));
        jPanel.add((Component)jLabel2, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("location.dlg.resin.include.jars"));
        jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.includeAllResinjarsCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("location.dlg.default.resin.conf"));
        jPanel.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.defaultResinConf = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 1, 1, 3, 0, null, new Dimension(200, -1), null));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

