/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.intellij.j2ee.web.resin.ResinBundle;
import org.intellij.j2ee.web.resin.ResinModelBase;
import org.intellij.j2ee.web.resin.resin.ResinInstallation;
import org.intellij.j2ee.web.resin.resin.WebApp;
import org.intellij.j2ee.web.resin.resin.common.MBeanUtil;
import org.intellij.j2ee.web.resin.resin.configuration.JmxConfigurationStrategy;
import org.intellij.j2ee.web.resin.resin.configuration.ResinConfigurationStrategy;
import org.intellij.j2ee.web.resin.resin.jmx.ConnectorCommandBase;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Resin3XConfigurationStrategy
extends ResinConfigurationStrategy
implements JmxConfigurationStrategy {
    private static final Logger LOG = Logger.getInstance(Resin3XConfigurationStrategy.class);
    @NonNls
    protected static final String SERVER_ELEMENT = "server";
    @NonNls
    protected static final String SERVER_DEFAULT_ELEMENT = "server-default";
    @NonNls
    protected static final String HTTP = "http";
    @NonNls
    protected static final String PORT = "port";
    @NonNls
    protected static final String DIRTY_ATTR = "dirty";
    @NonNls
    protected static final String WEB_APP_ELEMENT = "web-app";
    @NonNls
    protected static final String ID = "id";
    @NonNls
    private static final String DOCUMENT_DIRECTORY_ATTR = "document-directory";
    @NonNls
    private static final String ARCHIVE_PATH_ATTR = "archive-path";
    @NonNls
    protected static final String HOST = "host";
    @NonNls
    protected static final String CHARSET = "character-encoding";
    @NonNls
    private static final String HOST_DEFAULT_ELEMENT = "host-default";
    @NonNls
    private static final String WEB_APP_DEPLOY_ELEMENT = "web-app-deploy";
    @NonNls
    private static final String ROOT_CONTEXT_PATH = "/";
    @NonNls
    private static final String ROOT_EXPAND_DIR = "ROOT";
    @NonNls
    private static final String DEFAULT_EXPAND_DIR = "webapps";
    @NonNls
    private static final String PATH_ATTR = "path";
    @NonNls
    private static final String REGEXP_ATTR = "regexp";
    @NonNls
    protected static final String RESIN_CONF = "resin3.conf";
    public static final ObjectName MBEAN_WEB_APP_DEPLOY = MBeanUtil.newObjectName("resin:type=WebAppDeploy,Host=default,name=webapps");
    @NonNls
    private static final String MBEAN_WEB_APP_PREFIX = "resin:type=WebApp,Host=default,name=/";
    @NonNls
    public static final String STATE_JMX_ATTRIBUTE = "State";
    @NonNls
    public static final String STATE_JMX_ATTRIBUTE_ACTIVE = "active";
    @NonNls
    public static final String STATE_JMX_ATTRIBUTE_ERROR = "error";
    @NonNls
    public static final String STATE_JMX_ATTRIBUTE_FAILED = "failed";
    private final ResinInstallation myResinInstallation;
    private final NotNullLazyValue<ElementsProvider> myElementsProvider = new NotNullLazyValue<ElementsProvider>(){

        @NotNull
        protected ElementsProvider compute() {
            ElementsProvider elementsProvider = Resin3XConfigurationStrategy.this.createElementsProvider();
            if (elementsProvider == null) {
                1.$$$reportNull$$$0(0);
            }
            return elementsProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/j2ee/web/resin/resin/configuration/Resin3XConfigurationStrategy$1", "compute"));
        }
    };

    public Resin3XConfigurationStrategy(ResinInstallation resinInstallation) {
        this.myResinInstallation = resinInstallation;
    }

    protected final ResinInstallation getInstallation() {
        return this.myResinInstallation;
    }

    @Override
    public void setPort(int port) {
        ElementsProvider elementsProvider = this.getElementsProvider();
        Element httpElement = elementsProvider.getOrCreateChildElement(elementsProvider.getParamParentElement(), HTTP);
        httpElement.setAttribute(PORT, Integer.toString(port));
    }

    @Override
    public boolean deploy(WebApp webApp) throws ExecutionException {
        String charset;
        Ref dirty = new Ref((Object)false);
        ElementsProvider elementsProvider = this.getElementsProvider();
        Namespace ns = elementsProvider.getNS();
        Element host = this.getHost(webApp);
        Resin3XConfigurationStrategy.removeAttribute(host, DIRTY_ATTR, (Ref<Boolean>)dirty);
        String location = webApp.getLocation();
        boolean isExploded = new File(location).isDirectory();
        String contextPath = webApp.getContextPath();
        Element webAppEl = Resin3XConfigurationStrategy.findWebAppElement(host, contextPath);
        if (webAppEl == null) {
            webAppEl = new Element(WEB_APP_ELEMENT, ns);
            webAppEl.setAttribute(ID, contextPath);
            host.addContent(webAppEl);
            dirty.set((Object)true);
        }
        String expandDirAttr = this.getExpandDirAttr();
        Resin3XConfigurationStrategy.setAttribute(webAppEl, isExploded ? expandDirAttr : ARCHIVE_PATH_ATTR, location, (Ref<Boolean>)dirty);
        if (!isExploded) {
            String webAppDeployPath;
            Element webAppDeployEl;
            StringBuilder expandDir = null;
            Element hostParent = elementsProvider.getHostParent();
            Element hostDefaultEl = hostParent.getChild(HOST_DEFAULT_ELEMENT, ns);
            if (hostDefaultEl != null && (webAppDeployEl = hostDefaultEl.getChild(WEB_APP_DEPLOY_ELEMENT, ns)) != null && StringUtil.isNotEmpty((String)(webAppDeployPath = webAppDeployEl.getAttributeValue(PATH_ATTR)))) {
                expandDir = new StringBuilder(webAppDeployPath);
            }
            if (expandDir == null) {
                expandDir = new StringBuilder(DEFAULT_EXPAND_DIR);
            }
            expandDir.append(ROOT_CONTEXT_PATH);
            expandDir.append(ROOT_CONTEXT_PATH.equals(contextPath) ? ROOT_EXPAND_DIR : FileUtil.sanitizeFileName((String)StringUtil.trimStart((String)contextPath, (String)ROOT_CONTEXT_PATH)));
            Resin3XConfigurationStrategy.setAttribute(webAppEl, expandDirAttr, expandDir.toString(), (Ref<Boolean>)dirty, true);
        }
        if ((charset = webApp.getCharSet()) == null || StringUtil.isEmptyOrSpaces((String)charset)) {
            Resin3XConfigurationStrategy.removeAttribute(webAppEl, CHARSET, (Ref<Boolean>)dirty);
        } else {
            Resin3XConfigurationStrategy.setAttribute(webAppEl, CHARSET, charset.trim(), (Ref<Boolean>)dirty);
        }
        return (Boolean)dirty.get();
    }

    protected String getExpandDirAttr() {
        return DOCUMENT_DIRECTORY_ATTR;
    }

    private static Element findWebAppElement(Element host, String contextPath) {
        List webApps = host.getChildren(WEB_APP_ELEMENT, host.getNamespace());
        if (webApps != null) {
            for (Object webApp : webApps) {
                Element webAppEl = (Element)webApp;
                if (!webAppEl.getAttribute(ID).getValue().equals(contextPath)) continue;
                return webAppEl;
            }
        }
        return null;
    }

    private static void setAttribute(Element element, String name, String value, Ref<Boolean> dirty) {
        Resin3XConfigurationStrategy.setAttribute(element, name, value, dirty, false);
    }

    private static void setAttribute(Element element, String name, String value, Ref<Boolean> dirty, boolean keepExisting) {
        Attribute existingAttribute = element.getAttribute(name);
        if (existingAttribute == null || !keepExisting && !existingAttribute.getValue().equals(value)) {
            element.setAttribute(name, value);
            dirty.set((Object)true);
        }
    }

    private static void removeAttribute(Element element, String name, Ref<Boolean> dirty) {
        if (element.getAttribute(name) != null) {
            element.removeAttribute(name);
            dirty.set((Object)true);
        }
    }

    private Element getHost(WebApp webApp) throws ExecutionException {
        try {
            ElementsProvider elementsProvider = this.getElementsProvider();
            Namespace ns = elementsProvider.getNS();
            Element hostParent = elementsProvider.getHostParent();
            String webAppHost = webApp.getHost();
            List hosts = hostParent.getChildren(HOST, ns);
            if (hosts != null) {
                for (Object host1 : hosts) {
                    Element host = (Element)host1;
                    Attribute idAttribute = host.getAttribute(ID);
                    if (idAttribute != null && StringUtil.equals((CharSequence)idAttribute.getValue(), (CharSequence)webAppHost)) {
                        return host;
                    }
                    Attribute regexpAttribute = host.getAttribute(REGEXP_ATTR);
                    if (regexpAttribute == null || !webAppHost.matches(regexpAttribute.getValue())) continue;
                    return host;
                }
            }
            Element host = new Element(HOST, ns);
            host.setAttribute(ID, webApp.getHost());
            host.setAttribute(DIRTY_ATTR, "true");
            hostParent.addContent(host);
            return host;
        }
        catch (Exception e) {
            throw new ExecutionException(ResinBundle.message("resin.conf.parse.error", new Object[0]), (Throwable)e);
        }
    }

    @Override
    public boolean undeploy(WebApp webApp) {
        boolean dirty = false;
        ElementsProvider elementsProvider = this.getElementsProvider();
        Namespace ns = elementsProvider.getNS();
        List hosts = elementsProvider.getHostParent().getChildren(HOST, ns);
        if (hosts != null) {
            for (Object host : hosts) {
                Element hostEl = (Element)host;
                Element webAppEl = Resin3XConfigurationStrategy.findWebAppElement(hostEl, webApp.getContextPath());
                if (webAppEl == null) continue;
                hostEl.removeContent((Content)webAppEl);
                dirty = true;
            }
        }
        return dirty;
    }

    @Override
    public InputStream getDefaultResinConfContent() {
        return this.getClass().getResourceAsStream(RESIN_CONF);
    }

    @Override
    public boolean deployWithJmx(ResinModelBase resinModel, WebApp webApp) {
        File webAppFile = new File(FileUtil.toSystemDependentName((String)webApp.getLocation()));
        if (!webAppFile.exists()) {
            LOG.error("Can't find web app");
            return false;
        }
        if (this.getDeployStateWithJmx(resinModel, webApp, (Ref<Boolean>)new Ref()) != DeploymentStatus.UNKNOWN && !new UndeployCommand(resinModel, webAppFile).safeExecute()) {
            return false;
        }
        if (!Resin3XConfigurationStrategy.cleanUpWebApp(resinModel, webAppFile)) {
            return true;
        }
        if (!resinModel.transferFile(webAppFile)) {
            return false;
        }
        return new DeployCommand(resinModel, "start", webAppFile.getName()).safeExecute();
    }

    @Override
    @NotNull
    public DeploymentStatus getDeployStateWithJmx(ResinModelBase resinModel, WebApp webApp, Ref<Boolean> isFinal) {
        File webAppFile = new File(FileUtil.toSystemDependentName((String)webApp.getLocation()));
        if (!webAppFile.exists()) {
            isFinal.set((Object)true);
            DeploymentStatus deploymentStatus = DeploymentStatus.FAILED;
            if (deploymentStatus == null) {
                Resin3XConfigurationStrategy.$$$reportNull$$$0(0);
            }
            return deploymentStatus;
        }
        GetStateCommand getStateCommand = new GetStateCommand(resinModel, webAppFile);
        if (!getStateCommand.safeExecute()) {
            isFinal.set((Object)true);
            DeploymentStatus deploymentStatus = DeploymentStatus.FAILED;
            if (deploymentStatus == null) {
                Resin3XConfigurationStrategy.$$$reportNull$$$0(1);
            }
            return deploymentStatus;
        }
        String state = (String)getStateCommand.getResult();
        if (STATE_JMX_ATTRIBUTE_ACTIVE.equalsIgnoreCase(state)) {
            isFinal.set((Object)true);
            DeploymentStatus deploymentStatus = DeploymentStatus.DEPLOYED;
            if (deploymentStatus == null) {
                Resin3XConfigurationStrategy.$$$reportNull$$$0(2);
            }
            return deploymentStatus;
        }
        if (STATE_JMX_ATTRIBUTE_ERROR.equalsIgnoreCase(state) || STATE_JMX_ATTRIBUTE_FAILED.equalsIgnoreCase(state)) {
            isFinal.set((Object)true);
            DeploymentStatus deploymentStatus = DeploymentStatus.FAILED;
            if (deploymentStatus == null) {
                Resin3XConfigurationStrategy.$$$reportNull$$$0(3);
            }
            return deploymentStatus;
        }
        DeploymentStatus deploymentStatus = DeploymentStatus.UNKNOWN;
        if (deploymentStatus == null) {
            Resin3XConfigurationStrategy.$$$reportNull$$$0(4);
        }
        return deploymentStatus;
    }

    private static boolean cleanUpWebApp(ResinModelBase resinModel, File webAppFile) {
        if (!webAppFile.isDirectory() && !resinModel.deleteFile(new File(webAppFile.getParent(), FileUtil.getNameWithoutExtension((String)webAppFile.getName())))) {
            return false;
        }
        return resinModel.deleteFile(webAppFile);
    }

    @Override
    public boolean undeployWithJmx(ResinModelBase resinModel, WebApp webApp) {
        File webAppFile = new File(FileUtil.toSystemDependentName((String)webApp.getLocation()));
        if (!webAppFile.exists()) {
            LOG.error("Can't find web app");
            return false;
        }
        if (!new UndeployCommand(resinModel, webAppFile).safeExecute()) {
            return false;
        }
        if (!Resin3XConfigurationStrategy.cleanUpWebApp(resinModel, webAppFile)) {
            return true;
        }
        GetStateCommand getStateCommand = new GetStateCommand(resinModel, webAppFile);
        if (!getStateCommand.safeExecute()) {
            return false;
        }
        return getStateCommand.getResult() == null;
    }

    private String getWebAppName(File webAppFile) {
        String fileName = webAppFile.getName();
        boolean trimExtension = !webAppFile.isDirectory() || this.myResinInstallation.getVersion().getParsed().compare(4, 0, 10) <= 0;
        return trimExtension ? FileUtil.getNameWithoutExtension((String)fileName) : fileName;
    }

    protected ElementsProvider createElementsProvider() {
        return new ElementsProvider(this.getElement());
    }

    protected final ElementsProvider getElementsProvider() {
        return (ElementsProvider)this.myElementsProvider.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/j2ee/web/resin/resin/configuration/Resin3XConfigurationStrategy", "getDeployStateWithJmx"));
    }

    protected static class ElementsProvider {
        private final Element myRootElement;
        private final Namespace myNS;
        private final NullableLazyValue<Element> myServer = new NullableLazyValue<Element>(){

            protected Element compute() {
                return this.getRootElement().getChild(Resin3XConfigurationStrategy.SERVER_ELEMENT, this.getNS());
            }
        };
        private final NotNullLazyValue<Element> myParamParent = new NotNullLazyValue<Element>(){

            @NotNull
            protected Element compute() {
                Element element = this.doGetParamParent();
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                return element;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/j2ee/web/resin/resin/configuration/Resin3XConfigurationStrategy$ElementsProvider$2", "compute"));
            }
        };

        public ElementsProvider(Element element) {
            this.myRootElement = element;
            this.myNS = this.myRootElement.getNamespace();
        }

        protected final Element getRootElement() {
            return this.myRootElement;
        }

        public Namespace getNS() {
            return this.myNS;
        }

        private Element getOrCreateServerElement() {
            return this.getOrCreateChildElement(this.getRootElement(), Resin3XConfigurationStrategy.SERVER_ELEMENT);
        }

        public Element getHostParent() {
            return this.getOrCreateServerElement();
        }

        protected Element doGetParamParent() {
            return this.getOrCreateServerElement();
        }

        public Element getOrCreateChildElement(Element parentElement, @NonNls String childName) {
            Element result = parentElement.getChild(childName, this.getNS());
            if (result == null) {
                result = new Element(childName, this.getNS());
                parentElement.addContent(result);
            }
            return result;
        }

        @Nullable
        public Element getServerElement() {
            return (Element)this.myServer.getValue();
        }

        @NotNull
        public Element getParamParentElement() {
            Element element = (Element)this.myParamParent.getValue();
            if (element == null) {
                ElementsProvider.$$$reportNull$$$0(0);
            }
            return element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/j2ee/web/resin/resin/configuration/Resin3XConfigurationStrategy$ElementsProvider", "getParamParentElement"));
        }
    }

    private class UndeployCommand
    extends WebAppCommandBase<Boolean> {
        UndeployCommand(ResinModelBase resinModel, File webAppFile) {
            super(resinModel, webAppFile);
        }

        @Override
        @Nullable
        protected Boolean doExecute(MBeanServerConnection connection, ObjectName objectName) throws JMException, IOException {
            return (Boolean)UndeployCommand.invokeOperation((MBeanServerConnection)connection, (ObjectName)objectName, (String)"destroy", (Object[])new Object[0]);
        }
    }

    private class GetStateCommand
    extends WebAppCommandBase<String> {
        GetStateCommand(ResinModelBase resinModel, File webAppFile) {
            super(resinModel, webAppFile);
        }

        @Override
        @Nullable
        protected String doExecute(MBeanServerConnection connection, ObjectName objectName) throws JMException, IOException {
            try {
                return (String)connection.getAttribute(objectName, Resin3XConfigurationStrategy.STATE_JMX_ATTRIBUTE);
            }
            catch (InstanceNotFoundException e) {
                return null;
            }
        }
    }

    private abstract class WebAppCommandBase<T>
    extends ConnectorCommandBase<T> {
        private final ObjectName myObjectName;

        WebAppCommandBase(ResinModelBase resinModel, File webAppFile) {
            super(resinModel);
            this.myObjectName = MBeanUtil.newObjectName(Resin3XConfigurationStrategy.MBEAN_WEB_APP_PREFIX + Resin3XConfigurationStrategy.this.getWebAppName(webAppFile));
        }

        @Nullable
        protected T doExecute(MBeanServerConnection connection) throws JMException, IOException {
            return this.doExecute(connection, this.myObjectName);
        }

        @Nullable
        protected abstract T doExecute(MBeanServerConnection var1, ObjectName var2) throws JMException, IOException;
    }

    private static class DeployCommand
    extends ConnectorCommandBase<Object> {
        private final String myCommand;
        private final String myArg;

        DeployCommand(ResinModelBase resinModel, @NonNls String command, @NonNls String arg) {
            super(resinModel);
            this.myCommand = command;
            this.myArg = arg;
        }

        protected Object doExecute(MBeanServerConnection connection) throws JMException, IOException {
            return DeployCommand.invokeOperation((MBeanServerConnection)connection, (ObjectName)MBEAN_WEB_APP_DEPLOY, (String)this.myCommand, (Object[])new Object[]{this.myArg});
        }
    }
}

