/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin.configuration;

import java.io.InputStream;
import java.util.List;
import org.intellij.j2ee.web.resin.resin.WebApp;
import org.intellij.j2ee.web.resin.resin.configuration.ResinConfigurationStrategy;
import org.jdom.Content;
import org.jdom.Element;

class Resin2XConfigurationStrategy
extends ResinConfigurationStrategy {
    private static final String HTTP_SERVER = "http-server";
    private static final String HTTP = "http";
    private static final String PORT = "port";
    private static final String APP_DIR = "app-dir";
    private static final String DIRTY = "dirty";
    private static final String WEB_APP = "web-app";
    private static final String ID = "id";
    private static final String HOST = "host";
    private static final String RESIN_CONF = "resin2.conf";
    private static final String CHARSET = "character-encoding";

    Resin2XConfigurationStrategy() {
    }

    @Override
    public void setPort(int port) {
        Element rootElement = this.getElement();
        Element httpElement = rootElement.getChild(HTTP_SERVER).getChild(HTTP);
        if (httpElement == null) {
            httpElement = new Element(HTTP);
            httpElement.setAttribute(PORT, Integer.toString(port));
            rootElement.getChild(HTTP_SERVER).addContent(httpElement);
        } else if (!httpElement.getAttribute(PORT).getValue().equals(Integer.toString(port))) {
            httpElement.setAttribute(PORT, Integer.toString(port));
        }
    }

    @Override
    public boolean deploy(WebApp webApp) {
        boolean dirty = false;
        Element host = Resin2XConfigurationStrategy.getHost(this.getElement().getChild(HTTP_SERVER), webApp);
        if (host.getAttribute(APP_DIR) != null) {
            host.removeAttribute(APP_DIR);
            dirty = true;
        }
        if (host.getAttribute(DIRTY) != null) {
            host.removeAttribute(DIRTY);
            dirty = true;
        }
        boolean webAppFound = false;
        List webpapps = host.getChildren(WEB_APP);
        if (webpapps != null) {
            for (Object webpapp : webpapps) {
                Element webappEl = (Element)webpapp;
                if (!webappEl.getAttribute(ID).getValue().equals(webApp.getContextPath())) continue;
                webAppFound = true;
                if (webappEl.getAttribute(APP_DIR) == null || !webappEl.getAttribute(APP_DIR).getValue().equals(webApp.getLocation())) {
                    webappEl.setAttribute(APP_DIR, webApp.getLocation());
                    dirty = true;
                }
                if (webappEl.getAttribute(CHARSET) != null && webappEl.getAttribute(CHARSET).getValue().equals(webApp.getCharSet()) || webApp.getCharSet() == null || webApp.getCharSet().trim().equals("")) continue;
                webappEl.setAttribute(CHARSET, webApp.getCharSet());
                dirty = true;
            }
        }
        if (!webAppFound) {
            dirty = true;
            Element newWebAppEl = new Element(WEB_APP);
            newWebAppEl.setAttribute(ID, webApp.getContextPath());
            newWebAppEl.setAttribute(APP_DIR, webApp.getLocation());
            if (webApp.getCharSet() != null && !webApp.getCharSet().trim().equals("")) {
                newWebAppEl.setAttribute(CHARSET, webApp.getCharSet());
            }
            host.addContent(newWebAppEl);
        }
        return dirty;
    }

    private static Element getHost(Element parent, WebApp webApp) {
        List hosts = parent.getChildren(HOST);
        if (hosts != null) {
            for (Object host1 : hosts) {
                Element host = (Element)host1;
                if (!host.getAttribute(ID).getValue().equals(webApp.getHost())) continue;
                return host;
            }
        }
        Element host = new Element(HOST);
        host.setAttribute(ID, webApp.getHost());
        host.setAttribute(DIRTY, "true");
        parent.addContent(host);
        return host;
    }

    @Override
    public boolean undeploy(WebApp webApp) {
        boolean dirty = false;
        List hosts = this.getElement().getChild(HTTP_SERVER).getChildren(HOST);
        if (hosts != null) {
            for (Object host1 : hosts) {
                Element host = (Element)host1;
                List webpapps = host.getChildren(WEB_APP);
                if (webpapps == null) continue;
                for (Object webpapp : webpapps.toArray()) {
                    Element webappEl = (Element)webpapp;
                    if (!webappEl.getAttribute(ID).getValue().equals(webApp.getContextPath())) continue;
                    host.removeContent((Content)webappEl);
                    dirty = true;
                }
            }
        }
        return dirty;
    }

    @Override
    public InputStream getDefaultResinConfContent() {
        return this.getClass().getResourceAsStream(RESIN_CONF);
    }
}

