/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.model.messaging;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.model.utils.AntPathMatcher;
import com.intellij.spring.model.utils.PlaceholderTextRanges;
import com.intellij.spring.websocket.model.messaging.SpringMessagingType;
import com.intellij.spring.websocket.model.messaging.UrlCollector;
import com.intellij.spring.websocket.model.messaging.UrlPointer;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMessagingModel {
    @NotNull
    private final NotNullLazyValue<MultiMap<SpringMessagingType, Variant>> myUrls;

    public SpringMessagingModel(@NotNull Module module, @Nullable PsiElement context) {
        if (module == null) {
            SpringMessagingModel.$$$reportNull$$$0(0);
        }
        boolean includeTests = context == null || ProjectRootsUtil.isInTestSource((PsiFile)context.getContainingFile());
        this.myUrls = new UrlCollector(module, includeTests);
    }

    @NotNull
    public Collection<? extends Variant> getAllUrls() {
        Collection collection = ((MultiMap)this.myUrls.getValue()).values();
        if (collection == null) {
            SpringMessagingModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<Variant> getUrls(SpringMessagingType ... types) {
        if (types == null) {
            SpringMessagingModel.$$$reportNull$$$0(2);
        }
        ArrayList<Variant> result = new ArrayList<Variant>();
        for (SpringMessagingType type : types) {
            result.addAll(((MultiMap)this.myUrls.getValue()).get((Object)type));
        }
        ArrayList<Variant> arrayList = result;
        if (arrayList == null) {
            SpringMessagingModel.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static String substitutePathVariables(String url) {
        Set ranges = PlaceholderTextRanges.getPlaceholderRanges((String)url, (String)"{", (String)"}");
        if (!ranges.isEmpty()) {
            if (ranges.size() > 1) {
                Iterator iterator = ranges.iterator();
                TextRange range = (TextRange)iterator.next();
                do {
                    TextRange next;
                    if ((next = (TextRange)iterator.next()).intersects(range)) {
                        return url;
                    }
                    range = next;
                } while (iterator.hasNext());
            }
            StringBuilder builder = new StringBuilder(url.length());
            int offset = 0;
            for (TextRange range : ranges) {
                builder.append(url, offset, range.getStartOffset() - 1);
                builder.append('*');
                offset = range.getEndOffset() + 1;
            }
            builder.append(url.substring(offset));
            url = builder.toString();
        }
        return url;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/websocket/model/messaging/SpringMessagingModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/websocket/model/messaging/SpringMessagingModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUrls";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Variant {
        @NotNull
        public final UrlPointer appPrefix;
        @Nullable
        public final UrlPointer classPrefix;
        @NotNull
        public final UrlPointer urlDefinition;
        public final String presentation;
        public final String lookupString;
        public final boolean isPattern;
        public final UrlPointer[] parts;

        public Variant(@NotNull UrlPointer appPrefix, @Nullable UrlPointer classPrefix, @NotNull UrlPointer urlDefinition) {
            if (appPrefix == null) {
                Variant.$$$reportNull$$$0(0);
            }
            if (urlDefinition == null) {
                Variant.$$$reportNull$$$0(1);
            }
            this.appPrefix = appPrefix;
            this.classPrefix = classPrefix;
            this.urlDefinition = urlDefinition;
            this.presentation = this.buildPresentation();
            this.lookupString = SpringMessagingModel.substitutePathVariables(this.presentation);
            this.isPattern = AntPathMatcher.isPattern((String)this.lookupString);
            this.parts = new UrlPointer[]{appPrefix, classPrefix, urlDefinition};
        }

        private String buildPresentation() {
            StringBuilder builder = new StringBuilder(this.appPrefix.getUrl()).append("/");
            if (this.classPrefix != null) {
                builder.append(this.classPrefix.getUrl());
            }
            builder.append(Variant.connectingSlashNeeded(builder)).append(this.urlDefinition.getUrl());
            return builder.toString();
        }

        private static String connectingSlashNeeded(StringBuilder builder) {
            return !builder.toString().endsWith("/") ? "/" : "";
        }

        public String toString() {
            return String.format("%s (%s)", this.presentation, this.lookupString);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "appPrefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "urlDefinition";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/websocket/model/messaging/SpringMessagingModel$Variant";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

