/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.runDebug.deployment;

import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicModel;
import com.intellij.javaee.weblogic.runDebug.deployment.WebLogicDeploymentMethod;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;

public class WeblogicDeploymentProvider
extends JavaeeDeploymentProvider {
    public static final WebLogicDeploymentMethod DEPLOYER = new WebLogicDeploymentMethod(WeblogicBundle.message("deployment.method.name.weblogic.deployer", new Object[0]), true, true){

        @Override
        public String createDeploymentName(DeploymentModel deployment, File source) {
            return JavaeeDeploymentProvider.getDefaultDeploymentNameWithMinuses((DeploymentModel)deployment);
        }
    };
    public static final WebLogicDeploymentMethod AUTODEPLOY = new WebLogicDeploymentMethod(WeblogicBundle.message("deployment.method.name.auto.deploy", new Object[0]), true, false){

        @Override
        public String createDeploymentName(DeploymentModel deployment, File source) {
            String name = JavaeeDeploymentProvider.getDefaultDeploymentNameWithMinuses((DeploymentModel)deployment);
            boolean hasArtifactExtension = ContainerUtil.or(Arrays.asList("war", "ear", "ejb"), artifactExtension -> FileUtilRt.extensionEquals((String)name, (String)artifactExtension));
            if (((WeblogicModel)deployment.getServerModel()).getParsedVersion().getMajor() >= 12) {
                return hasArtifactExtension ? FileUtil.getNameWithoutExtension((String)name) : name;
            }
            StringBuilder result = new StringBuilder();
            result.append("_appsdir_");
            result.append(name);
            if (!hasArtifactExtension) {
                result.append("_dir");
            } else {
                int index = result.lastIndexOf(".");
                if (index >= 0) {
                    result.setCharAt(index, '_');
                }
            }
            return result.toString();
        }
    };
    private static final DeploymentMethod[] ourDeploymentMethods = new DeploymentMethod[]{DEPLOYER, AUTODEPLOY};

    public WeblogicDeploymentProvider(boolean supportArchivesOnly) {
        super(supportArchivesOnly);
    }

    public String getHelpId() {
        return "webLogic.deployment";
    }

    public boolean isNeedUndeployOnDisconnect() {
        return true;
    }

    public DeploymentMethod[] getAvailableMethods() {
        return ourDeploymentMethods;
    }

    public boolean isDeployOrderMatter() {
        return true;
    }
}

