/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.runDebug.configuration;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.localRun.ColoredCommandLineExecutableObject;
import com.intellij.javaee.run.localRun.ColoredScriptExecutableObject;
import com.intellij.javaee.run.localRun.EnvironmentHelper;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.run.localRun.ScriptHelper;
import com.intellij.javaee.run.localRun.ScriptUtil;
import com.intellij.javaee.run.localRun.ScriptsHelper;
import com.intellij.javaee.weblogic.agent.WebLogicAgentUtil;
import com.intellij.javaee.weblogic.beaInstallation.BeaDomain;
import com.intellij.javaee.weblogic.beaInstallation.BeaServer;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersion;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WeblogicStartupPolicy
implements ExecutableObjectStartupPolicy {
    @NonNls
    private static final String JAVA_OPTIONS_VARIABLE = "JAVA_OPTIONS";

    public EnvironmentHelper getEnvironmentHelper() {
        return new EnvironmentHelper(){

            public String getDefaultJavaVmEnvVariableName(CommonModel model) {
                return WeblogicStartupPolicy.JAVA_OPTIONS_VARIABLE;
            }

            public List<EnvironmentVariable> getAdditionalEnvironmentVariables(CommonModel model) {
                WeblogicModel weblogicModel = (WeblogicModel)model.getServerModel();
                ArrayList<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>();
                if (weblogicModel.CONNECT_TO_MANAGED_SERVER) {
                    variables.add(new EnvironmentVariable(WeblogicStartupPolicy.JAVA_OPTIONS_VARIABLE, "-Dweblogic.management.username=" + weblogicModel.USERNAME + " -Dweblogic.management.password=" + weblogicModel.PASSWORD, true));
                }
                return variables;
            }
        };
    }

    private static String getAdminUrl(WeblogicModel weblogicModel) {
        return WebLogicAgentUtil.createAdminUrl(weblogicModel.getAdminServerHost(), weblogicModel.getAdminServerPort());
    }

    public ScriptHelper createStartupScriptHelper(ProgramRunner runner) {
        return new ScriptHelper(){

            public ExecutableObject getDefaultScript(CommonModel model) {
                WeblogicModel weblogicModel = (WeblogicModel)model.getServerModel();
                BeaDomain domain = weblogicModel.createDomain();
                File serverStartupScript = weblogicModel.CONNECT_TO_MANAGED_SERVER ? domain.getManagedServerStartupScript() : domain.getAdminServerStartupScript();
                String programParameters = null;
                if (weblogicModel.CONNECT_TO_MANAGED_SERVER) {
                    programParameters = weblogicModel.SERVER_NAME + " " + WeblogicStartupPolicy.getAdminUrl(weblogicModel);
                }
                return new ColoredCommandLineExecutableObject(new String[]{serverStartupScript.getAbsolutePath()}, programParameters);
            }
        };
    }

    public ScriptHelper createShutdownScriptHelper(ProgramRunner runner) {
        return new ScriptHelper(){

            public ExecutableObject getDefaultScript(CommonModel model) {
                WeblogicModel weblogicModel = (WeblogicModel)model.getServerModel();
                BeaDomain domain = weblogicModel.createDomain();
                File serverShutdownScript = weblogicModel.CONNECT_TO_MANAGED_SERVER ? domain.getManagedServerShutdownScript() : domain.getAdminServerShutdownScript();
                String userCredentials = weblogicModel.USERNAME + " " + weblogicModel.PASSWORD;
                if (!(serverShutdownScript == null || SystemInfo.isWindows && CommandLineUtil.hasWinShellSpecialChars((String)userCredentials))) {
                    String userCredentialsWithHiddenPassword = weblogicModel.USERNAME + " ***";
                    return WeblogicStartupPolicy.createExecutableObjectWithCustomDisplayString((ExecutableObject)WeblogicStartupPolicy.createShutdownScriptCommandLine(weblogicModel, serverShutdownScript, userCredentials), WeblogicStartupPolicy.createShutdownScriptCommandLine(weblogicModel, serverShutdownScript, userCredentialsWithHiddenPassword).getDisplayString());
                }
                WeblogicVersion version = weblogicModel.getChosenVersion();
                if (version == null) {
                    return null;
                }
                String javaHome = version.getJavaHome();
                if (javaHome == null) {
                    Sdk projectJdk = ProjectRootManager.getInstance((Project)model.getProject()).getProjectSdk();
                    if (projectJdk == null) {
                        return null;
                    }
                    String homePath = projectJdk.getHomePath();
                    if (homePath == null) {
                        return null;
                    }
                    javaHome = FileUtil.toSystemDependentName((String)homePath);
                }
                return WeblogicStartupPolicy.createExecutableObjectWithCustomDisplayString((ExecutableObject)WeblogicStartupPolicy.createShutdownScript(weblogicModel, version, javaHome, weblogicModel.PASSWORD), WeblogicStartupPolicy.createShutdownScript(weblogicModel, version, javaHome, "***").getDisplayString());
            }
        };
    }

    @NotNull
    private static ExecutableObject createExecutableObjectWithCustomDisplayString(final @NotNull ExecutableObject wrapped, final @NotNull String customDisplayString) {
        if (wrapped == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(0);
        }
        if (customDisplayString == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(1);
        }
        ExecutableObject executableObject = new ExecutableObject(){

            public String getDisplayString() {
                return customDisplayString;
            }

            public OSProcessHandler createProcessHandler(String workingDirectory, Map<String, String> envVariables) throws ExecutionException {
                return wrapped.createProcessHandler(workingDirectory, envVariables);
            }
        };
        if (executableObject == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(2);
        }
        return executableObject;
    }

    @NotNull
    private static ColoredCommandLineExecutableObject createShutdownScriptCommandLine(@NotNull WeblogicModel weblogicModel, @NotNull File serverShutdownScript, @NotNull String userCredentials) {
        if (weblogicModel == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(3);
        }
        if (serverShutdownScript == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(4);
        }
        if (userCredentials == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(5);
        }
        String adminUrl = WeblogicStartupPolicy.getAdminUrl(weblogicModel);
        String programParameters = weblogicModel.CONNECT_TO_MANAGED_SERVER ? weblogicModel.SERVER_NAME + " " + adminUrl + " " + userCredentials : userCredentials + " " + adminUrl;
        ColoredCommandLineExecutableObject coloredCommandLineExecutableObject = new ColoredCommandLineExecutableObject(new String[]{serverShutdownScript.getAbsolutePath()}, programParameters);
        if (coloredCommandLineExecutableObject == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(6);
        }
        return coloredCommandLineExecutableObject;
    }

    @NotNull
    private static ColoredScriptExecutableObject createShutdownScript(@NotNull WeblogicModel weblogicModel, @NotNull WeblogicVersion version, @NotNull String javaHome, @NotNull String password) {
        if (weblogicModel == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(7);
        }
        if (version == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(8);
        }
        if (javaHome == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(9);
        }
        if (password == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(10);
        }
        StringBuilder result = new StringBuilder();
        if (SystemInfo.isWindows) {
            result.append("@echo off\n");
            result.append("SETLOCAL\n");
        }
        String wlHome = version.getInstallDir();
        ScriptUtil.appendEnvVariableDeclaration((String)"WL_HOME", (String)("\"" + wlHome + "\""), (StringBuilder)result);
        ScriptUtil.appendEnvVariableDeclaration((String)"JAVA_HOME", (String)("\"" + javaHome + "\""), (StringBuilder)result);
        ScriptUtil.appendEnvVariableDeclaration((String)"CLASSPATH", (String)version.getJarFile().getPath(), (StringBuilder)result);
        ScriptUtil.appendEnvVariableReference((String)"JAVA_HOME", (StringBuilder)result);
        BeaServer server = weblogicModel.getAdminServerConfiguration();
        result.append(File.separatorChar);
        result.append("bin");
        result.append(File.separatorChar);
        result.append("java weblogic.Admin -url localhost:");
        result.append(server.getPort());
        result.append(" -username ");
        result.append(weblogicModel.USERNAME);
        result.append(" -password ");
        result.append(password);
        result.append(" FORCESHUTDOWN ");
        result.append(server.getName());
        result.append("\n");
        if (SystemInfo.isWindows) {
            result.append("ENDLOCAL");
        }
        ColoredScriptExecutableObject coloredScriptExecutableObject = new ColoredScriptExecutableObject(result.toString(), "shutdown.");
        if (coloredScriptExecutableObject == null) {
            WeblogicStartupPolicy.$$$reportNull$$$0(11);
        }
        return coloredScriptExecutableObject;
    }

    public ScriptsHelper getStartupHelper() {
        return null;
    }

    public ScriptsHelper getShutdownHelper() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapped";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customDisplayString";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/weblogic/runDebug/configuration/WeblogicStartupPolicy";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weblogicModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverShutdownScript";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userCredentials";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaHome";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/weblogic/runDebug/configuration/WeblogicStartupPolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutableObjectWithCustomDisplayString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createShutdownScriptCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createShutdownScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExecutableObjectWithCustomDisplayString";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createShutdownScriptCommandLine";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createShutdownScript";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

