/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.editors;

import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.enums.Multiplicity;
import com.intellij.javaee.model.xml.ejb.EjbRelation;
import com.intellij.javaee.model.xml.ejb.EjbRelationshipRole;
import com.intellij.javaee.ui.ComplexElementWrapper;
import com.intellij.javaee.ui.DialogCommittableTab;
import com.intellij.javaee.ui.DialogElementWrapper;
import com.intellij.javaee.weblogic.editors.ManyToManyColumnsMappingConfigurable;
import com.intellij.javaee.weblogic.editors.RdbmsHelper;
import com.intellij.javaee.weblogic.editors.TableColumnsMappingConfigurable;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsJar;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsRelation;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRelationshipRole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ui.CommittablePanel;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EjbRelationshipCommittablePanel
extends DialogCommittableTab<WeblogicRdbmsRelation> {
    private final EjbRelation myEjbRelation;
    @NotNull
    private CommittablePanel myDelegate = new CommittablePanel(){

        public JComponent getComponent() {
            return null;
        }

        public void commit() {
        }

        public void reset() {
        }

        public void dispose() {
        }
    };
    private final JPanel myPanel = new JPanel(new BorderLayout());

    public EjbRelationshipCommittablePanel(String name, final WeblogicRdbmsJar root, final EjbRelation ejbRelation) {
        super(name, (DialogElementWrapper)new ComplexElementWrapper<WeblogicRdbmsRelation>(root.getManager().getProject(), (WeblogicRdbmsRelation)ContainerUtil.find(root.getWeblogicRdbmsRelations(), object -> Comparing.equal((String)((String)ejbRelation.getEjbRelationName().getValue()), (String)((String)object.getRelationName().getValue()))), WeblogicRdbmsRelation.class, (JavaeeFacet)EjbModuleUtil.getEjbFacet((JavaeeModelElement)root)){

            protected void initMockElement(WeblogicRdbmsRelation relation) {
                relation.getRelationName().setValue(ejbRelation.getEjbRelationName().getValue());
            }

            protected WeblogicRdbmsRelation createRealElement() {
                return root.addWeblogicRdbmsRelation();
            }
        });
        this.myEjbRelation = ejbRelation;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void commit() {
        this.myDelegate.commit();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDelegate);
    }

    private CommittablePanel createCurrentPage() {
        EjbRelationshipRole firstRole = this.myEjbRelation.getEjbRelationshipRole1();
        EjbRelationshipRole secondRole = this.myEjbRelation.getEjbRelationshipRole2();
        WeblogicRdbmsRelation weblogicRdbmsRelation = (WeblogicRdbmsRelation)this.getDomElement();
        if (firstRole.getMultiplicity().getValue() == Multiplicity.MANY && secondRole.getMultiplicity().getValue() == Multiplicity.MANY) {
            if (this.myDelegate instanceof ManyToManyColumnsMappingConfigurable) {
                return this.myDelegate;
            }
            return new ManyToManyColumnsMappingConfigurable(weblogicRdbmsRelation, this.myEjbRelation);
        }
        if (this.myDelegate instanceof TableColumnsMappingConfigurable) {
            return this.myDelegate;
        }
        EjbRelationshipRole role = secondRole.getMultiplicity().getValue() == Multiplicity.MANY ? firstRole : secondRole;
        WeblogicRelationshipRole weblogicRole = EjbRelationshipCommittablePanel.ensureWeblogicRole(0, weblogicRdbmsRelation, role);
        return new TableColumnsMappingConfigurable(new RdbmsHelper(weblogicRdbmsRelation, weblogicRole, this.myEjbRelation, role), true);
    }

    static WeblogicRelationshipRole ensureWeblogicRole(int index, WeblogicRdbmsRelation weblogicRdbmsRelation, EjbRelationshipRole role) {
        WriteCommandAction.writeCommandAction((Project)role.getManager().getProject()).run(() -> {
            List<WeblogicRelationshipRole> roles = weblogicRdbmsRelation.getWeblogicRelationshipRoles();
            WeblogicRelationshipRole weblogicRole = roles.size() < index + 1 ? weblogicRdbmsRelation.addWeblogicRelationshipRole() : roles.get(index);
            weblogicRole.getRelationshipRoleName().setValue(role.getEjbRelationshipRoleName().getValue());
        });
        return (WeblogicRelationshipRole)weblogicRdbmsRelation.getWeblogicRelationshipRoles().get(index).createStableCopy();
    }

    public void reset() {
        Disposer.dispose((Disposable)this.myDelegate);
        this.myDelegate = this.createCurrentPage();
        this.myDelegate.reset();
        this.myPanel.removeAll();
        this.myPanel.add(this.myDelegate.getComponent());
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }
}

