/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.beaInstallation;

import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersion;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersionList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.JDOMException;

public abstract class WeblogicInstallationBase {
    private static final Logger LOG = Logger.getInstance(WeblogicInstallationBase.class);
    private final String myHome;
    private final File myStampFile;

    protected WeblogicInstallationBase(String home, String stampFilePath) {
        this.myHome = home;
        this.myStampFile = new File(home, stampFilePath);
    }

    public String getHome() {
        return this.myHome;
    }

    public File getStampFile() {
        return this.myStampFile;
    }

    public boolean isValid() {
        return this.getStampFile().isFile();
    }

    public WeblogicVersionList getVersions() {
        ArrayList<WeblogicVersion> versions = new ArrayList();
        try {
            versions = this.doGetVersions();
        }
        catch (JDOMException e) {
            LOG.info((Throwable)e);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return new WeblogicVersionList(versions);
    }

    protected String getDefaultServerHome() {
        return FileUtil.toSystemDependentName((String)(this.getHome() + "/wlserver"));
    }

    protected abstract List<WeblogicVersion> doGetVersions() throws JDOMException, IOException;
}

