/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.support;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.drools.lang.psi.DroolsIdentifier;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.refactoring.rename.BeanPropertyRenameHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DroolsPropertyRenameHandler
extends BeanPropertyRenameHandler {
    protected BeanProperty getProperty(DataContext dataContext) {
        Project project;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null && editor != null && ApplicationManager.getApplication().isUnitTestMode() && (project = editor.getProject()) != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (editor != null && file != null) {
            return DroolsPropertyRenameHandler.getBeanProperty(editor, file);
        }
        return null;
    }

    @Nullable
    private static BeanProperty getBeanProperty(@NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        PsiReference reference;
        if (editor == null) {
            DroolsPropertyRenameHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DroolsPropertyRenameHandler.$$$reportNull$$$0(1);
        }
        if ((reference = file.findReferenceAt(offset = editor.getCaretModel().getOffset())) instanceof DroolsIdentifier) {
            PsiElement psiElement = reference.resolve();
            return DroolsPropertyRenameHandler.getBeanProperty(psiElement);
        }
        return null;
    }

    @Nullable
    public static BeanProperty getBeanProperty(PsiElement psiElement) {
        PsiMethod method;
        if (psiElement instanceof BeanPropertyElement && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)(method = ((BeanPropertyElement)psiElement).getMethod()))) {
            return BeanProperty.createBeanProperty((PsiMethod)method);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/plugins/drools/lang/support/DroolsPropertyRenameHandler";
        objectArray[2] = "getBeanProperty";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

