/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import java.io.IOException;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

public abstract class LineOutputWriter
extends Writer {
    private final LineParser myLineParser = new LineParser();

    @Override
    public void write(int c) {
        this.processData(new CharSequenceIterator(c));
    }

    @Override
    public void write(char[] cbuf) {
        this.processData(new CharSequenceIterator(cbuf));
    }

    @Override
    public void write(String str) {
        this.processData(new CharSequenceIterator(str));
    }

    @Override
    public void write(String str, int off, int len) {
        this.processData(new CharSequenceIterator(str.subSequence(off, off + len)));
    }

    @Override
    public Writer append(CharSequence csq) {
        this.processData(new CharSequenceIterator(csq));
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) {
        this.processData(new CharSequenceIterator(csq.subSequence(start, end)));
        return this;
    }

    @Override
    public Writer append(char c) {
        this.processData(new CharSequenceIterator(c));
        return this;
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.processData(new CharSequenceIterator(cbuf, off, len));
    }

    private void processData(CharIterator data) {
        while (this.myLineParser.parse(data)) {
            String line = this.myLineParser.getResult();
            this.myLineParser.reset();
            this.lineAvailable(line);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.myLineParser.hasData()) {
                this.lineAvailable(this.myLineParser.getResult());
            }
        }
        finally {
            this.myLineParser.reset();
        }
    }

    protected abstract void lineAvailable(String var1);

    private static final class SingleCharSequence
    implements CharSequence {
        private final char myCh;

        SingleCharSequence(char ch) {
            this.myCh = ch;
        }

        @Override
        public int length() {
            return 1;
        }

        @Override
        public char charAt(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + index);
            }
            return this.myCh;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new RuntimeException("Method subSequence not implemented");
        }

        @Override
        public String toString() {
            return String.valueOf(this.myCh);
        }
    }

    private static class CharArrayCharSequence
    implements CharSequence {
        protected final char[] myChars;
        protected final int myStart;
        protected final int myEnd;

        CharArrayCharSequence(@NotNull char[] chars, int start, int end) {
            if (chars == null) {
                CharArrayCharSequence.$$$reportNull$$$0(0);
            }
            if (start < 0 || end > chars.length || start > end) {
                throw new IndexOutOfBoundsException("chars.length:" + chars.length + ", start:" + start + ", end:" + end);
            }
            this.myChars = chars;
            this.myStart = start;
            this.myEnd = end;
        }

        @Override
        public final int length() {
            return this.myEnd - this.myStart;
        }

        @Override
        public final char charAt(int index) {
            return this.myChars[index + this.myStart];
        }

        @Override
        @NotNull
        public CharSequence subSequence(int start, int end) {
            CharArrayCharSequence charArrayCharSequence = start == 0 && end == this.length() ? this : new CharArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
            if (charArrayCharSequence == null) {
                CharArrayCharSequence.$$$reportNull$$$0(1);
            }
            return charArrayCharSequence;
        }

        @Override
        @NotNull
        public String toString() {
            String string = new String(this.myChars, this.myStart, this.myEnd - this.myStart);
            if (string == null) {
                CharArrayCharSequence.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chars";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/incremental/LineOutputWriter$CharArrayCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/incremental/LineOutputWriter$CharArrayCharSequence";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subSequence";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CharSequenceIterator
    implements CharIterator {
        private final CharSequence myChars;
        private int myCursor = 0;

        CharSequenceIterator(int ch) {
            this((char)ch);
        }

        CharSequenceIterator(char ch) {
            this(new SingleCharSequence(ch));
        }

        CharSequenceIterator(char[] chars) {
            this(chars, 0, chars.length);
        }

        CharSequenceIterator(char[] chars, int offset, int length) {
            this(new CharArrayCharSequence(chars, offset, offset + length));
        }

        CharSequenceIterator(CharSequence sequence) {
            this.myChars = sequence;
        }

        @Override
        public char nextChar() {
            return this.myChars.charAt(this.myCursor++);
        }

        @Override
        public boolean hasData() {
            return this.myCursor < this.myChars.length();
        }
    }

    private static class LineParser {
        private final StringBuilder myData = new StringBuilder();
        private boolean myFoundCR = false;

        private LineParser() {
        }

        public boolean parse(CharIterator it) {
            while (it.hasData()) {
                char ch = it.nextChar();
                if (ch == '\r') {
                    this.myFoundCR = true;
                    continue;
                }
                if (ch == '\n') {
                    this.myFoundCR = false;
                    return true;
                }
                if (this.myFoundCR) {
                    this.myData.append('\r');
                    this.myFoundCR = false;
                }
                this.myData.append(ch);
            }
            return false;
        }

        public boolean hasData() {
            return this.myData.length() > 0;
        }

        public String getResult() {
            return this.myData.toString();
        }

        public void reset() {
            this.myFoundCR = false;
            this.myData.setLength(0);
        }
    }

    private static interface CharIterator {
        public char nextChar();

        public boolean hasData();
    }
}

