/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml.actions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.ui.JSEditorTextField;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.lang.javascript.refactoring.ui.JSVisibilityPanel;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCreateFieldDialog
extends DialogWrapper {
    private JSReferenceEditor myTypeField;
    private JLabel myTypeLabel;
    private EditorTextField myNameField;
    private JCheckBox myDeclareStaticCb;
    private JPanel myContentPane;
    private JSVisibilityPanel myVisibilityPanel;
    private JLabel myNameLabel;
    private EditorTextField myInitializerField;
    private JLabel myInitializerLabel;
    private JCheckBox myDeclareConstantCb;
    private final JSClass myTargetClass;
    private static boolean ourDeclareConstant;
    private static boolean ourDeclareStatic;

    public JSCreateFieldDialog(JSClass clazz) {
        super(clazz.getProject(), true);
        this.myTargetClass = clazz;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(JSBundle.message((String)"create.field.dialog.title", (Object[])objectArray));
        this.myVisibilityPanel.configureForClassMember(false, false, DialectDetector.dialectOfElement((PsiElement)clazz));
        this.myVisibilityPanel.setVisibility(JSAttributeList.AccessType.PRIVATE.name());
        this.myTypeLabel.setLabelFor(this.myTypeField.getChildComponent());
        this.myNameLabel.setLabelFor((Component)this.myNameField);
        this.myInitializerLabel.setLabelFor((Component)this.myInitializerField);
        this.myDeclareConstantCb.setSelected(ourDeclareConstant);
        this.myDeclareStaticCb.setSelected(ourDeclareStatic);
        this.init();
    }

    private void createUIComponents() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myTargetClass);
        GlobalSearchScope scope = JSCreateFieldDialog.getTypeFieldScope(module, this.myTargetClass.getProject());
        this.myTypeField = JSCreateFieldDialog.createTypeField(this.myTargetClass.getProject(), scope);
        JSExpressionCodeFragment initializerCodeFragment = JSCreateFieldDialog.createInitializerCodeFragment(this.myTargetClass);
        Document document = PsiDocumentManager.getInstance((Project)this.myTargetClass.getProject()).getDocument((PsiFile)initializerCodeFragment);
        this.myInitializerField = new JSEditorTextField(this.myTargetClass.getProject(), document);
    }

    public static GlobalSearchScope getTypeFieldScope(@Nullable Module module, @NotNull Project project) {
        if (project == null) {
            JSCreateFieldDialog.$$$reportNull$$$0(0);
        }
        return module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)project);
    }

    public static JSReferenceEditor createTypeField(Project project, GlobalSearchScope scope) {
        return JSReferenceEditor.forClassName((String)"", (Project)project, (String)"JSCreateFieldDialog", (GlobalSearchScope)scope, (JavaScriptParserBase.ForceContext)JavaScriptParserBase.ForceContext.Type, null, (String)JSBundle.message((String)"choose.field.type", (Object[])new Object[0]));
    }

    public static JSExpressionCodeFragment createInitializerCodeFragment(JSClass c) {
        return JSElementFactory.createExpressionCodeFragment((Project)c.getProject(), (CharSequence)"", (PsiElement)c, (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4, (GlobalSearchScope)c.getResolveScope(), (JSElementFactory.TopLevelCompletion)JSElementFactory.TopLevelCompletion.LITERAL_VALUES, null);
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTypeField.getChildComponent();
    }

    public String getFieldName() {
        return this.myNameField.getText();
    }

    public String getFieldType() {
        return this.myTypeField.getText();
    }

    public boolean isStatic() {
        return this.myDeclareStaticCb.isSelected();
    }

    public String getVisibility() {
        return this.myVisibilityPanel.getVisibility();
    }

    @Nullable
    private Pair<String, Boolean> validateData() {
        if (!JSRefactoringUtil.isValidIdentifier((String)this.getFieldName(), (Project)this.myTargetClass.getProject())) {
            return Pair.create((Object)JSBundle.message((String)"invalid.identifier.value.0", (Object[])new Object[]{this.getFieldName()}), (Object)true);
        }
        String type = this.getFieldType().trim();
        if ("void".equals(type) || type.contains(" ") || JSRefactoringUtil.createTypeElement((String)type, (PsiElement)this.myTargetClass) == null) {
            return Pair.create((Object)JSBundle.message((String)"invalid.field.type.expression", (Object[])new Object[]{type}), (Object)true);
        }
        if (this.isConstant() && StringUtil.isEmpty((String)this.getInitializer())) {
            return Pair.create((Object)JSBundle.message((String)"field.initializer.is.not.specified", (Object[])new Object[0]), (Object)true);
        }
        if (!JSRefactoringUtil.isResolvableType((String)type, (PsiElement)this.myTargetClass, (boolean)false, (boolean)false)) {
            return Pair.create((Object)JSBundle.message((String)"type.is.not.resolved", (Object[])new Object[]{type}), (Object)false);
        }
        if (this.myTargetClass.findFieldByName(this.getFieldName()) != null) {
            return Pair.create((Object)JSBundle.message((String)"class.already.contains.field.warning", (Object[])new Object[]{this.myTargetClass.getQualifiedName(), this.getFieldName()}), (Object)false);
        }
        return null;
    }

    public boolean isConstant() {
        return this.myDeclareConstantCb.isSelected();
    }

    public String getInitializer() {
        return this.myInitializerField.getText();
    }

    protected String getDimensionServiceKey() {
        return "JSCreateFieldDialog";
    }

    protected void doOKAction() {
        Pair<String, Boolean> errorStatus = this.validateData();
        if (errorStatus != null) {
            if (((Boolean)errorStatus.second).booleanValue()) {
                Messages.showErrorDialog((Component)this.myContentPane, (String)((String)errorStatus.first), (String)this.getTitle());
                return;
            }
            if (Messages.showYesNoDialog((Component)this.myContentPane, (String)((String)errorStatus.first), (String)this.getTitle(), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
        }
        this.myTypeField.updateRecents();
        ourDeclareConstant = this.myDeclareConstantCb.isSelected();
        ourDeclareStatic = this.myDeclareStaticCb.isSelected();
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/uml/actions/JSCreateFieldDialog", "getTypeFieldScope"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JSVisibilityPanel jSVisibilityPanel;
        EditorTextField editorTextField;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNameLabel = jLabel3 = new JLabel();
        jLabel3.setText("Name:");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Type:");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSReferenceEditor jSReferenceEditor = this.myTypeField;
        jPanel.add((Component)jSReferenceEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, new Dimension(300, -1), null, null));
        this.myNameField = editorTextField = new EditorTextField();
        jPanel.add((Component)editorTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 2, null, null, null));
        this.myVisibilityPanel = jSVisibilityPanel = new JSVisibilityPanel();
        JComponent jComponent = jSVisibilityPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeclareStaticCb = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Declare static");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myInitializerLabel = jLabel = new JLabel();
        jLabel.setText("Initializer:");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myInitializerField;
        jPanel.add((Component)editorTextField2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 2, null, null, null));
        this.myDeclareConstantCb = jCheckBox = new JCheckBox();
        jCheckBox.setText("Declare constant");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

