/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml;

import com.intellij.diagram.ChangeTracker;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSTargetedInjector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.uml.FlashUmlElementManager;
import com.intellij.lang.javascript.uml.FlashUmlVfsResolver;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.PsiChangeTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashUmlChangeTracker
extends ChangeTracker<JSClass, JSNamedElement, JSReferenceExpression> {
    private static final PsiFilter<JSClass> CLASS_FILTER = new PsiFilter<JSClass>(JSClass.class){

        public boolean accept(JSClass element) {
            return element instanceof XmlBackedJSClassImpl || element.getParent() instanceof JSPackageStatement;
        }

        public boolean areEquivalent(JSClass e1, JSClass e2) {
            if (e1 instanceof XmlBackedJSClassImpl && e2 instanceof XmlBackedJSClassImpl) {
                return e1.getQualifiedName().equals(e2.getQualifiedName());
            }
            return super.areEquivalent((PsiElement)e1, (PsiElement)e2);
        }
    };
    private static final PsiFilter<JSFunction> SIMPLE_METHOD_FILTER = new MethodFilter(JSFunction.FunctionKind.SIMPLE);
    private static final PsiFilter<JSFunction> CONSTRUCTOR_FILTER = new MethodFilter(JSFunction.FunctionKind.CONSTRUCTOR);
    private static final PsiFilter<JSFunction> GETTER_FILTER = new MethodFilter(JSFunction.FunctionKind.GETTER);
    private static final PsiFilter<JSFunction> SETTER_FILTER = new MethodFilter(JSFunction.FunctionKind.SETTER);
    private static final PsiFilter<JSVariable> FIELD_FILTER = new NameFilter<JSVariable>(JSVariable.class){

        public boolean accept(JSVariable element) {
            return JSUtils.getMemberContainingClass((PsiElement)element) != null;
        }

        public PsiFilter.Visitor<JSVariable> createVisitor(List<JSVariable> elements) {
            return new InjectingVisitor<JSVariable>(this, elements);
        }
    };
    private static final PsiFilter<JSReferenceExpression> EXTENDS_FILTER = new ReferenceListFilter(true);
    private static final PsiFilter<JSReferenceExpression> IMPLEMENTS_FILTER = new ReferenceListFilter(false);
    private Map<JSClass, FileStatus> myNodeElements;

    public FlashUmlChangeTracker(Project project, @Nullable PsiFile before, @Nullable PsiFile after) {
        super(project, before, after);
    }

    public PsiFilter<JSClass>[] getNodeFilters() {
        return new PsiFilter[]{CLASS_FILTER};
    }

    public PsiFilter<JSNamedElement>[] getNodeContentFilters() {
        return new PsiFilter[]{SIMPLE_METHOD_FILTER, CONSTRUCTOR_FILTER, FIELD_FILTER, GETTER_FILTER, SETTER_FILTER};
    }

    public PsiFilter<JSReferenceExpression>[] getRelationshipFilters() {
        return new PsiFilter[]{EXTENDS_FILTER, IMPLEMENTS_FILTER};
    }

    public String getPresentableName(PsiNamedElement e) {
        if (e instanceof JSVariable) {
            return FlashUmlElementManager.getFieldText((JSVariable)e);
        }
        if (e instanceof JSFunction) {
            return FlashUmlElementManager.getMethodText((JSFunction)e);
        }
        return super.getPresentableName(e);
    }

    public String getType(JSNamedElement jsNamedElement) {
        return FlashUmlElementManager.getPresentableTypeStatic(jsNamedElement);
    }

    public Icon getIcon(PsiNamedElement e) {
        return FlashUmlElementManager.getNodeElementIconStatic(e);
    }

    public String getQualifiedName(JSClass e, VirtualFile containingFile) {
        return e.getQualifiedName();
    }

    public Map<JSClass, FileStatus> getNodeElements() {
        if (this.myNodeElements == null) {
            this.myNodeElements = new HashMap<JSClass, FileStatus>();
            Pair<PsiElement, PsiElement> beforeAndAfter = this.adjustBeforeAfter();
            for (PsiFilter<JSClass> filter : this.getNodeFilters()) {
                this.myNodeElements.putAll(PsiChangeTracker.getElementsChanged((PsiElement)((PsiElement)beforeAndAfter.second), (PsiElement)((PsiElement)beforeAndAfter.first), filter));
            }
        }
        return this.myNodeElements;
    }

    private Pair<PsiElement, PsiElement> adjustBeforeAfter() {
        PsiFile before = this.getBefore();
        PsiFile after = this.getAfter();
        if (after != null && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)after) && before == null) {
            after = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)this.getAfter()));
        } else if (before != null && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)before) && after == null) {
            before = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)this.getBefore()));
        } else if (before != null && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)before) && after != null && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)after)) {
            before = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)before));
            after = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)after));
        }
        return Pair.create((Object)before, (Object)after);
    }

    public ChangeTracker.RelationshipInfo[] getRelationships() {
        ArrayList<ChangeTracker.RelationshipInfo> result = new ArrayList<ChangeTracker.RelationshipInfo>();
        Pair<PsiElement, PsiElement> beforeAndAfter = this.adjustBeforeAfter();
        for (PsiFilter<JSReferenceExpression> filter : this.getRelationshipFilters()) {
            Map map = PsiChangeTracker.getElementsChanged((PsiElement)((PsiElement)beforeAndAfter.second), (PsiElement)((PsiElement)beforeAndAfter.first), filter);
            for (JSReferenceExpression expression : map.keySet()) {
                JSClass sourceClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)expression, JSClass.class);
                if (sourceClass == null) continue;
                if (InjectedLanguageManager.getInstance((Project)sourceClass.getProject()).getInjectionHost((PsiElement)sourceClass) != null) {
                    sourceClass = JSResolveUtil.getXmlBackedClass((JSFile)((JSFile)sourceClass.getContainingFile()));
                }
                JSReferenceList refList = (JSReferenceList)PsiTreeUtil.getParentOfType((PsiElement)expression, JSReferenceList.class);
                assert (refList != null);
                JSExpression[] references = refList.getExpressions();
                JSClass[] referencedClasses = refList.getReferencedClasses();
                JSClass targetClass = null;
                for (int i = 0; i < references.length; ++i) {
                    if (references[i] != expression) continue;
                    targetClass = i < referencedClasses.length ? referencedClasses[i] : null;
                    break;
                }
                if (targetClass == null) continue;
                ChangeTracker.EdgeType edgeType = filter == IMPLEMENTS_FILTER ? ChangeTracker.EdgeType.IMPLEMENTS : ChangeTracker.EdgeType.EXTENDS;
                result.add(new ChangeTracker.RelationshipInfo(sourceClass.getQualifiedName(), targetClass.getQualifiedName(), edgeType, (FileStatus)map.get(expression)));
            }
        }
        return result.toArray(ChangeTracker.RelationshipInfo.EMPTY);
    }

    public PsiNamedElement findElementByFQN(Project project, String fqn) {
        Object o = FlashUmlVfsResolver.resolveElementByFqnStatic(fqn, project);
        return o instanceof JSClass ? (PsiNamedElement)o : null;
    }

    private static class InjectingVisitor<T extends PsiElement>
    extends PsiFilter.Visitor<T> {
        InjectingVisitor(PsiFilter<T> filter, List<T> elements) {
            super(filter, elements);
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            if (element instanceof XmlText || element instanceof XmlAttributeValue) {
                XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
                for (MultiHostInjector injector : (MultiHostInjector[])MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getExtensions((AreaInstance)element.getProject())) {
                    if (!(injector instanceof JSTargetedInjector)) continue;
                    injector.getLanguagesToInject((MultiHostRegistrar)new XmlBackedJSClassImpl.InjectedScriptsVisitor.MyRegistrar(parentTag, (XmlBackedJSClass.InjectedFileVisitor)new JSResolveUtil.JSInjectedFilesVisitor(){

                        protected void process(JSFile file) {
                            file.acceptChildren((PsiElementVisitor)this);
                        }
                    }), element);
                }
            }
        }
    }

    private static class ReferenceListFilter
    extends PsiFilter<JSReferenceExpression> {
        private final boolean myExtends;

        ReferenceListFilter(boolean isExtends) {
            super(JSReferenceExpression.class);
            this.myExtends = isExtends;
        }

        public boolean accept(JSReferenceExpression element) {
            PsiElement parent = element.getParent();
            return parent instanceof JSReferenceListMember && parent.getParent().getNode().findChildByType(this.myExtends ? JSTokenTypes.EXTENDS_KEYWORD : JSTokenTypes.IMPLEMENTS_KEYWORD) != null;
        }

        public PsiFilter.Visitor<JSReferenceExpression> createVisitor(List<JSReferenceExpression> elements) {
            return new InjectingVisitor<JSReferenceExpression>(this, elements);
        }
    }

    private static class MethodFilter
    extends NameFilter<JSFunction> {
        private final JSFunction.FunctionKind myKind;

        private MethodFilter(JSFunction.FunctionKind kind) {
            super(JSFunction.class);
            this.myKind = kind;
        }

        public boolean accept(JSFunction element) {
            return JSUtils.getMemberContainingClass((PsiElement)element) != null && element.getKind() == this.myKind;
        }

        public PsiFilter.Visitor<JSFunction> createVisitor(List<JSFunction> elements) {
            return new InjectingVisitor<JSFunction>(this, elements);
        }
    }

    private static class NameFilter<T extends PsiNamedElement>
    extends PsiFilter<T> {
        private NameFilter(@NotNull Class<T> filter) {
            if (filter == null) {
                NameFilter.$$$reportNull$$$0(0);
            }
            super(filter);
        }

        public boolean areEquivalent(T e1, T e2) {
            return Comparing.equal((String)e1.getName(), (String)e2.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/javascript/uml/FlashUmlChangeTracker$NameFilter", "<init>"));
        }
    }
}

