/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.actionscript.JSFieldCanBeLocalInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToLocalFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(JSFieldCanBeLocalInspection.class);
    private final JSVariable myField;
    private final Map<JSFunction, Collection<PsiReference>> myFunctionToReferences;

    public ConvertToLocalFix(JSVariable field, Map<JSFunction, Collection<PsiReference>> functionToReferences) {
        this.myField = field;
        this.myFunctionToReferences = functionToReferences;
    }

    @NotNull
    public String getFamilyName() {
        String string = FlexBundle.message("js.convert.to.local.quick.fix", new Object[0]);
        if (string == null) {
            ConvertToLocalFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            ConvertToLocalFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            ConvertToLocalFix.$$$reportNull$$$0(2);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myField)) {
            return;
        }
        for (Map.Entry<JSFunction, Collection<PsiReference>> entry : this.myFunctionToReferences.entrySet()) {
            if (this.applyFixForFunction(entry.getValue())) continue;
            return;
        }
        this.deleteField();
    }

    private boolean applyFixForFunction(Collection<PsiReference> references) {
        Project project = this.myField.getProject();
        JSBlockStatement anchorBlock = ConvertToLocalFix.findAnchorBlock(references);
        if (anchorBlock == null) {
            return false;
        }
        PsiElement firstElement = ConvertToLocalFix.getFirstElement(references);
        PsiElement anchorElement = ConvertToLocalFix.getAnchorElement(anchorBlock, firstElement);
        JSType type = this.myField.getType();
        String typeString = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
        StringBuilder text = new StringBuilder("var ").append(this.myField.getName());
        boolean assignment = ConvertToLocalFix.isAssignment(anchorElement, firstElement);
        if (!(StringUtil.isEmpty((String)typeString) || DialectDetector.isTypeScript((PsiElement)this.myField) && assignment)) {
            text.append(":").append(typeString);
        }
        if (assignment) {
            JSExpression expression = ((JSExpressionStatement)anchorElement).getExpression();
            JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
            text.append("=").append(rOperand.getText());
        } else {
            JSExpression initializer = this.myField.getInitializer();
            if (initializer != null) {
                text.append("=").append(initializer.getText());
            }
        }
        text.append(JSCodeStyleSettings.getSemicolon((PsiElement)anchorBlock.getContainingFile()));
        PsiElement varStatement = JSChangeUtil.createJSTreeFromText((Project)project, (String)text.toString(), (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
        if (varStatement == null) {
            return false;
        }
        PsiElement newDeclaration = assignment ? anchorElement.replace(varStatement) : anchorBlock.addBefore(varStatement, anchorElement);
        CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(anchorBlock.getParent().getNode(), anchorBlock.getNode());
        if (newDeclaration != null) {
            PsiFile file;
            Editor editor;
            PsiFile psiFile = this.myField.getContainingFile();
            int offset = newDeclaration.getTextOffset();
            PsiElement context = psiFile.getContext();
            if (context != null) {
                psiFile = context.getContainingFile();
                offset = InjectedLanguageManager.getInstance((Project)project).injectedToHost(newDeclaration, offset);
            }
            if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == psiFile) {
                editor.getCaretModel().moveToOffset(offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }
        return true;
    }

    private void deleteField() {
        PsiElement varStatement = this.myField.getParent();
        LOG.assertTrue(varStatement instanceof JSVarStatement);
        PsiElement cl = varStatement.getParent();
        PsiElement first = varStatement.getPrevSibling();
        if (first instanceof PsiWhiteSpace) {
            cl.deleteChildRange(first, varStatement);
        } else {
            this.myField.delete();
        }
    }

    private static boolean isAssignment(PsiElement anchorElement, PsiElement ref) {
        JSExpressionStatement expressionStatement;
        JSExpression expression;
        if (anchorElement instanceof JSExpressionStatement && (expression = (expressionStatement = (JSExpressionStatement)anchorElement).getExpression()) instanceof JSAssignmentExpression) {
            return ((JSAssignmentExpression)expression).getOperationSign() == JSTokenTypes.EQ && PsiTreeUtil.isAncestor((PsiElement)((JSAssignmentExpression)expression).getLOperand(), (PsiElement)ref, (boolean)true);
        }
        return false;
    }

    @Nullable
    private static JSBlockStatement findAnchorBlock(Collection<PsiReference> references) {
        JSBlockStatement result = null;
        for (PsiReference psiReference : references) {
            PsiElement element = psiReference.getElement();
            JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSBlockStatement.class);
            if (result == null || block == null) {
                result = block;
                continue;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)result, (PsiElement)block);
            result = (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)commonParent, JSBlockStatement.class, (boolean)false);
        }
        return result;
    }

    @NotNull
    private static PsiElement getFirstElement(Collection<PsiReference> references) {
        PsiElement firstElement = null;
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (firstElement != null && firstElement.getTextRange().getStartOffset() <= element.getTextRange().getStartOffset()) continue;
            firstElement = element;
        }
        LOG.assertTrue(firstElement != null);
        PsiElement psiElement = firstElement;
        if (psiElement == null) {
            ConvertToLocalFix.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement getAnchorElement(JSBlockStatement anchorBlock, @NotNull PsiElement firstElement) {
        PsiElement element;
        if (firstElement == null) {
            ConvertToLocalFix.$$$reportNull$$$0(4);
        }
        for (element = firstElement; element != null && element.getParent() != anchorBlock; element = element.getParent()) {
        }
        LOG.assertTrue(element != null);
        PsiElement psiElement = element;
        if (psiElement == null) {
            ConvertToLocalFix.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/actionscript/fixes/ConvertToLocalFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/actionscript/fixes/ConvertToLocalFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchorElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

