/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSOverrideHandler;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ActionScriptGenerateToStringHandler
extends BaseJSGenerateHandler {
    ActionScriptGenerateToStringHandler() {
    }

    protected String getTitleKey() {
        return "generate.to.string.chooser.title";
    }

    protected BaseCreateMembersFix createFix(final PsiElement jsClass) {
        return new BaseCreateMembersFix<JSVariable>((PsiElement)((JSClass)jsClass)){

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.evalAnchor(editor, file);
                final boolean[] needOverride = new boolean[1];
                JSInheritanceUtil.processOverrides((JSClass)((JSClass)jsClass), (JSOverrideHandler)new JSOverrideHandler(){

                    public boolean process(@NotNull List<JSPsiElementBase> elements, PsiElement scope, String className) {
                        if (elements == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        needOverride[0] = !"Object".equals(className);
                        return false;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/generation/ActionScriptGenerateToStringHandler$1$1", "process"));
                    }
                }, (String)"toString", null, (PsiElement)this.myJsClass, (boolean)true);
                String functionText = "public " + (needOverride[0] ? "override " : "") + "function toString():String {\nreturn " + (needOverride[0] ? "super.toString()" : "\"" + ((JSClass)jsClass).getName());
                String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)file);
                boolean first = true;
                Set jsVariables = this.getElementsToProcess();
                if (!jsVariables.isEmpty()) {
                    functionText = functionText + (needOverride[0] ? " + \"{" : "{");
                    for (JSVariable var : jsVariables) {
                        if (!first) {
                            functionText = functionText + " + \",";
                        }
                        first = false;
                        functionText = functionText + var.getName() + "=\" + String(" + var.getName() + ")";
                    }
                    functionText = functionText + "+\"}\"";
                } else if (!needOverride[0]) {
                    functionText = functionText + "\"";
                }
                functionText = functionText + semicolon + "\n}";
                this.doAddOneMethod(project, functionText, this.anchor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/ActionScriptGenerateToStringHandler$1", "invoke"));
            }
        };
    }

    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        ActionScriptGenerateToStringHandler.collectJSVariables((PsiElement)clazz, candidates, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
    }

    protected boolean canHaveEmptySelectedElements() {
        return true;
    }

    protected boolean isValidForTarget(PsiElement jsClass) {
        return jsClass instanceof JSClass && !((JSClass)jsClass).isInterface();
    }
}

