/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.wizard;

import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleBuilder;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.sdk.FlexSdkComboBoxWithBrowseButton;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FlexModuleWizardForm {
    private JPanel myMainPanel;
    private JComboBox myTargetPlatformCombo;
    private NonFocusableCheckBox myPureActionScriptCheckBox;
    private JComboBox myOutputTypeCombo;
    private JLabel myTargetDevicesLabel;
    private JCheckBox myAndroidCheckBox;
    private JCheckBox myIOSCheckBox;
    private JLabel mySdkLabel;
    private FlexSdkComboBoxWithBrowseButton mySdkCombo;
    private JLabel myTargetPlayerLabel;
    private JComboBox myTargetPlayerCombo;
    private JCheckBox mySampleAppCheckBox;
    private JTextField mySampleAppTextField;
    private JCheckBox myHtmlWrapperCheckBox;
    private JCheckBox myEnableHistoryCheckBox;
    private JCheckBox myCheckPlayerVersionCheckBox;
    private JCheckBox myExpressInstallCheckBox;

    public FlexModuleWizardForm() {
        this.$$$setupUI$$$();
        this.mySdkLabel.setLabelFor(this.mySdkCombo.getChildComponent());
        BCUtils.initTargetPlatformCombo(this.myTargetPlatformCombo);
        BCUtils.initOutputTypeCombo(this.myOutputTypeCombo);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlexModuleWizardForm.this.updateControls();
            }
        };
        this.myTargetPlatformCombo.addActionListener(listener);
        this.myOutputTypeCombo.addActionListener(listener);
        this.mySampleAppCheckBox.addActionListener(listener);
        this.myHtmlWrapperCheckBox.addActionListener(listener);
        this.myCheckPlayerVersionCheckBox.addActionListener(listener);
        this.mySdkCombo.addComboboxListener(new FlexSdkComboBoxWithBrowseButton.Listener(){

            @Override
            public void stateChanged() {
                BCUtils.updateAvailableTargetPlayers(FlexModuleWizardForm.this.mySdkCombo.getSelectedSdk(), FlexModuleWizardForm.this.myTargetPlayerCombo);
                FlexModuleWizardForm.this.updateControls();
            }
        });
        this.myPureActionScriptCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sampleApp = FlexModuleWizardForm.this.mySampleAppTextField.getText().trim();
                if (sampleApp.endsWith(".as") || sampleApp.endsWith(".mxml")) {
                    FlexModuleWizardForm.this.mySampleAppTextField.setText(FileUtil.getNameWithoutExtension((String)sampleApp) + (FlexModuleWizardForm.this.myPureActionScriptCheckBox.isSelected() ? ".as" : ".mxml"));
                }
            }
        });
        this.reset();
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void setEnabled(boolean enabled) {
        UIUtil.setEnabled((Component)this.myMainPanel, (boolean)enabled, (boolean)true);
        if (enabled) {
            this.updateControls();
        }
    }

    private void reset() {
        this.myTargetPlayerCombo.setSelectedItem(TargetPlatform.Web);
        this.myPureActionScriptCheckBox.setSelected(false);
        this.myOutputTypeCombo.setSelectedItem(OutputType.Application);
        this.myAndroidCheckBox.setSelected(true);
        this.myIOSCheckBox.setSelected(true);
        BCUtils.updateAvailableTargetPlayers(this.mySdkCombo.getSelectedSdk(), this.myTargetPlayerCombo);
        this.mySampleAppCheckBox.setSelected(true);
        this.mySampleAppTextField.setText("Main.mxml");
        this.myHtmlWrapperCheckBox.setSelected(true);
        this.myEnableHistoryCheckBox.setSelected(true);
        this.myCheckPlayerVersionCheckBox.setSelected(true);
        this.myExpressInstallCheckBox.setSelected(true);
        this.updateControls();
    }

    private void updateControls() {
        Sdk sdk = this.mySdkCombo.getSelectedSdk();
        boolean sdkSet = sdk != null;
        boolean web = this.myTargetPlatformCombo.getSelectedItem() == TargetPlatform.Web;
        boolean mobile = this.myTargetPlatformCombo.getSelectedItem() == TargetPlatform.Mobile;
        boolean app = this.myOutputTypeCombo.getSelectedItem() == OutputType.Application;
        boolean createSampleAppWasEnabled = this.mySampleAppCheckBox.isEnabled();
        boolean createHtmlWrapperWasEnabled = this.myHtmlWrapperCheckBox.isEnabled();
        boolean targetDeviceWasEnabled = this.myTargetDevicesLabel.isEnabled();
        this.myTargetDevicesLabel.setEnabled(mobile && app);
        this.myAndroidCheckBox.setEnabled(mobile && app);
        this.myIOSCheckBox.setEnabled(mobile && app);
        this.myTargetPlayerLabel.setEnabled(web && sdkSet);
        this.myTargetPlayerCombo.setEnabled(web && sdkSet);
        this.mySampleAppCheckBox.setEnabled(app && sdkSet);
        this.mySampleAppTextField.setEnabled(app && sdkSet);
        this.myHtmlWrapperCheckBox.setEnabled(web && app && sdkSet);
        if (this.myTargetDevicesLabel.isEnabled() && !targetDeviceWasEnabled) {
            this.myAndroidCheckBox.setSelected(true);
            this.myIOSCheckBox.setSelected(true);
        }
        if (!this.myTargetDevicesLabel.isEnabled()) {
            this.myAndroidCheckBox.setSelected(mobile);
            this.myIOSCheckBox.setSelected(mobile);
        }
        if (!this.mySampleAppCheckBox.isEnabled() || !createSampleAppWasEnabled) {
            this.mySampleAppCheckBox.setSelected(this.mySampleAppCheckBox.isEnabled());
        }
        this.mySampleAppTextField.setEnabled(this.mySampleAppCheckBox.isEnabled() && this.mySampleAppCheckBox.isSelected());
        if (!this.myHtmlWrapperCheckBox.isEnabled() || !createHtmlWrapperWasEnabled) {
            this.myHtmlWrapperCheckBox.setSelected(this.myHtmlWrapperCheckBox.isEnabled());
        }
        this.myEnableHistoryCheckBox.setEnabled(this.myHtmlWrapperCheckBox.isSelected() && web && app);
        this.myCheckPlayerVersionCheckBox.setEnabled(this.myHtmlWrapperCheckBox.isSelected() && web && app);
        this.myExpressInstallCheckBox.setEnabled(this.myHtmlWrapperCheckBox.isSelected() && this.myCheckPlayerVersionCheckBox.isSelected() && web && app);
    }

    public void applyTo(FlexModuleBuilder moduleBuilder) {
        moduleBuilder.setTargetPlatform((TargetPlatform)this.myTargetPlatformCombo.getSelectedItem());
        moduleBuilder.setPureActionScript(this.myPureActionScriptCheckBox.isSelected());
        moduleBuilder.setOutputType((OutputType)this.myOutputTypeCombo.getSelectedItem());
        moduleBuilder.setAndroidEnabled(this.myAndroidCheckBox.isSelected());
        moduleBuilder.setIOSEnabled(this.myIOSCheckBox.isSelected());
        moduleBuilder.setFlexSdk(this.mySdkCombo.getSelectedSdk());
        moduleBuilder.setTargetPlayer((String)this.myTargetPlayerCombo.getSelectedItem());
        moduleBuilder.setCreateSampleApp(this.mySampleAppCheckBox.isEnabled() && this.mySampleAppCheckBox.isSelected());
        moduleBuilder.setSampleAppName(this.mySampleAppTextField.getText().trim());
        moduleBuilder.setCreateHtmlWrapperTemplate(this.myHtmlWrapperCheckBox.isEnabled() && this.myHtmlWrapperCheckBox.isSelected());
        moduleBuilder.setHtmlWrapperTemplateParameters(this.myEnableHistoryCheckBox.isSelected(), this.myCheckPlayerVersionCheckBox.isSelected(), this.myExpressInstallCheckBox.isEnabled() && this.myExpressInstallCheckBox.isSelected());
    }

    public boolean validate() throws ConfigurationException {
        Sdk sdk = this.mySdkCombo.getSelectedSdk();
        if (sdk != null) {
            if (this.myTargetPlatformCombo.getSelectedItem() == TargetPlatform.Mobile && !FlexSdkUtils.isAirSdkWithoutFlex(sdk) && StringUtil.compareVersionNumbers((String)sdk.getVersionString(), (String)"4.5") < 0) {
                throw new ConfigurationException(FlexBundle.message("sdk.does.not.support.air.mobile", sdk.getVersionString()));
            }
            if (FlexSdkUtils.isAirSdkWithoutFlex(sdk) && !this.myPureActionScriptCheckBox.isSelected()) {
                throw new ConfigurationException(StringUtil.capitalize((String)FlexBundle.message("air.sdk.requires.pure.as", sdk.getName())));
            }
            if (this.mySampleAppCheckBox.isSelected()) {
                String fileName = this.mySampleAppTextField.getText().trim();
                if (fileName.isEmpty()) {
                    throw new ConfigurationException(FlexBundle.message("sample.app.name.empty", new Object[0]));
                }
                String extension = FileUtilRt.getExtension((String)fileName).toLowerCase();
                if (!"mxml".equals(extension) && !"as".equals(extension)) {
                    throw new ConfigurationException(FlexBundle.message("sample.app.incorrect.extension", new Object[0]));
                }
            }
        }
        return true;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JLabel jLabel;
        FlexSdkComboBoxWithBrowseButton flexSdkComboBoxWithBrowseButton;
        JLabel jLabel2;
        JTextField jTextField;
        JComboBox jComboBox;
        JLabel jLabel3;
        JCheckBox jCheckBox7;
        JComboBox jComboBox2;
        NonFocusableCheckBox nonFocusableCheckBox;
        JComboBox jComboBox3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(14, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(13, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Target platform:");
        jLabel4.setDisplayedMnemonic('G');
        jLabel4.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetPlatformCombo = jComboBox3 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Web");
        jComboBox3.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, null, null));
        this.myPureActionScriptCheckBox = nonFocusableCheckBox = new NonFocusableCheckBox();
        nonFocusableCheckBox.setText("Pure ActionScript");
        nonFocusableCheckBox.setMnemonic('U');
        nonFocusableCheckBox.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)nonFocusableCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Output type:");
        jLabel5.setDisplayedMnemonic('O');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputTypeCombo = jComboBox2 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("Application");
        jComboBox2.setModel(defaultComboBoxModel2);
        jPanel.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySampleAppCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Create sample app:");
        jCheckBox7.setMnemonic('S');
        jCheckBox7.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jCheckBox7, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTargetPlayerLabel = jLabel3 = new JLabel();
        jLabel3.setText("Target player:");
        jLabel3.setDisplayedMnemonic('T');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetPlayerCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(5, 1, 1, 1, 8, 1, 3, 0, null, null, null));
        this.mySampleAppTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(7, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        this.mySdkLabel = jLabel2 = new JLabel();
        jLabel2.setText("Flex/AIR SDK:");
        jLabel2.setDisplayedMnemonic('K');
        jLabel2.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySdkCombo = flexSdkComboBoxWithBrowseButton = new FlexSdkComboBoxWithBrowseButton();
        jPanel.add((Component)((Object)flexSdkComboBoxWithBrowseButton), new GridConstraints(4, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        this.myTargetDevicesLabel = jLabel = new JLabel();
        jLabel.setText("Target devices:");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myAndroidCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Android");
        jCheckBox6.setMnemonic('A');
        jCheckBox6.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel2.add((Component)spacer6, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myIOSCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("iOS");
        jCheckBox5.setMnemonic('I');
        jCheckBox5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox5, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableHistoryCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Enable integration with browser navigation");
        jCheckBox4.setMnemonic('E');
        jCheckBox4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox4, new GridConstraints(10, 0, 1, 4, 8, 0, 3, 0, null, null, null, 2));
        this.myCheckPlayerVersionCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Check Flash player version");
        jCheckBox3.setMnemonic('V');
        jCheckBox3.setDisplayedMnemonicIndex(19);
        jPanel.add((Component)jCheckBox3, new GridConstraints(11, 0, 1, 4, 8, 0, 3, 0, null, null, null, 2));
        this.myExpressInstallCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Express install");
        jCheckBox2.setMnemonic('X');
        jCheckBox2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jCheckBox2, new GridConstraints(12, 0, 1, 4, 8, 0, 3, 0, null, null, null, 4));
        this.myHtmlWrapperCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Create HTML wrapper template");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jCheckBox, new GridConstraints(9, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        jLabel4.setLabelFor(jComboBox3);
        jLabel5.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

