/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.sdk;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderSdkFinder;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import icons.FlexIcons;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexSdkType2
extends SdkType {
    public static final String NAME = "Flex SDK Type (new)";
    public static final String LAST_SELECTED_FLEX_SDK_HOME_KEY = "last.selected.flex.sdk.home";

    public FlexSdkType2() {
        super(NAME);
    }

    @Nullable
    public String suggestHomePath() {
        String path = PropertiesComponent.getInstance().getValue(LAST_SELECTED_FLEX_SDK_HOME_KEY);
        if (path != null) {
            return PathUtil.getParentPath((String)path);
        }
        String fbInstallation = FlashBuilderSdkFinder.findFBInstallationPath();
        return fbInstallation == null ? null : fbInstallation + "/" + "sdks";
    }

    public boolean isValidSdkHome(String path) {
        if (path == null) {
            return false;
        }
        VirtualFile sdkHome = LocalFileSystem.getInstance().findFileByPath(path);
        if (sdkHome == null || !sdkHome.isDirectory()) {
            return false;
        }
        return FlexSdkUtils.doReadFlexSdkVersion(sdkHome) != null || FlexSdkUtils.doReadAirSdkVersion(sdkHome) != null;
    }

    @NotNull
    public String suggestSdkName(String currentSdkName, String sdkHome) {
        String string = PathUtil.getFileName((String)sdkHome);
        if (string == null) {
            FlexSdkType2.$$$reportNull$$$0(0);
        }
        return string;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            FlexSdkType2.$$$reportNull$$$0(1);
        }
        if (sdkModificator == null) {
            FlexSdkType2.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            FlexSdkType2.$$$reportNull$$$0(3);
        }
        if (additional == null) {
            FlexSdkType2.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    public String getPresentableName() {
        String string = FlexBundle.message("flex.sdk.presentable.name", new Object[0]);
        if (string == null) {
            FlexSdkType2.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = this.getIcon();
        if (icon == null) {
            FlexSdkType2.$$$reportNull$$$0(6);
        }
        return icon;
    }

    @NotNull
    public static FlexSdkType2 getInstance() {
        FlexSdkType2 flexSdkType2 = (FlexSdkType2)SdkType.findInstance(FlexSdkType2.class);
        if (flexSdkType2 == null) {
            FlexSdkType2.$$$reportNull$$$0(7);
        }
        return flexSdkType2;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            FlexSdkType2.$$$reportNull$$$0(8);
        }
        SdkModificator modificator = sdk.getSdkModificator();
        this.setupSdkPaths(sdk.getHomeDirectory(), modificator);
        modificator.commitChanges();
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = FlexIcons.Flex.Sdk.Flex_sdk;
        if (icon == null) {
            FlexSdkType2.$$$reportNull$$$0(9);
        }
        return icon;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.flex" == null) {
            FlexSdkType2.$$$reportNull$$$0(10);
        }
        return "reference.project.structure.sdk.flex";
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            FlexSdkType2.$$$reportNull$$$0(11);
        }
        return type == OrderRootType.CLASSES || type == OrderRootType.SOURCES || type == JavadocOrderRootType.getInstance();
    }

    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            FlexSdkType2.$$$reportNull$$$0(12);
        }
        return "http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/";
    }

    public String getVersionString(String sdkHome) {
        VirtualFile sdkRoot = LocalFileSystem.getInstance().findFileByPath(sdkHome);
        String flexVersion = FlexSdkUtils.doReadFlexSdkVersion(sdkRoot);
        if (flexVersion != null) {
            return flexVersion;
        }
        String airVersion = FlexSdkUtils.doReadAirSdkVersion(sdkRoot);
        return airVersion != null ? "AIR SDK " + airVersion : FlexBundle.message("flex.sdk.version.unknown", new Object[0]);
    }

    private void setupSdkPaths(VirtualFile sdkRoot, SdkModificator sdkModificator) {
        VirtualFile projectsDir;
        VirtualFile baseDir;
        if (sdkRoot == null || !sdkRoot.isValid()) {
            return;
        }
        PropertiesComponent.getInstance().setValue(LAST_SELECTED_FLEX_SDK_HOME_KEY, sdkRoot.getPath());
        sdkRoot.refresh(false, true);
        sdkModificator.setVersionString(this.getVersionString(sdkRoot.getPath()));
        VirtualFile playerDir = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)((NullableComputable)() -> {
            VirtualFile libsDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(sdkRoot.getPath() + "/frameworks/libs");
            if (libsDir != null && libsDir.isDirectory()) {
                libsDir.refresh(false, true);
                return libsDir.findChild("player");
            }
            return null;
        }));
        if (playerDir != null) {
            FlexSdkUtils.processPlayerglobalSwcFiles(playerDir, (Processor<? super VirtualFile>)((Processor)playerglobalSwcFile -> {
                FlexSdkType2.addSwcRoot(sdkModificator, playerglobalSwcFile);
                return true;
            }));
        }
        if ((baseDir = sdkRoot.findChild("frameworks")) != null && baseDir.isDirectory()) {
            FlexSdkType2.addSwcRoots(sdkModificator, baseDir, Collections.singletonList("libs/air/airglobal.swc"), false);
            FlexSdkType2.addFlexSdkSwcRoots(sdkModificator, baseDir);
        }
        if ((projectsDir = VfsUtilCore.findRelativeFile((String)"frameworks/projects", (VirtualFile)sdkRoot)) != null && projectsDir.isDirectory()) {
            FlexSdkType2.findSourceRoots(projectsDir, sdkModificator);
        }
    }

    public static void addFlexSdkSwcRoots(SdkModificator sdkModificator, VirtualFile frameworksDir) {
        FlexSdkType2.addSwcRoots(sdkModificator, frameworksDir, Arrays.asList("libs", "libs/mx", "libs/air", "libs/mobile", "themes/Mobile"), true);
    }

    private static void findSourceRoots(VirtualFile dir, final SdkModificator sdkModificator) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT}){

            public boolean visitFile(@NotNull VirtualFile child) {
                if (child == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (child.isDirectory() && child.getName().equals("src")) {
                    sdkModificator.addRoot(child, OrderRootType.SOURCES);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2$1", "visitFile"));
            }
        });
    }

    private static void addSwcRoots(SdkModificator sdkModificator, VirtualFile baseDir, List<String> libRelativePaths, boolean skipAirglobalSwc) {
        for (String libRelativePath : libRelativePaths) {
            VirtualFile libFileOrDir = baseDir.findFileByRelativePath(libRelativePath);
            if (libFileOrDir == null) continue;
            if (libFileOrDir.isDirectory()) {
                for (VirtualFile libCandidate : libFileOrDir.getChildren()) {
                    if (libCandidate.isDirectory() || !"swc".equalsIgnoreCase(libCandidate.getExtension()) || skipAirglobalSwc && libCandidate.getPath().endsWith("frameworks/libs/air/airglobal.swc")) continue;
                    FlexSdkType2.addSwcRoot(sdkModificator, libCandidate);
                }
                continue;
            }
            if (!"swc".equalsIgnoreCase(libFileOrDir.getExtension()) || skipAirglobalSwc && libFileOrDir.getPath().endsWith("frameworks/libs/air/airglobal.swc")) continue;
            FlexSdkType2.addSwcRoot(sdkModificator, libFileOrDir);
        }
    }

    private static void addSwcRoot(@NotNull SdkModificator sdkModificator, @NotNull VirtualFile swcFile) {
        VirtualFile jarRoot;
        if (sdkModificator == null) {
            FlexSdkType2.$$$reportNull$$$0(13);
        }
        if (swcFile == null) {
            FlexSdkType2.$$$reportNull$$$0(14);
        }
        if ((jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(swcFile)) != null) {
            sdkModificator.addRoot(jarRoot, OrderRootType.CLASSES);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/sdk/FlexSdkType2";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "swcFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/sdk/FlexSdkType2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocumentationUrl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addSwcRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

