/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.run.LauncherParameters;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FlexLauncherDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JRadioButton myDefaultOSApplicationRadioButton;
    private JRadioButton myBrowserRadioButton;
    private JPanel myBrowserSelectorPanel;
    private final BrowserSelector myBrowserSelector;
    private JRadioButton myPlayerRadioButton;
    private TextFieldWithBrowseButton myPlayerTextWithBrowse;
    private JBCheckBox myNewPlayerInstanceCheckBox;
    private final Project myProject;

    public FlexLauncherDialog(Project project, LauncherParameters launcherParameters) {
        super(project);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(FlexBundle.message("launch.with.title", objectArray));
        this.myBrowserSelector = new BrowserSelector(false);
        this.myBrowserSelectorPanel.add("Center", this.myBrowserSelector.getMainComponent());
        this.initRadioButtons();
        this.initControls(launcherParameters);
        this.updateControls();
        this.init();
    }

    private void initRadioButtons() {
        this.myDefaultOSApplicationRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlexLauncherDialog.this.updateControls();
            }
        });
        this.myBrowserRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlexLauncherDialog.this.updateControls();
                IdeFocusManager.getInstance((Project)FlexLauncherDialog.this.myProject).requestFocus((Component)FlexLauncherDialog.this.myBrowserSelector.getMainComponent(), true);
            }
        });
        this.myPlayerRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlexLauncherDialog.this.updateControls();
                IdeFocusManager.getInstance((Project)FlexLauncherDialog.this.myProject).requestFocus((Component)FlexLauncherDialog.this.myPlayerTextWithBrowse.getTextField(), true);
            }
        });
    }

    private void initControls(LauncherParameters launcherParameters) {
        LauncherParameters.LauncherType launcherType = launcherParameters.getLauncherType();
        this.myDefaultOSApplicationRadioButton.setSelected(launcherType == LauncherParameters.LauncherType.OSDefault);
        this.myBrowserRadioButton.setSelected(launcherType == LauncherParameters.LauncherType.Browser);
        this.myPlayerRadioButton.setSelected(launcherType == LauncherParameters.LauncherType.Player);
        this.myBrowserSelector.setSelected(launcherParameters.getBrowser());
        this.myPlayerTextWithBrowse.setText(FileUtil.toSystemDependentName((String)launcherParameters.getPlayerPath()));
        this.myPlayerTextWithBrowse.addBrowseFolderListener(null, null, this.myProject, new FileChooserDescriptor(true, true, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return SystemInfo.isMac && file.isDirectory() && "app".equalsIgnoreCase(file.getExtension()) || !file.isDirectory();
            }
        });
        this.myNewPlayerInstanceCheckBox.setVisible(SystemInfo.isMac);
    }

    private void updateControls() {
        this.myBrowserSelector.getMainComponent().setEnabled(this.myBrowserRadioButton.isSelected());
        this.myPlayerTextWithBrowse.setEnabled(this.myPlayerRadioButton.isSelected());
        this.myNewPlayerInstanceCheckBox.setEnabled(this.myPlayerRadioButton.isSelected());
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public LauncherParameters getLauncherParameters() {
        LauncherParameters.LauncherType launcherType = this.myPlayerRadioButton.isSelected() ? LauncherParameters.LauncherType.Player : (this.myBrowserRadioButton.isSelected() ? LauncherParameters.LauncherType.Browser : LauncherParameters.LauncherType.OSDefault);
        WebBrowser browser = this.myBrowserSelector.getSelected();
        WebBrowser notNullBrowser = browser == null ? WebBrowserManager.getInstance().getFirstBrowser(BrowserFamily.FIREFOX) : browser;
        String playerPath = FileUtil.toSystemIndependentName((String)this.myPlayerTextWithBrowse.getText().trim());
        boolean isNewPlayerInstance = this.myNewPlayerInstanceCheckBox.isSelected();
        return new LauncherParameters(launcherType, notNullBrowser, playerPath, isNewPlayerInstance);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDefaultOSApplicationRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("System default application");
        jRadioButton3.setMnemonic('S');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myBrowserRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Browser:");
        jRadioButton2.setMnemonic('B');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPlayerRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Flash Player:");
        jRadioButton.setMnemonic('F');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPlayerTextWithBrowse = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, new Dimension(250, -1), null, null));
        this.myBrowserSelectorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myNewPlayerInstanceCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("New instance");
        jBCheckBox.setMnemonic('N');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 3));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

