/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.run.BCBasedRunnerParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import gnu.trove.THashMap;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class BCCombo
extends JComboBox {
    private final Project myProject;
    private FlexBuildConfiguration[] myAllConfigs;
    private boolean mySingleModuleProject;
    private Map<FlexBuildConfiguration, Module> myBCToModuleMap = new THashMap();

    public BCCombo(Project project) {
        this.myProject = project;
        this.initCombo();
    }

    private void initCombo() {
        this.setMinimumSize(new Dimension(150, this.getMinimumSize().height));
        ArrayList<FlexBuildConfiguration> allConfigs = new ArrayList<FlexBuildConfiguration>();
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        this.mySingleModuleProject = modules.length == 1;
        for (Module module : modules) {
            if (!(ModuleType.get((Module)module) instanceof FlexModuleType)) continue;
            for (FlexBuildConfiguration config : FlexBuildConfigurationManager.getInstance(module).getBuildConfigurations()) {
                allConfigs.add(config);
                this.myBCToModuleMap.put(config, module);
            }
        }
        this.myAllConfigs = allConfigs.toArray(new FlexBuildConfiguration[0]);
        this.setRenderer(new ColoredListCellRendererWrapper(){

            protected void doCustomize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof Pair) {
                    String moduleName = (String)((Pair)value).first;
                    String configName = (String)((Pair)value).second;
                    if (moduleName.isEmpty() || configName.isEmpty()) {
                        this.append(new SimpleColoredText("[none]", SimpleTextAttributes.ERROR_ATTRIBUTES));
                    } else {
                        this.append(BCUtils.renderMissingBuildConfiguration(configName, moduleName));
                    }
                } else {
                    assert (value instanceof FlexBuildConfiguration) : value;
                    FlexBuildConfiguration bc = (FlexBuildConfiguration)value;
                    this.setIcon(bc.getIcon());
                    this.append(BCUtils.renderBuildConfiguration(bc, BCCombo.this.mySingleModuleProject ? null : ((Module)BCCombo.this.myBCToModuleMap.get(bc)).getName()));
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = BCCombo.this.getSelectedItem();
                Object firstItem = BCCombo.this.getItemAt(0);
                if (selectedItem instanceof FlexBuildConfiguration && !(firstItem instanceof FlexBuildConfiguration)) {
                    BCCombo.this.setModel(new DefaultComboBoxModel<FlexBuildConfiguration>(BCCombo.this.myAllConfigs));
                    BCCombo.this.setSelectedItem(selectedItem);
                }
            }
        });
    }

    public void resetFrom(BCBasedRunnerParameters params) {
        FlexBuildConfiguration config;
        Module module = ModuleManager.getInstance((Project)this.myProject).findModuleByName(params.getModuleName());
        FlexBuildConfiguration flexBuildConfiguration = config = module != null && ModuleType.get((Module)module) instanceof FlexModuleType ? FlexBuildConfigurationManager.getInstance(module).findConfigurationByName(params.getBCName()) : null;
        if (config == null) {
            Object[] model = new Object[this.myAllConfigs.length + 1];
            model[0] = Pair.create((Object)params.getModuleName(), (Object)params.getBCName());
            System.arraycopy(this.myAllConfigs, 0, model, 1, this.myAllConfigs.length);
            this.setModel(new DefaultComboBoxModel<Object>(model));
            this.setSelectedIndex(0);
        } else {
            this.setModel(new DefaultComboBoxModel<FlexBuildConfiguration>(this.myAllConfigs));
            this.setSelectedItem(config);
        }
    }

    public void applyTo(BCBasedRunnerParameters params) {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem instanceof Pair) {
            params.setModuleName((String)((Pair)selectedItem).first);
            params.setBCName((String)((Pair)selectedItem).second);
        } else {
            assert (selectedItem instanceof FlexBuildConfiguration) : selectedItem;
            params.setModuleName(this.myBCToModuleMap.get((FlexBuildConfiguration)selectedItem).getName());
            params.setBCName(((FlexBuildConfiguration)selectedItem).getName());
        }
    }

    public void dispose() {
        this.myAllConfigs = null;
        this.myBCToModuleMap = null;
    }

    @Nullable
    public FlexBuildConfiguration getBC() {
        Object selectedItem = this.getSelectedItem();
        return selectedItem instanceof FlexBuildConfiguration ? (FlexBuildConfiguration)selectedItem : null;
    }

    @Nullable
    public Module getModule() {
        Object selectedItem = this.getSelectedItem();
        return selectedItem instanceof FlexBuildConfiguration ? this.myBCToModuleMap.get((FlexBuildConfiguration)selectedItem) : null;
    }

    private static String getPresentableText(String moduleName, String configName, boolean singleModuleProject) {
        if (moduleName.isEmpty() || configName.isEmpty()) {
            return "[none]";
        }
        return singleModuleProject ? configName : configName + " (" + moduleName + ")";
    }
}

