/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.flex.FlexCommonBundle;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.actions.airpackage.DeviceInfo;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BCBasedRunnerParameters
implements Cloneable {
    @NotNull
    private String myModuleName = "";
    @NotNull
    private String myBCName = "";
    @Nullable
    private DeviceInfo myDeviceInfo;

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            BCBasedRunnerParameters.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            BCBasedRunnerParameters.$$$reportNull$$$0(1);
        }
        this.myModuleName = moduleName;
    }

    @NotNull
    public String getBCName() {
        String string = this.myBCName;
        if (string == null) {
            BCBasedRunnerParameters.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setBCName(@NotNull String BCName) {
        if (BCName == null) {
            BCBasedRunnerParameters.$$$reportNull$$$0(3);
        }
        this.myBCName = BCName;
    }

    @Transient
    @Nullable
    public DeviceInfo getDeviceInfo() {
        return this.myDeviceInfo;
    }

    public void setDeviceInfo(@Nullable DeviceInfo deviceInfo) {
        this.myDeviceInfo = deviceInfo;
    }

    public Pair<Module, FlexBuildConfiguration> checkAndGetModuleAndBC(Project project) throws RuntimeConfigurationError {
        if (this.myModuleName.isEmpty() || this.myBCName.isEmpty()) {
            throw new RuntimeConfigurationError(FlexBundle.message("bc.not.specified", new Object[0]));
        }
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(this.myModuleName);
        if (module == null || !(ModuleType.get((Module)module) instanceof FlexModuleType)) {
            throw new RuntimeConfigurationError(FlexBundle.message("bc.not.specified", new Object[0]));
        }
        FlexBuildConfiguration bc = FlexBuildConfigurationManager.getInstance(module).findConfigurationByName(this.myBCName);
        if (bc == null) {
            throw new RuntimeConfigurationError(FlexBundle.message("module.does.not.contain.bc", this.myModuleName, this.myBCName));
        }
        Sdk sdk = bc.getSdk();
        if (sdk == null) {
            throw new RuntimeConfigurationError(FlexCommonBundle.message((String)"sdk.not.set.for.bc.0.of.module.1", (Object[])new Object[]{bc.getName(), module.getName()}));
        }
        return Pair.create((Object)module, (Object)bc);
    }

    protected BCBasedRunnerParameters clone() {
        try {
            return (BCBasedRunnerParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BCBasedRunnerParameters that = (BCBasedRunnerParameters)o;
        return Objects.equals(this.myModuleName, that.myModuleName) && Objects.equals(this.myBCName, that.myBCName);
    }

    public int hashCode() {
        return Objects.hash(this.myModuleName, this.myBCName);
    }

    public void handleBuildConfigurationsRename(Map<Pair<String, String>, String> renamedConfigs) {
        for (Pair<String, String> oldModuleAndBc : renamedConfigs.keySet()) {
            if (!((String)oldModuleAndBc.first).equals(this.myModuleName) || !((String)oldModuleAndBc.second).equals(this.myBCName)) continue;
            this.myBCName = renamedConfigs.get(oldModuleAndBc);
            break;
        }
    }

    public void handleModulesRename(List<Module> modules, Function<Module, String> oldNameProvider) {
        for (Module module : modules) {
            String oldName = (String)oldNameProvider.fun((Object)module);
            if (!oldName.equals(this.myModuleName)) continue;
            this.myModuleName = module.getName();
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/run/BCBasedRunnerParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "BCName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/run/BCBasedRunnerParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBCName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModuleName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBCName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

