/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModelAdapter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

abstract class EditableTreeTable<T>
extends TreeTable {
    private static final Object HEIGHT_TEST_MARKER = new Object();

    EditableTreeTable(String firstColumnName, ColumnInfo ... columns) {
        super((TreeTableModel)new ListTreeTableModelOnColumns((TreeNode)new DefaultMutableTreeNode(), (ColumnInfo[])ArrayUtil.mergeArrays((Object[])new ColumnInfo[]{new FirstColumnInfo(firstColumnName)}, (Object[])EditableTreeTable.wrap(columns))));
        final ColoredTreeCellRenderer r = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject == HEIGHT_TEST_MARKER) {
                    return;
                }
                EditableTreeTable.this.render((SimpleColoredComponent)this, userObject);
                this.setPaintFocusBorder(false);
            }
        };
        this.setTreeCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return r.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, true);
            }
        });
        Dimension s = r.getTreeCellRendererComponent((JTree)this.getTree(), (Object)new DefaultMutableTreeNode(HEIGHT_TEST_MARKER), false, false, true, 0, false).getPreferredSize();
        this.getTree().setRowHeight(s.height);
    }

    public void updateColumnSizes() {
        JTableHeader header = this.getTableHeader();
        TableCellRenderer defaultRenderer = header == null ? null : header.getDefaultRenderer();
        ColumnInfo[] columns = ((ListTreeTableModelOnColumns)this.getTableModel()).getColumnInfos();
        for (int i = 0; i < columns.length; ++i) {
            int width;
            Object headerSize;
            ColumnInfo columnInfo = columns[i];
            TableColumn column = this.getColumnModel().getColumn(i);
            Component headerComponent = defaultRenderer == null ? null : defaultRenderer.getTableCellRendererComponent((JTable)((Object)this), column.getHeaderValue(), false, false, 0, 0);
            Object object = headerSize = headerComponent == null ? JBUI.emptySize() : headerComponent.getPreferredSize();
            if (columnInfo.getWidth((JTable)((Object)this)) > 0) {
                width = columnInfo.getWidth((JTable)((Object)this));
                column.setMaxWidth(width);
                column.setPreferredWidth(width);
                column.setMinWidth(width);
                continue;
            }
            String maxStringValue = columnInfo.getMaxStringValue();
            if (maxStringValue != null) {
                width = this.getFontMetrics(this.getFont()).stringWidth(maxStringValue) + columnInfo.getAdditionalWidth();
                width = Math.max(width, headerSize.width);
                column.setPreferredWidth(width);
                column.setMaxWidth(width);
                continue;
            }
            String preferredValue = columnInfo.getPreferredStringValue();
            if (preferredValue == null) continue;
            width = this.getFontMetrics(this.getFont()).stringWidth(preferredValue) + columnInfo.getAdditionalWidth();
            width = Math.max(width, headerSize.width);
            column.setPreferredWidth(width);
        }
    }

    public void setModel(TreeTableModel treeTableModel) {
        super.setModel(treeTableModel);
        this.updateColumnSizes();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        Object item;
        ListTreeTableModelOnColumns model = (ListTreeTableModelOnColumns)this.getTableModel();
        ColumnInfo columnInfo = model.getColumnInfos()[this.convertColumnIndexToModel(column)];
        TableCellRenderer renderer = columnInfo.getCustomizedRenderer(item = this.getValueAt(this.convertRowIndexToModel(row), 0), columnInfo.getRenderer(item));
        return renderer == null ? super.getCellRenderer(row, column) : renderer;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        Object item;
        ListTreeTableModelOnColumns model = (ListTreeTableModelOnColumns)this.getTableModel();
        ColumnInfo columnInfo = model.getColumnInfos()[this.convertColumnIndexToModel(column)];
        TableCellEditor editor = columnInfo.getEditor(item = this.getValueAt(this.convertRowIndexToModel(row), 0));
        return editor == null ? super.getCellEditor(row, column) : editor;
    }

    public void refreshItemAt(Integer row) {
        Object node = this.getTree().getPathForRow(row.intValue()).getLastPathComponent();
        ((DefaultTreeModel)this.getTree().getModel()).nodeChanged((TreeNode)node);
    }

    private static ColumnInfo[] wrap(ColumnInfo[] columns) {
        return (ColumnInfo[])ContainerUtil.map2Array((Object[])columns, ColumnInfo.class, columnInfo -> new ColumnInfoWrapper(columnInfo));
    }

    public void refresh() {
        List expandedPaths = TreeUtil.collectExpandedPaths((JTree)this.getTree());
        ((DefaultTreeModel)this.getTree().getModel()).reload();
        TreeUtil.restoreExpandedPaths((JTree)this.getTree(), (List)expandedPaths);
    }

    protected abstract void render(SimpleColoredComponent var1, T var2);

    public List<T> getItems() {
        int rows = this.getRowCount();
        ArrayList<T> result = new ArrayList<T>(rows);
        for (int row = 0; row < rows; ++row) {
            result.add(this.getItemAt(row));
        }
        return result;
    }

    public T getItemAt(int row) {
        return (T)this.getValueAt(row, 0);
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.getTree().getModel().getRoot();
    }

    public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
        TreeTableCellRenderer r = super.createTableRenderer(treeTableModel);
        r.setDefaultBorder(null);
        return r;
    }

    private static class ColumnInfoWrapper<T, Aspect>
    extends ColumnInfo<Object, Aspect> {
        private final ColumnInfo<T, Aspect> myDelegate;

        ColumnInfoWrapper(ColumnInfo<T, Aspect> columnInfo) {
            super(columnInfo.getName());
            this.myDelegate = columnInfo;
        }

        public Class getColumnClass() {
            return ColumnInfoWrapper.class;
        }

        public Aspect valueOf(Object item) {
            return (Aspect)this.myDelegate.valueOf(((DefaultMutableTreeNode)item).getUserObject());
        }

        public TableCellRenderer getRenderer(Object item) {
            return this.myDelegate.getRenderer(item);
        }

        public TableCellRenderer getCustomizedRenderer(Object item, TableCellRenderer renderer) {
            return this.myDelegate.getCustomizedRenderer(item, renderer);
        }

        public TableCellEditor getEditor(Object item) {
            return this.myDelegate.getEditor(item);
        }

        public boolean isCellEditable(Object item) {
            return this.myDelegate.isCellEditable(((DefaultMutableTreeNode)item).getUserObject());
        }

        public void setValue(Object item, Aspect value) {
            this.myDelegate.setValue(((DefaultMutableTreeNode)item).getUserObject(), value);
        }

        public int getWidth(JTable table) {
            return this.myDelegate.getWidth(table);
        }

        public String getMaxStringValue() {
            return this.myDelegate.getMaxStringValue();
        }
    }

    private static class FirstColumnInfo<T>
    extends ColumnInfo<DefaultMutableTreeNode, T> {
        FirstColumnInfo(String name) {
            super(name);
        }

        public T valueOf(DefaultMutableTreeNode treeNode) {
            return (T)treeNode.getUserObject();
        }

        public Class getColumnClass() {
            return TreeTableModel.class;
        }
    }

    private static class EditableModelAdapter
    extends TreeTableModelAdapter
    implements EditableModel {
        EditableModelAdapter(TreeTableModel treeTableModel, JTree tree, JTable table) {
            super(treeTableModel, tree, table);
        }

        public void addRow() {
        }

        public void removeRow(int index) {
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }
    }
}

