/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.importer;

import com.intellij.lang.javascript.flex.importer.AS3InterfaceDumper;
import com.intellij.lang.javascript.flex.importer.ByteBuffer;
import com.intellij.lang.javascript.flex.importer.FlexByteCodeInformationProcessor;
import com.intellij.lang.javascript.flex.importer.MemberInfo;
import com.intellij.lang.javascript.flex.importer.MetaData;
import com.intellij.lang.javascript.flex.importer.MethodInfo;
import com.intellij.lang.javascript.flex.importer.Multiname;
import com.intellij.lang.javascript.flex.importer.SlotInfo;
import com.intellij.lang.javascript.flex.importer.Traits;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class Abc {
    @NonNls
    static final String TAB = "  ";
    @NonNls
    static final String $CINIT = "$cinit";
    @NonNls
    static final String $ = "$";
    private static final int ATTR_final = 1;
    private static final int ATTR_override = 2;
    private static final int ATTR_metadata = 4;
    private static final int ATTR_public = 8;
    static final int CLASS_FLAG_sealed = 1;
    static final int CLASS_FLAG_final = 2;
    static final int CLASS_FLAG_interface = 4;
    static final int CLASS_FLAG_protected = 8;
    private static final int NEED_ARGUMENTS = 1;
    static final int NEED_ACTIVATION = 2;
    private static final int NEED_REST = 4;
    private static final int HAS_OPTIONAL = 8;
    private static final int IGNORE_REST = 16;
    static final int NATIVE = 32;
    private static final int HAS_ParamNames = 128;
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_Int = 3;
    private static final int CONSTANT_UInt = 4;
    private static final int CONSTANT_PrivateNs = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_Qname = 7;
    private static final int CONSTANT_Namespace = 8;
    private static final int CONSTANT_Multiname = 9;
    private static final int CONSTANT_False = 10;
    private static final int CONSTANT_True = 11;
    private static final int CONSTANT_Null = 12;
    private static final int CONSTANT_QnameA = 13;
    private static final int CONSTANT_MultinameA = 14;
    private static final int CONSTANT_RTQname = 15;
    private static final int CONSTANT_RTQnameA = 16;
    private static final int CONSTANT_RTQnameL = 17;
    private static final int CONSTANT_RTQnameLA = 18;
    private static final int CONSTANT_NameL = 19;
    private static final int CONSTANT_NameLA = 20;
    private static final int CONSTANT_NamespaceSet = 21;
    private static final int CONSTANT_PackageNs = 22;
    private static final int CONSTANT_PackageInternalNs = 23;
    private static final int CONSTANT_ProtectedNs = 24;
    private static final int CONSTANT_StaticProtectedNs = 25;
    private static final int CONSTANT_StaticProtectedNs2 = 26;
    private static final int CONSTANT_MultinameL = 27;
    private static final int CONSTANT_MultinameLA = 28;
    private static final int CONSTANT_TypeName = 29;
    @NonNls
    static final String[] constantKinds = new String[]{"0", "utf8", "2", "int", "uint", "private", "double", "qname", "namespace", "multiname", "false", "true", "null", "@qname", "@multiname", "rtqname", "@rtqname", "[qname]", "@[qname]", "[name]", "@[name]", "nsset"};
    protected static final String SCRIPT_PREFIX = "script";
    @NonNls
    static final String[] traitKinds = new String[]{"var", "function", "function get", "function set", "class", "function", "const"};
    @NonNls
    static final String PUBLIC_NS = "";
    static final String PRIVATE_NS = "private";
    @NonNls
    static final String anyNs = "*";
    static final String[] PUBLIC_NS_SET = new String[]{""};
    static final String[] PRIVATE_NS_SET = new String[]{"private"};
    private static final int OP_bkpt = 1;
    private static final int OP_nop = 2;
    private static final int OP_throw = 3;
    static final int OP_getsuper = 4;
    static final int OP_setsuper = 5;
    private static final int OP_dxns = 6;
    private static final int OP_dxnslate = 7;
    static final int OP_kill = 8;
    static final int OP_label = 9;
    static final int OP_ifnlt = 12;
    static final int OP_ifnle = 13;
    static final int OP_ifngt = 14;
    static final int OP_ifnge = 15;
    static final int OP_jump = 16;
    static final int OP_iftrue = 17;
    static final int OP_iffalse = 18;
    static final int OP_ifeq = 19;
    static final int OP_ifne = 20;
    static final int OP_iflt = 21;
    static final int OP_ifle = 22;
    static final int OP_ifgt = 23;
    static final int OP_ifge = 24;
    static final int OP_ifstricteq = 25;
    static final int OP_ifstrictne = 26;
    static final int OP_lookupswitch = 27;
    private static final int OP_pushwith = 28;
    private static final int OP_popscope = 29;
    private static final int OP_nextname = 30;
    private static final int OP_hasnext = 31;
    private static final int OP_pushnull = 32;
    private static final int OP_pushundefined = 33;
    private static final int OP_pushconstant = 34;
    private static final int OP_nextvalue = 35;
    static final int OP_pushbyte = 36;
    static final int OP_pushshort = 37;
    private static final int OP_pushtrue = 38;
    private static final int OP_pushfalse = 39;
    private static final int OP_pushnan = 40;
    private static final int OP_pop = 41;
    private static final int OP_dup = 42;
    private static final int OP_swap = 43;
    static final int OP_pushstring = 44;
    static final int OP_pushint = 45;
    static final int OP_pushuint = 46;
    static final int OP_pushdouble = 47;
    private static final int OP_pushscope = 48;
    static final int OP_pushnamespace = 49;
    static final int OP_hasnext2 = 50;
    static final int OP_newfunction = 64;
    static final int OP_call = 65;
    static final int OP_construct = 66;
    private static final int OP_callmethod = 67;
    static final int OP_callstatic = 68;
    static final int OP_callsuper = 69;
    static final int OP_callproperty = 70;
    private static final int OP_returnvoid = 71;
    private static final int OP_returnvalue = 72;
    static final int OP_constructsuper = 73;
    static final int OP_constructprop = 74;
    private static final int OP_callsuperid = 75;
    static final int OP_callproplex = 76;
    private static final int OP_callinterface = 77;
    static final int OP_callsupervoid = 78;
    static final int OP_callpropvoid = 79;
    private static final int OP_applytype = 83;
    static final int OP_newobject = 85;
    static final int OP_newarray = 86;
    private static final int OP_newactivation = 87;
    static final int OP_newclass = 88;
    static final int OP_getdescendants = 89;
    static final int OP_newcatch = 90;
    static final int OP_findpropstrict = 93;
    static final int OP_findproperty = 94;
    static final int OP_finddef = 95;
    static final int OP_getlex = 96;
    static final int OP_setproperty = 97;
    static final int OP_getlocal = 98;
    static final int OP_setlocal = 99;
    private static final int OP_getglobalscope = 100;
    static final int OP_getscopeobject = 101;
    static final int OP_getproperty = 102;
    private static final int OP_getouterscope = 103;
    static final int OP_initproperty = 104;
    private static final int OP_setpropertylate = 105;
    static final int OP_deleteproperty = 106;
    private static final int OP_deletepropertylate = 107;
    static final int OP_getslot = 108;
    static final int OP_setslot = 109;
    static final int OP_getglobalslot = 110;
    static final int OP_setglobalslot = 111;
    private static final int OP_convert_s = 112;
    private static final int OP_esc_xelem = 113;
    private static final int OP_esc_xattr = 114;
    private static final int OP_convert_i = 115;
    private static final int OP_convert_u = 116;
    private static final int OP_convert_d = 117;
    private static final int OP_convert_b = 118;
    private static final int OP_convert_o = 119;
    static final int OP_coerce = 128;
    private static final int OP_coerce_b = 129;
    private static final int OP_coerce_a = 130;
    private static final int OP_coerce_i = 131;
    private static final int OP_coerce_d = 132;
    private static final int OP_coerce_s = 133;
    static final int OP_astype = 134;
    private static final int OP_astypelate = 135;
    private static final int OP_coerce_u = 136;
    private static final int OP_coerce_o = 137;
    private static final int OP_negate = 144;
    private static final int OP_increment = 145;
    static final int OP_inclocal = 146;
    private static final int OP_decrement = 147;
    static final int OP_declocal = 148;
    private static final int OP_typeof = 149;
    private static final int OP_not = 150;
    private static final int OP_bitnot = 151;
    private static final int OP_concat = 154;
    private static final int OP_add_d = 155;
    private static final int OP_add = 160;
    private static final int OP_subtract = 161;
    private static final int OP_multiply = 162;
    private static final int OP_divide = 163;
    private static final int OP_modulo = 164;
    private static final int OP_lshift = 165;
    private static final int OP_rshift = 166;
    private static final int OP_urshift = 167;
    private static final int OP_bitand = 168;
    private static final int OP_bitor = 169;
    private static final int OP_bitxor = 170;
    private static final int OP_equals = 171;
    private static final int OP_strictequals = 172;
    private static final int OP_lessthan = 173;
    private static final int OP_lessequals = 174;
    private static final int OP_greaterthan = 175;
    private static final int OP_greaterequals = 176;
    private static final int OP_instanceof = 177;
    static final int OP_istype = 178;
    private static final int OP_istypelate = 179;
    private static final int OP_in = 180;
    private static final int OP_increment_i = 192;
    private static final int OP_decrement_i = 193;
    static final int OP_inclocal_i = 194;
    static final int OP_declocal_i = 195;
    private static final int OP_negate_i = 196;
    private static final int OP_add_i = 197;
    private static final int OP_subtract_i = 198;
    private static final int OP_multiply_i = 199;
    private static final int OP_getlocal0 = 208;
    private static final int OP_getlocal1 = 209;
    private static final int OP_getlocal2 = 210;
    private static final int OP_getlocal3 = 211;
    private static final int OP_setlocal0 = 212;
    private static final int OP_setlocal1 = 213;
    private static final int OP_setlocal2 = 214;
    private static final int OP_setlocal3 = 215;
    static final int OP_debug = 239;
    static final int OP_debugline = 240;
    static final int OP_debugfile = 241;
    private static final int OP_bkptline = 242;
    @NonNls
    static final String[] opNames = new String[]{"OP_0x00       ", "bkpt          ", "nop           ", "throw         ", "getsuper      ", "setsuper      ", "dxns          ", "dxnslate      ", "kill          ", "label         ", "OP_0x0A       ", "OP_0x0B       ", "ifnlt         ", "ifnle         ", "ifngt         ", "ifnge         ", "jump          ", "iftrue        ", "iffalse       ", "ifeq          ", "ifne          ", "iflt          ", "ifle          ", "ifgt          ", "ifge          ", "ifstricteq    ", "ifstrictne    ", "lookupswitch  ", "pushwith      ", "popscope      ", "nextname      ", "hasnext       ", "pushnull      ", "pushundefined ", "pushconstant  ", "nextvalue     ", "pushbyte      ", "pushshort     ", "pushtrue      ", "pushfalse     ", "pushnan       ", "pop           ", "dup           ", "swap          ", "pushstring    ", "pushint       ", "pushuint      ", "pushdouble    ", "pushscope     ", "pushnamespace ", "hasnext2      ", "OP_0x33       ", "OP_0x34       ", "OP_0x35       ", "OP_0x36       ", "OP_0x37       ", "OP_0x38       ", "OP_0x39       ", "OP_0x3A       ", "OP_0x3B       ", "OP_0x3C       ", "OP_0x3D       ", "OP_0x3E       ", "OP_0x3F       ", "newfunction   ", "call          ", "construct     ", "callmethod    ", "callstatic    ", "callsuper     ", "callproperty  ", "returnvoid    ", "returnvalue   ", "constructsuper", "constructprop ", "callsuperid   ", "callproplex   ", "callinterface ", "callsupervoid ", "callpropvoid  ", "OP_0x50       ", "OP_0x51       ", "OP_0x52       ", "applytype     ", "OP_0x54       ", "newobject     ", "newarray      ", "newactivation ", "newclass      ", "getdescendants", "newcatch      ", "OP_0x5B       ", "OP_0x5C       ", "findpropstrict", "findproperty  ", "finddef       ", "getlex        ", "setproperty   ", "getlocal      ", "setlocal      ", "getglobalscope", "getscopeobject", "getproperty   ", "getouterscope ", "initproperty  ", "OP_0x69       ", "deleteproperty", "OP_0x6A       ", "getslot       ", "setslot       ", "getglobalslot ", "setglobalslot ", "convert_s     ", "esc_xelem     ", "esc_xattr     ", "convert_i     ", "convert_u     ", "convert_d     ", "convert_b     ", "convert_o     ", "checkfilter   ", "OP_0x79       ", "OP_0x7A       ", "OP_0x7B       ", "OP_0x7C       ", "OP_0x7D       ", "OP_0x7E       ", "OP_0x7F       ", "coerce        ", "coerce_b      ", "coerce_a      ", "coerce_i      ", "coerce_d      ", "coerce_s      ", "astype        ", "astypelate    ", "coerce_u      ", "coerce_o      ", "OP_0x8A       ", "OP_0x8B       ", "OP_0x8C       ", "OP_0x8D       ", "OP_0x8E       ", "OP_0x8F       ", "negate        ", "increment     ", "inclocal      ", "decrement     ", "declocal      ", "typeof        ", "not           ", "bitnot        ", "OP_0x98       ", "OP_0x99       ", "concat        ", "add_d         ", "OP_0x9C       ", "OP_0x9D       ", "OP_0x9E       ", "OP_0x9F       ", "add           ", "subtract      ", "multiply      ", "divide        ", "modulo        ", "lshift        ", "rshift        ", "urshift       ", "bitand        ", "bitor         ", "bitxor        ", "equals        ", "strictequals  ", "lessthan      ", "lessequals    ", "greaterthan   ", "greaterequals ", "instanceof    ", "istype        ", "istypelate    ", "in            ", "OP_0xB5       ", "OP_0xB6       ", "OP_0xB7       ", "OP_0xB8       ", "OP_0xB9       ", "OP_0xBA       ", "OP_0xBB       ", "OP_0xBC       ", "OP_0xBD       ", "OP_0xBE       ", "OP_0xBF       ", "increment_i   ", "decrement_i   ", "inclocal_i    ", "declocal_i    ", "negate_i      ", "add_i         ", "subtract_i    ", "multiply_i    ", "OP_0xC8       ", "OP_0xC9       ", "OP_0xCA       ", "OP_0xCB       ", "OP_0xCC       ", "OP_0xCD       ", "OP_0xCE       ", "OP_0xCF       ", "getlocal0     ", "getlocal1     ", "getlocal2     ", "getlocal3     ", "setlocal0     ", "setlocal1     ", "setlocal2     ", "setlocal3     ", "OP_0xD8       ", "OP_0xD9       ", "OP_0xDA       ", "OP_0xDB       ", "OP_0xDC       ", "OP_0xDD       ", "OP_0xDE       ", "OP_0xDF       ", "OP_0xE0       ", "OP_0xE1       ", "OP_0xE2       ", "OP_0xE3       ", "OP_0xE4       ", "OP_0xE5       ", "OP_0xE6       ", "OP_0xE7       ", "OP_0xE8       ", "OP_0xE9       ", "OP_0xEA       ", "OP_0xEB       ", "OP_0xEC       ", "OP_0xED       ", "OP_0xEE       ", "debug         ", "debugline     ", "debugfile     ", "bkptline      ", "timestamp     ", "OP_0xF4       ", "verifypass    ", "alloc         ", "mark          ", "wb            ", "prologue      ", "sendenter     ", "doubletoatom  ", "sweep         ", "codegenop     ", "verifyop      ", "decode        "};
    static final Multiname OpaqueAssetsType = new Multiname(null, "Class");
    private final FlexByteCodeInformationProcessor processor;
    int totalSize;
    final int[] opSizes;
    private final ByteBuffer data;
    Integer[] ints;
    Integer[] uints;
    Double[] doubles;
    @NonNls
    String[] strings;
    @NonNls
    String[] namespaces;
    @NonNls
    String[][] nssets;
    Multiname[] names;
    final Object[][] defaults;
    MethodInfo[] methods;
    Traits[] instances;
    Traits[] classes;
    Traits[] scripts;
    MetaData[] metadata;
    final int magic;
    static final TraitType[] traitTypes = TraitType.values();

    Abc(@NotNull ByteBuffer _data, @NotNull FlexByteCodeInformationProcessor _processor) {
        if (_data == null) {
            Abc.$$$reportNull$$$0(0);
        }
        if (_processor == null) {
            Abc.$$$reportNull$$$0(1);
        }
        this.opSizes = new int[256];
        this.defaults = new Object[Math.max(constantKinds.length, 29)][];
        this.data = _data;
        this.processor = _processor;
        this.data.setPosition(0);
        this.magic = this.data.readInt();
        _processor.dumpStat("magic " + Integer.toString(this.magic, 16) + "\n");
        if (this.magic != 0x2E000E && this.magic != 3014671 && this.magic != 3014672) {
            throw new Error("not an abc file.  magic=" + Integer.toString(this.magic, 16));
        }
        this.parseCpool();
        this.defaults[1] = this.strings;
        this.defaults[3] = this.ints;
        this.defaults[4] = this.uints;
        this.defaults[6] = this.doubles;
        this.defaults[3] = this.ints;
        this.defaults[10] = Abc.buildSparseArray(10, "false");
        this.defaults[11] = Abc.buildSparseArray(11, "true");
        this.defaults[8] = this.namespaces;
        this.defaults[5] = this.namespaces;
        this.defaults[22] = this.namespaces;
        this.defaults[23] = this.namespaces;
        this.defaults[24] = this.namespaces;
        this.defaults[25] = this.namespaces;
        this.defaults[26] = this.namespaces;
        this.defaults[12] = Abc.buildSparseArray(12, "null");
        this.parseMethodInfos();
        this.parseMetadataInfos();
        this.parseInstanceInfos();
        this.parseClassInfos();
        this.parseScriptInfos();
        this.parseMethodBodies();
    }

    private static Object[] buildSparseArray(int index, @NonNls String s1) {
        Object[] result = new Object[index + 1];
        result[index] = s1;
        return result;
    }

    public void dump(String indent) {
        for (Traits t : this.scripts) {
            this.processor.dumpTopLevelTraits(this, t, indent);
        }
        for (MethodInfo m : this.methods) {
            if (!m.anon) continue;
            this.processor.dumpToplevelAnonymousMethod(this, m);
        }
        this.processor.dumpStat("OPCODE\tSIZE\t% OF " + this.totalSize + "\n");
        HashSet<Integer> done = new HashSet<Integer>();
        while (true) {
            int max = -1;
            int maxsize = 0;
            for (int i = 0; i < 256; ++i) {
                if (this.opSizes[i] <= maxsize || done.contains(i)) continue;
                max = i;
                maxsize = this.opSizes[i];
            }
            if (max == -1) break;
            done.add(max);
            this.processor.dumpStat(opNames[max] + "\t" + this.opSizes[max] + "\t" + (int)(100.0f * (float)this.opSizes[max] / (float)this.totalSize) + "%\n");
        }
    }

    int readU32() {
        return this.data.readU32();
    }

    void parseCpool() {
        int i;
        int start = this.data.getPosition();
        int n = this.readU32();
        this.ints = new Integer[n > 0 ? n : 1];
        this.ints[0] = 0;
        for (i = 1; i < n; ++i) {
            this.ints[i] = this.readU32();
        }
        n = this.readU32();
        this.uints = new Integer[n > 0 ? n : 1];
        this.uints[0] = 0;
        for (i = 1; i < n; ++i) {
            this.uints[i] = this.readU32();
        }
        n = this.readU32();
        this.doubles = new Double[n > 0 ? n : 1];
        this.doubles[0] = Double.NaN;
        for (i = 1; i < n; ++i) {
            this.doubles[i] = this.data.readDouble();
        }
        Abc.reportAboutPercentage("Cpool numbers size ", this.data, start, this.processor);
        start = this.data.getPosition();
        n = this.readU32();
        this.strings = new String[n];
        this.strings[0] = PUBLIC_NS;
        for (i = 1; i < n; ++i) {
            this.strings[i] = this.data.readUTFBytes(this.readU32());
        }
        Abc.reportAboutPercentage("Cpool strings count " + n + " size ", this.data, start, this.processor);
        start = this.data.getPosition();
        n = this.readU32();
        this.namespaces = new String[n];
        this.namespaces[0] = PUBLIC_NS;
        block17: for (i = 1; i < n; ++i) {
            switch (this.data.readByte()) {
                case 8: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    this.namespaces[i] = this.strings[this.readU32()];
                    continue block17;
                }
                case 5: {
                    this.readU32();
                    this.namespaces[i] = PRIVATE_NS;
                }
            }
        }
        Abc.reportAboutPercentage("Cpool namespaces count " + n + " size ", this.data, start, this.processor);
        start = this.data.getPosition();
        n = this.readU32();
        this.nssets = new String[n][];
        for (i = 1; i < n; ++i) {
            int count = this.readU32();
            this.nssets[i] = new String[count];
            String[] nsset = this.nssets[i];
            for (int j = 0; j < count; ++j) {
                nsset[j] = this.namespaces[this.readU32()];
            }
        }
        Abc.reportAboutPercentage("Cpool nssets count " + n + " size ", this.data, start, this.processor);
        start = this.data.getPosition();
        n = this.readU32();
        this.names = new Multiname[n];
        this.namespaces[0] = anyNs;
        this.strings[0] = anyNs;
        class TypeNameInfo {
            int index;
            int base;
            TIntArrayList genericIndices;

            TypeNameInfo() {
            }
        }
        ArrayList<TypeNameInfo> typeNameInfos = new ArrayList<TypeNameInfo>();
        block20: for (i = 1; i < n; ++i) {
            switch (this.data.readByte()) {
                case 7: 
                case 13: {
                    this.names[i] = new Multiname(new String[]{this.namespaces[this.readU32()]}, this.strings[this.readU32()]);
                    continue block20;
                }
                case 15: 
                case 16: {
                    this.names[i] = new Multiname(new String[]{this.strings[this.readU32()]}, null);
                    continue block20;
                }
                case 17: 
                case 18: {
                    this.names[i] = null;
                    continue block20;
                }
                case 19: 
                case 20: {
                    this.names[i] = new Multiname(PUBLIC_NS_SET, null);
                    continue block20;
                }
                case 9: 
                case 14: {
                    String name = this.strings[this.readU32()];
                    this.names[i] = new Multiname(this.nssets[this.readU32()], name);
                    continue block20;
                }
                case 27: 
                case 28: {
                    this.names[i] = new Multiname(this.nssets[this.readU32()], null);
                    continue block20;
                }
                case 29: {
                    int nameId = this.readU32();
                    TypeNameInfo e = new TypeNameInfo();
                    typeNameInfos.add(e);
                    e.index = i;
                    e.base = nameId;
                    int count = this.readU32();
                    if (count > 0) {
                        e.genericIndices = new TIntArrayList();
                    }
                    if (count <= 0) continue block20;
                    for (int k = 0; k < count; ++k) {
                        nameId = this.readU32();
                        e.genericIndices.add(nameId);
                    }
                    continue block20;
                }
                default: {
                    throw new Error("invalid kind " + this.data.getByte(this.data.getPosition() - 1));
                }
            }
        }
        boolean hasSomething = false;
        boolean doneSomething = false;
        do {
            block23: for (TypeNameInfo tni : typeNameInfos) {
                String[] stringArray;
                if (this.names[tni.index] != null) continue;
                if (this.names[tni.base] == null) {
                    hasSomething = true;
                    continue;
                }
                String nsName = this.names[tni.base].toString();
                if (tni.genericIndices != null) {
                    nsName = nsName + ".<";
                    for (int k = 0; k < tni.genericIndices.size(); ++k) {
                        String typeArgNameString;
                        Multiname typeArgName;
                        if (k != 0) {
                            nsName = nsName + ",";
                        }
                        if ((typeArgName = this.names[tni.genericIndices.get(k)]) == null) continue block23;
                        if (this.processor instanceof AS3InterfaceDumper) {
                            boolean hasNotEmptyNs = typeArgName.hasNotEmptyNs();
                            boolean vector = hasNotEmptyNs && typeArgName.nsset[0].equals("__AS3__.vec");
                            boolean isPrivate = hasNotEmptyNs && typeArgName.nsset[0].equals(PRIVATE_NS);
                            typeArgNameString = vector || isPrivate ? typeArgName.name : typeArgName.toString();
                            typeArgNameString = StringUtil.replace((String)typeArgNameString, (String)"::", (String)".") + (vector ? " " : PUBLIC_NS);
                        } else {
                            typeArgNameString = typeArgName.toString();
                        }
                        nsName = nsName + typeArgNameString;
                    }
                    nsName = nsName + ">";
                }
                int index = nsName.indexOf("::");
                int n2 = tni.index;
                if (index != -1) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = nsName.substring(0, index);
                } else {
                    stringArray = PUBLIC_NS_SET;
                }
                this.names[n2] = new Multiname(stringArray, index != -1 ? nsName.substring(index + 2) : nsName);
                doneSomething = true;
            }
        } while (hasSomething && doneSomething);
        Abc.reportAboutPercentage("Cpool names count " + n + " size ", this.data, start, this.processor);
        start = this.data.getPosition();
        this.namespaces[0] = PUBLIC_NS;
        this.strings[0] = anyNs;
    }

    void parseMethodInfos() {
        int start = this.data.getPosition();
        this.names[0] = new Multiname(PUBLIC_NS_SET, anyNs);
        int method_count = this.readU32();
        this.methods = new MethodInfo[method_count];
        for (int i = 0; i < method_count; ++i) {
            int index;
            int k;
            MethodInfo m = this.methods[i] = new MethodInfo();
            int param_count = this.readU32();
            m.returnType = this.names[this.readU32()];
            if (m.returnType == null) {
                m.returnType = OpaqueAssetsType;
            }
            m.paramTypes = new Multiname[param_count];
            for (int j = 0; j < param_count; ++j) {
                m.paramTypes[j] = this.names[this.readU32()];
                if (m.paramTypes[j] != null) continue;
                m.paramTypes[j] = OpaqueAssetsType;
            }
            m.debugName = this.strings[this.readU32()];
            m.flags = this.data.readByte();
            if ((m.flags & 8) != 0) {
                int optional_count = this.readU32();
                m.optionalValues = new Multiname[param_count];
                for (k = param_count - optional_count; k < param_count; ++k) {
                    index = this.readU32();
                    int kind = this.data.readByte();
                    if (index == 0) {
                        String type = m.paramTypes[k].toString();
                        String value = "Number".equals(type) || "decimal".equals(type) ? "0" : (anyNs.equals(type) ? "null" : ("String".equals(type) ? PUBLIC_NS : "null"));
                        m.optionalValues[k] = new Multiname(null, value);
                        continue;
                    }
                    if (this.defaults[kind] == null) {
                        this.processor.hasError("ERROR kind=" + kind + " method_id " + i + "\n");
                        continue;
                    }
                    m.optionalValues[k] = new Multiname(null, this.defaults[kind][index].toString());
                }
            }
            if ((m.flags & 0x80) != 0) {
                if (param_count > 0) {
                    m.paramNames = new String[param_count];
                    THashSet usedNames = new THashSet(m.paramNames.length);
                    for (k = 0; k < param_count; ++k) {
                        index = this.readU32();
                        String name = this.strings[index];
                        m.paramNames[k] = StringUtil.isJavaIdentifier((String)name) && usedNames.add(name) ? name : "_" + k;
                    }
                } else {
                    m.paramNames = ArrayUtil.EMPTY_STRING_ARRAY;
                }
            }
            if ((m.flags & 4) == 0) continue;
            m.paramTypes = (Multiname[])ArrayUtil.append((Object[])m.paramTypes, (Object)new Multiname(null, "..."));
            if (m.paramNames == null) continue;
            boolean hasRestName = false;
            for (String s : m.paramNames) {
                if (!"rest".equals(s)) continue;
                hasRestName = true;
                break;
            }
            String element = hasRestName ? "__rest" : "rest";
            m.paramNames = (String[])ArrayUtil.append((Object[])m.paramNames, (Object)element);
        }
        Abc.reportAboutPercentage("MethodInfo count " + method_count + " size ", this.data, start, this.processor);
    }

    void parseMetadataInfos() {
        int count = this.readU32();
        this.metadata = new MetaData[count];
        for (int i = 0; i < count; ++i) {
            int q;
            MetaData m = this.metadata[i] = new MetaData();
            m.name = this.strings[this.readU32()];
            int values_count = this.readU32();
            String[] names = new String[values_count];
            for (q = 0; q < values_count; ++q) {
                names[q] = this.strings[this.readU32()];
            }
            for (q = 0; q < values_count; ++q) {
                m.put(names[q], this.strings[this.readU32()]);
            }
        }
    }

    void parseInstanceInfos() {
        int start = this.data.getPosition();
        int count = this.readU32();
        this.instances = new Traits[count];
        for (int i = 0; i < count; ++i) {
            Traits t = this.instances[i] = new Traits();
            t.name = this.names[this.readU32()];
            t.base = this.names[this.readU32()];
            t.flags = this.data.readByte();
            if ((t.flags & 8) != 0) {
                t.protectedNs = this.namespaces[this.readU32()];
            }
            int interface_count = this.readU32();
            t.interfaces = new Multiname[interface_count];
            for (int j = 0; j < interface_count; ++j) {
                t.interfaces[j] = this.names[this.readU32()];
            }
            MethodInfo m = t.init = this.methods[this.readU32()];
            m.name = (Multiname)t.name;
            m.kind = TraitType.Method;
            m.id = -1;
            m.parentTraits = t;
            this.parseTraits(t);
        }
        Abc.reportAboutPercentage("InstanceInfo size ", this.data, start, this.processor);
    }

    void parseTraits(Traits t) {
        int namecount = this.readU32();
        for (int i = 0; i < namecount; ++i) {
            TraitType kind;
            Multiname name = this.names[this.readU32()];
            int tag = this.data.readByte();
            int traitTypeTag = tag & 0xF;
            if (traitTypeTag >= traitTypes.length) {
                this.processor.hasError("error trait kind " + traitTypeTag + "\n");
                kind = null;
            } else {
                kind = traitTypes[traitTypeTag];
            }
            MemberInfo member = null;
            switch (kind) {
                case Slot: 
                case Const: 
                case Class: {
                    SlotInfo slot;
                    member = slot = new SlotInfo(name, kind);
                    slot.id = this.readU32();
                    t.slots.put(slot.id, slot);
                    if (kind == TraitType.Slot || kind == TraitType.Const) {
                        int index;
                        int typeIndex = this.readU32();
                        slot.type = this.names[typeIndex];
                        if (slot.type == null) {
                            slot.type = OpaqueAssetsType;
                        }
                        if ((index = this.readU32()) <= 0) break;
                        slot.value = this.defaults[this.data.readByte()][index];
                        break;
                    }
                    slot.value = this.classes[this.readU32()];
                    break;
                }
                case Method: 
                case Getter: 
                case Setter: {
                    int disp_id = this.readU32();
                    MethodInfo method = this.methods[this.readU32()];
                    member = method;
                    t.methods.put(disp_id, method);
                    method.id = disp_id;
                    member.kind = kind;
                    member.name = name;
                }
            }
            t.members.put(i, member);
            t.names.put(name.toString(), member);
            member.parentTraits = t;
            int val = tag >> 4;
            if ((val & 4) != 0) {
                int mdCount = this.readU32();
                member.metadata = new MetaData[mdCount];
                for (int j = 0; j < mdCount; ++j) {
                    member.metadata[j] = this.metadata[this.readU32()];
                }
            }
            if ((val & 1) != 0) {
                member.isFinal = true;
            }
            if ((val & 8) != 0) {
                member.isPublic = true;
            }
            if ((val & 2) == 0) continue;
            member.isOverride = true;
        }
    }

    void parseClassInfos() {
        int start = this.data.getPosition();
        int count = this.instances.length;
        this.classes = new Traits[count];
        for (int i = 0; i < count; ++i) {
            Traits t = this.classes[i] = new Traits();
            t.init = this.methods[this.readU32()];
            t.base = new Multiname(null, "Class");
            t.itraits = this.instances[i];
            this.instances[i].staticTrait = t;
            t.name = t.itraits.name + $;
            t.init.parentTraits = t;
            t.init.name = new Multiname(null, t.itraits.name + $CINIT);
            t.init.kind = TraitType.Method;
            this.parseTraits(t);
        }
        Abc.reportAboutPercentage("ClassInfo size ", this.data, start, this.processor);
    }

    void parseScriptInfos() {
        int start = this.data.getPosition();
        int count = this.readU32();
        this.scripts = new Traits[count];
        for (int i = 0; i < count; ++i) {
            Traits t;
            this.scripts[i] = t = new Traits();
            t.name = SCRIPT_PREFIX + i;
            t.base = this.names[0];
            t.init = this.methods[this.readU32()];
            t.init.name = new Multiname(null, t.name + "$init");
            t.init.kind = TraitType.Method;
            t.init.parentTraits = t;
            this.parseTraits(t);
        }
        Abc.reportAboutPercentage("ScriptInfo size ", this.data, start, this.processor);
    }

    void parseMethodBodies() {
        int start = this.data.getPosition();
        int count = this.readU32();
        for (int i = 0; i < count; ++i) {
            MethodInfo m = this.methods[this.readU32()];
            m.max_stack = this.readU32();
            m.local_count = this.readU32();
            int initScopeDepth = this.readU32();
            int maxScopeDepth = this.readU32();
            m.max_scope = maxScopeDepth - initScopeDepth;
            int code_length = this.readU32();
            m.code = new ByteBuffer();
            m.code.setLittleEndian();
            if (code_length > 0) {
                this.data.readBytes(m.code, code_length);
            }
            int ex_count = this.readU32();
            for (int j = 0; j < ex_count; ++j) {
                int from = this.readU32();
                int to = this.readU32();
                int target = this.readU32();
                Multiname type = this.names[this.readU32()];
                Multiname multiname = this.names[this.readU32()];
            }
            m.activation = new Traits();
            this.parseTraits(m.activation);
        }
        Abc.reportAboutPercentage("MethodBodies size ", this.data, start, this.processor);
    }

    private static void reportAboutPercentage(String s, ByteBuffer data, int start, @NotNull FlexByteCodeInformationProcessor processor) {
        if (processor == null) {
            Abc.$$$reportNull$$$0(2);
        }
        processor.dumpStat(s + (data.getPosition() - start) + " " + 100 * (data.getPosition() - start) / data.bytesSize() + " %\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flex/importer/Abc";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reportAboutPercentage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum TraitType {
        Slot,
        Method,
        Getter,
        Setter,
        Class,
        Function,
        Const;

    }
}

