/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfiguration;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfigurationType;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunnerParameters;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public class FlexUnitRuntimeConfigurationProducer
extends RunConfigurationProducer<FlexUnitRunConfiguration> {
    public FlexUnitRuntimeConfigurationProducer() {
        super(FlexUnitRunConfigurationType.class);
    }

    protected boolean setupConfigurationFromContext(FlexUnitRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Module module = context.getModule();
        if (module == null || ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return false;
        }
        PsiElement element = FlexUnitRuntimeConfigurationProducer.findTestElement(context.getPsiLocation());
        if (element == null) {
            return false;
        }
        if (!FlexUnitRuntimeConfigurationProducer.configureRunnerParameters(configuration.getRunnerParameters(), module, element)) {
            return false;
        }
        configuration.setGeneratedName();
        return true;
    }

    public boolean isConfigurationFromContext(FlexUnitRunConfiguration configuration, ConfigurationContext context) {
        Module module = context.getModule();
        if (module == null || ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return false;
        }
        PsiElement element = FlexUnitRuntimeConfigurationProducer.findTestElement(context.getPsiLocation());
        if (element == null) {
            return false;
        }
        FlexUnitRunnerParameters fakeParams = new FlexUnitRunnerParameters();
        if (!FlexUnitRuntimeConfigurationProducer.configureRunnerParameters(fakeParams, module, element)) {
            return false;
        }
        FlexUnitRunnerParameters params = configuration.getRunnerParameters();
        return !(!params.getModuleName().equals(fakeParams.getModuleName()) || params.getScope() != fakeParams.getScope() || params.getScope() == FlexUnitRunnerParameters.Scope.Package && !params.getPackageName().equals(fakeParams.getPackageName()) || params.getScope() != FlexUnitRunnerParameters.Scope.Package && !params.getClassName().equals(fakeParams.getClassName()) || params.getScope() == FlexUnitRunnerParameters.Scope.Method && !params.getMethodName().equals(fakeParams.getMethodName()));
    }

    private static boolean configureRunnerParameters(FlexUnitRunnerParameters params, Module module, PsiElement element) {
        FlexBuildConfigurationManager manager = FlexBuildConfigurationManager.getInstance(module);
        FlexUnitSupport support = null;
        FlexBuildConfiguration bc = null;
        if (module.getName().equals(params.getModuleName()) && !params.getBCName().isEmpty() && (bc = manager.findConfigurationByName(params.getBCName())) != null) {
            support = FlexUnitSupport.getSupport(bc, module);
        }
        if (support == null) {
            bc = manager.getActiveConfiguration();
            support = FlexUnitSupport.getSupport(bc, module);
        }
        if (support == null) {
            FlexBuildConfiguration anyBC;
            FlexBuildConfiguration[] flexBuildConfigurationArray = manager.getBuildConfigurations();
            int n = flexBuildConfigurationArray.length;
            for (int i = 0; i < n && (support = FlexUnitSupport.getSupport(bc = (anyBC = flexBuildConfigurationArray[i]), module)) == null; ++i) {
            }
        }
        if (support == null) {
            return false;
        }
        params.setModuleName(module.getName());
        params.setBCName(bc.getName());
        if (bc.getTargetPlatform() == TargetPlatform.Mobile) {
            if (bc.getAndroidPackagingOptions().isEnabled()) {
                params.setAppDescriptorForEmulator(FlashRunnerParameters.AppDescriptorForEmulator.Android);
            } else if (bc.getIosPackagingOptions().isEnabled()) {
                params.setAppDescriptorForEmulator(FlashRunnerParameters.AppDescriptorForEmulator.IOS);
            }
        }
        if (element instanceof JSClass) {
            JSClass clazz = (JSClass)element;
            if (!support.isTestClass(clazz, true)) {
                return false;
            }
            FlexUnitRuntimeConfigurationProducer.forClass(clazz, params);
        } else if (element instanceof JSFunction) {
            JSFunction method = (JSFunction)element;
            String methodName = method.getName();
            JSClass clazz = (JSClass)element.getParent();
            if (!support.isTestClass(clazz, true)) {
                return false;
            }
            if (methodName == null || !support.isTestMethod(method)) {
                FlexUnitRuntimeConfigurationProducer.forClass(clazz, params);
            } else {
                params.setClassName(clazz.getQualifiedName());
                params.setMethodName(methodName);
                params.setScope(FlexUnitRunnerParameters.Scope.Method);
            }
        } else if (element instanceof PsiDirectory) {
            if (!FlexUnitRuntimeConfigurationProducer.forDirectory((PsiDirectory)element, module, params)) {
                return false;
            }
        } else if (element instanceof PsiDirectoryContainer) {
            if (!FlexUnitRuntimeConfigurationProducer.forPackage((PsiDirectoryContainer)element, module, params)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean forPackage(PsiDirectoryContainer psiPackage, Module module, FlexUnitRunnerParameters params) {
        if (module == null) {
            return false;
        }
        for (PsiDirectory directory : psiPackage.getDirectories(module.getModuleScope())) {
            if (!FlexUnitRuntimeConfigurationProducer.forDirectory(directory, module, params)) continue;
            return true;
        }
        return false;
    }

    private static boolean forDirectory(PsiDirectory directory, Module module, FlexUnitRunnerParameters params) {
        VirtualFile file = directory.getVirtualFile();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex();
        VirtualFile rootForFile = projectFileIndex.getSourceRootForFile(file);
        if (rootForFile == null) {
            return false;
        }
        String packageName = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)rootForFile, (char)'.');
        if (packageName == null || !JSUtils.packageExists((String)packageName, (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module))) {
            return false;
        }
        params.setPackageName(packageName);
        params.setScope(FlexUnitRunnerParameters.Scope.Package);
        return true;
    }

    private static void forClass(JSClass clazz, FlexUnitRunnerParameters params) {
        params.setClassName(clazz.getQualifiedName());
        params.setScope(FlexUnitRunnerParameters.Scope.Class);
    }

    @Nullable
    private static PsiElement findTestElement(PsiElement element) {
        if (element.getLanguage().isKindOf(JavaScriptSupportLoader.JAVASCRIPT.getLanguage())) {
            PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class, JSClass.class, JSFile.class});
            if (parent instanceof JSClass) {
                return parent;
            }
            if (parent instanceof JSFunction && parent.getParent() instanceof JSClass) {
                return parent;
            }
            if (parent instanceof JSFile) {
                return JSPsiImplUtils.findClass((JSFile)((JSFile)parent));
            }
        } else {
            if (element instanceof PsiDirectory) {
                return element;
            }
            if (element instanceof PsiDirectoryContainer) {
                return element;
            }
        }
        return null;
    }
}

