/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.lang.javascript.flex.flexunit.ServerConnectionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventListener;

public class FlexUnitConnection
extends ServerConnectionBase {
    private static final String TERMINATE_MARKER = "Finish";
    private static final Logger LOG = Logger.getInstance((String)FlexUnitConnection.class.getName());
    protected final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);

    @Override
    protected void run(InputStream inputStream) throws IOException {
        String line;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        while (!this.isStopped() && !StringUtil.isEmpty((String)(line = dataInputStream.readUTF()))) {
            LOG.debug(line);
            if (TERMINATE_MARKER.equals(line)) {
                this.close();
                ((Listener)this.myDispatcher.getMulticaster()).onFinish();
                return;
            }
            ((Listener)this.myDispatcher.getMulticaster()).onData(line);
        }
    }

    public void addListener(Listener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    protected void setStatus(ServerConnectionBase.ConnectionStatus status) {
        super.setStatus(status);
        ((Listener)this.myDispatcher.getMulticaster()).statusChanged(status);
    }

    public static interface Listener
    extends EventListener {
        public void statusChanged(ServerConnectionBase.ConnectionStatus var1);

        public void onData(String var1);

        public void onFinish();
    }
}

