/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flashbuilder;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderImporter;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProjectFinder;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProjectLoadUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.SelectImportedProjectsStep;

public class SelectFlashBuilderImportedProjectsStep
extends SelectImportedProjectsStep<String> {
    public SelectFlashBuilderImportedProjectsStep(WizardContext context) {
        super(context);
    }

    protected String getElementText(String dotProjectFilePath) {
        StringBuilder builder = new StringBuilder();
        builder.append(FlashBuilderProjectLoadUtil.readProjectName(dotProjectFilePath));
        builder.append(" [");
        builder.append(FileUtil.toSystemDependentName((String)dotProjectFilePath), 0, dotProjectFilePath.length() - "1.project".length());
        builder.append("]");
        return builder.toString();
    }

    public boolean isStepVisible() {
        FlashBuilderImporter builder = (FlashBuilderImporter)this.getBuilder();
        if (builder == null) {
            return false;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(builder.getInitiallySelectedPath());
        if (file != null && (file.isDirectory() ? FlashBuilderProjectFinder.isFlashBuilderProject(file.findChild(".project")) : FlashBuilderProjectFinder.isFlashBuilderProject(file) || FlashBuilderProjectFinder.hasArchiveExtension(file.getPath()))) {
            return false;
        }
        return super.isStepVisible();
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.import.flex.page2";
    }
}

